/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.shared.common.internal;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.util.CacheHelper;
import com.ibm.team.workitem.shared.common.internal.WorkItemCommonScriptEnvironment;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class ScriptEnvironmentManager
extends CacheHelper {
    private static Map<String, ScriptEnvironmentManager> fgScriptEnvironmentManagers = new HashMap<String, ScriptEnvironmentManager>();
    private Map<UUID, WorkItemCommonScriptEnvironment> fScriptEngines = new HashMap<UUID, WorkItemCommonScriptEnvironment>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IScriptEnvironment getScriptEnvironment(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        ScriptEnvironmentManager manager;
        Map<String, ScriptEnvironmentManager> map = fgScriptEnvironmentManagers;
        synchronized (map) {
            manager = fgScriptEnvironmentManagers.get(auditableCommon.getRepositoryURI());
            if (manager == null) {
                manager = new ScriptEnvironmentManager(auditableCommon);
                fgScriptEnvironmentManagers.put(auditableCommon.getRepositoryURI(), manager);
            }
        }
        return manager.getScriptEnvironment(projectArea, monitor);
    }

    public ScriptEnvironmentManager(IAuditableCommon auditableCommon) {
        super(auditableCommon);
    }

    protected void updateCache(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkItemCommonScriptEnvironment scriptEngine = new WorkItemCommonScriptEnvironment(auditableCommon, projectAreaHandle);
        scriptEngine.initializeProjectAttachmentScripts(monitor);
        this.fScriptEngines.put(projectAreaHandle.getItemId(), scriptEngine);
    }

    public IScriptEnvironment getScriptEnvironment(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        return (IScriptEnvironment)this.fScriptEngines.get(projectArea.getItemId());
    }
}

