/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.setup.client.builder.internal;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.setup.client.repository.IPredefinedArtifact;
import com.ibm.team.foundation.setup.client.repository.ISetupContext;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.model.Helper;
import com.ibm.team.workitem.client.IDetailedStatus;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkflowUtilities;
import com.ibm.team.workitem.common.internal.model.Comment;
import com.ibm.team.workitem.common.internal.model.ModelFactory;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.util.SequenceValue;
import com.ibm.team.workitem.common.internal.util.Utils;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IPriority;
import com.ibm.team.workitem.common.model.ISeverity;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import com.ibm.team.workitem.setup.client.WorkItemSetupPlugin;
import com.ibm.team.workitem.setup.client.builder.WorkItemBuilder;
import com.ibm.team.workitem.setup.client.builder.internal.Messages;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemBuilderImpl
extends WorkItemBuilder {
    protected IProjectAreaHandle fProjectArea;
    protected String fType = null;
    protected String fSummary = null;
    protected String fDescription = null;
    protected ICategoryHandle fCategory = null;
    protected IContributorHandle fOwner = null;
    protected IIterationHandle fPlannedFor = null;
    protected IContributorHandle fCreator;
    protected Timestamp fCreationDate = null;
    protected Timestamp fDueDate = null;
    protected Long fDuration = null;
    protected Long fMinEstimate = null;
    protected Long fMaxEstimate = null;
    protected Identifier<IPriority> fPriority = null;
    protected Identifier<ISeverity> fSeverity = null;
    protected String fTags = null;
    protected boolean fResolved = false;
    protected SequenceValue fSequenceValue;
    protected List<IComment> fComments = new ArrayList<IComment>();
    private List<IWorkItem> fChildren = new ArrayList<IWorkItem>();
    private List<IWorkItem> fDuplicates = new ArrayList<IWorkItem>();
    private List<IWorkItem> fRelated = new ArrayList<IWorkItem>();
    private List<IWorkItem> fBlocks = new ArrayList<IWorkItem>();
    private Map<IAttribute, Object> fAttributes = new HashMap<IAttribute, Object>();

    public WorkItemBuilderImpl(ISetupContext projectSetupContext, IProjectAreaHandle projectArea) {
        super(projectSetupContext);
        this.fProjectArea = projectArea;
        this.fType = "task";
    }

    @Override
    public WorkItemBuilder predefined(IPredefinedArtifact<IWorkItem> artifact) {
        this.setPredefined(artifact);
        return this;
    }

    @Override
    public WorkItemBuilder type(String type) {
        this.fType = type;
        return this;
    }

    @Override
    public WorkItemBuilder summary(String summary) {
        this.fSummary = this.decorateHTMLForTVT(summary);
        return this;
    }

    @Override
    public WorkItemBuilder description(String description) {
        this.fDescription = this.decorateHTMLForTVT(description);
        return this;
    }

    @Override
    public WorkItemBuilder comment(IContributorHandle creator, Timestamp createdDate, String text) {
        Comment comment = ModelFactory.eINSTANCE.createComment();
        Utils.initNew((Helper)comment);
        comment.setCreator(creator);
        comment.setCreationDate(createdDate);
        comment.setContent(this.decorateHTMLForTVT(text));
        this.fComments.add((IComment)comment);
        return this;
    }

    @Override
    public WorkItemBuilder comment(IPredefinedArtifact<IContributor> creator, Timestamp createdDate, String text) {
        return this.comment((IContributorHandle)this.resolve(creator), createdDate, text);
    }

    @Override
    public WorkItemBuilder category(ICategoryHandle category) {
        this.fCategory = category;
        return this;
    }

    @Override
    public WorkItemBuilder category(IPredefinedArtifact<ICategory> category) {
        return this.category((ICategoryHandle)this.resolve(category));
    }

    @Override
    public WorkItemBuilder owner(IContributorHandle owner) {
        this.fOwner = owner;
        return this;
    }

    @Override
    public WorkItemBuilder owner(IPredefinedArtifact<IContributor> owner) {
        return this.owner((IContributorHandle)this.resolve(owner));
    }

    @Override
    public WorkItemBuilder plannedFor(IIterationHandle plannedFor) {
        this.fPlannedFor = plannedFor;
        return this;
    }

    @Override
    public WorkItemBuilder plannedFor(IPredefinedArtifact<IIteration> target) {
        return this.plannedFor((IIterationHandle)this.resolve(target));
    }

    @Override
    public WorkItemBuilder creator(IContributorHandle creator) {
        this.fCreator = creator;
        return this;
    }

    @Override
    public WorkItemBuilder creator(IPredefinedArtifact<IContributor> creator) {
        return this.creator((IContributorHandle)this.resolve(creator));
    }

    @Override
    public WorkItemBuilder creationDate(Timestamp creationDate) {
        this.fCreationDate = creationDate;
        return this;
    }

    @Override
    public WorkItemBuilder dueDate(Timestamp dueDate) {
        this.fDueDate = dueDate;
        return this;
    }

    @Override
    public WorkItemBuilder sequenceValue(double value) {
        this.fSequenceValue = SequenceValue.FACTORY.valueOf(Double.valueOf(value));
        return this;
    }

    @Override
    public WorkItemBuilder duration(long duration) {
        this.fDuration = new Long(duration);
        return this;
    }

    @Override
    public WorkItemBuilder minEstimate(long duration) {
        this.fMinEstimate = new Long(duration);
        return this;
    }

    @Override
    public WorkItemBuilder maxEstimate(long duration) {
        this.fMaxEstimate = new Long(duration);
        return this;
    }

    @Override
    public WorkItemBuilder priority(Identifier<IPriority> priority) {
        this.fPriority = priority;
        return this;
    }

    @Override
    public WorkItemBuilder priority(IPredefinedArtifact<Identifier<IPriority>> priority) {
        return this.priority((Identifier<IPriority>)((Identifier)this.resolve(priority)));
    }

    @Override
    public WorkItemBuilder severity(Identifier<ISeverity> severity) {
        this.fSeverity = severity;
        return this;
    }

    @Override
    public WorkItemBuilder severity(IPredefinedArtifact<Identifier<ISeverity>> severity) {
        return this.severity((Identifier<ISeverity>)((Identifier)this.resolve(severity)));
    }

    @Override
    public WorkItemBuilder tags(String tags) {
        this.fTags = tags;
        return this;
    }

    @Override
    public WorkItemBuilder resolved(boolean resolved) {
        this.fResolved = resolved;
        return this;
    }

    @Override
    public WorkItemBuilder child(IWorkItem workItem) {
        if (workItem != null) {
            this.fChildren.add(workItem);
        }
        return this;
    }

    @Override
    public WorkItemBuilder child(IPredefinedArtifact<IWorkItem> workItem) {
        return this.child((IWorkItem)this.resolve(workItem));
    }

    @Override
    public WorkItemBuilder relatedWorkItem(IWorkItem workItem) {
        if (workItem != null) {
            this.fRelated.add(workItem);
        }
        return this;
    }

    @Override
    public WorkItemBuilder relatedWorkItem(IPredefinedArtifact<IWorkItem> workItem) {
        return this.relatedWorkItem((IWorkItem)this.resolve(workItem));
    }

    @Override
    public WorkItemBuilder relatedArtifact(IItem artifact) {
        return this;
    }

    @Override
    public WorkItemBuilder relatedArtifact(IPredefinedArtifact<IItem> artifact) {
        return this.relatedArtifact((IItem)this.resolve(artifact));
    }

    @Override
    public WorkItemBuilder duplicate(IWorkItem workItem) {
        if (workItem != null) {
            this.fDuplicates.add(workItem);
        }
        return this;
    }

    @Override
    public WorkItemBuilder duplicate(IPredefinedArtifact<IWorkItem> workItem) {
        return this.duplicate((IWorkItem)this.resolve(workItem));
    }

    @Override
    public WorkItemBuilder blocks(IWorkItem workItem) {
        if (workItem != null) {
            this.fBlocks.add(workItem);
        }
        return this;
    }

    @Override
    public WorkItemBuilder attribute(IAttribute attribute, Object value) {
        this.fAttributes.put(attribute, value);
        return this;
    }

    @Override
    public WorkItemBuilder blocks(IPredefinedArtifact<IWorkItem> workItem) {
        return this.blocks((IWorkItem)this.resolve(workItem));
    }

    protected IWorkItem doBuild(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.WorkItemBuilderImpl_MONITOR_BUILD_WORK_ITEM, this.fResolved ? 8 : 5);
        try {
            IWorkItemClient workItemClient = (IWorkItemClient)this.getProjectSetupContext().getClientLibrary(IWorkItemClient.class);
            IWorkItemWorkingCopyManager workingCopyManager = workItemClient.getWorkItemWorkingCopyManager();
            IWorkItemType workItemType = workItemClient.findWorkItemType(this.fProjectArea, this.fType, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IWorkItemHandle handle = workingCopyManager.connectNew(workItemType, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            WorkItemWorkingCopy workingCopy = workingCopyManager.getWorkingCopy(handle);
            workingCopyManager.beginCompoundWorkItemChange((IWorkItemHandle)workingCopy.getWorkItem());
            try {
                if (this.fSummary != null) {
                    workingCopy.getWorkItem().setHTMLSummary(XMLString.createFromXMLText((String)this.fSummary));
                }
                if (this.fDescription != null) {
                    workingCopy.getWorkItem().setHTMLDescription(XMLString.createFromXMLText((String)this.fDescription));
                }
                if (this.fCategory != null) {
                    workingCopy.getWorkItem().setCategory(this.fCategory);
                }
                if (this.fOwner != null) {
                    workingCopy.getWorkItem().setOwner(this.fOwner);
                }
                if (this.fPlannedFor != null) {
                    workingCopy.getWorkItem().setTarget(this.fPlannedFor);
                }
                if (this.fCreationDate != null) {
                    workingCopy.getWorkItem().setCreationDate(this.fCreationDate);
                }
                if (this.fCreator != null) {
                    workingCopy.getWorkItem().setCreator(this.fCreator);
                }
                if (this.fDueDate != null) {
                    workingCopy.getWorkItem().setDueDate(this.fDueDate);
                }
                if (this.fDuration != null) {
                    workingCopy.getWorkItem().setDuration(this.fDuration.longValue());
                }
                if (this.fMinEstimate != null) {
                    IAttribute iAttribute = workItemClient.findAttribute(this.fProjectArea, "com.ibm.team.apt.estimate.minimal", (IProgressMonitor)new NullProgressMonitor());
                    if (!workingCopy.getWorkItem().hasAttribute(iAttribute)) {
                        workingCopy.getWorkItem().addCustomAttribute(iAttribute);
                    }
                    workingCopy.getWorkItem().setValue(iAttribute, (Object)this.fMinEstimate);
                }
                if (this.fMaxEstimate != null) {
                    IAttribute iAttribute = workItemClient.findAttribute(this.fProjectArea, "com.ibm.team.apt.estimate.maximal", (IProgressMonitor)new NullProgressMonitor());
                    if (!workingCopy.getWorkItem().hasAttribute(iAttribute)) {
                        workingCopy.getWorkItem().addCustomAttribute(iAttribute);
                    }
                    workingCopy.getWorkItem().setValue(iAttribute, (Object)this.fMaxEstimate);
                }
                if (this.fPriority != null) {
                    workingCopy.getWorkItem().setPriority(this.fPriority);
                }
                if (this.fSeverity != null) {
                    workingCopy.getWorkItem().setSeverity(this.fSeverity);
                }
                if (this.fTags != null) {
                    workingCopy.getWorkItem().setTags(this.fTags);
                }
                for (IComment iComment : this.fComments) {
                    workingCopy.getWorkItem().getComments().append(iComment);
                }
                if (this.fSequenceValue != null && this.fOwner != null) {
                    WorkItem workItem = (WorkItem)workingCopy.getWorkItem();
                    workItem.setInternalSequenceValue(this.fSequenceValue.serializeSequenceValue((IItemHandle)this.fOwner));
                }
                this.doSetLinks(workingCopy, this.fChildren, WorkItemEndPoints.CHILD_WORK_ITEMS);
                this.doSetLinks(workingCopy, this.fBlocks, WorkItemEndPoints.BLOCKS_WORK_ITEM);
                this.doSetLinks(workingCopy, this.fDuplicates, WorkItemEndPoints.DUPLICATE_WORK_ITEM);
                this.doSetLinks(workingCopy, this.fRelated, WorkItemEndPoints.RELATED_WORK_ITEM);
                for (Map.Entry entry : this.fAttributes.entrySet()) {
                    workingCopy.getWorkItem().setValue((IAttribute)entry.getKey(), entry.getValue());
                }
            }
            finally {
                workingCopyManager.endCompoundWorkItemChange(handle);
            }
            this.doApplyExtensions((IItem)workingCopy.getWorkItem(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IDetailedStatus iDetailedStatus = workingCopy.save((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (!iDetailedStatus.isOK()) {
                WorkItemSetupPlugin.getDefault().getLog().log((IStatus)iDetailedStatus);
                WorkItemSetupPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.team.workitem.setup", iDetailedStatus.getDetails()));
                throw new TeamRepositoryException(iDetailedStatus.getMessage());
            }
            workingCopyManager.disconnect(handle);
            if (this.fResolved) {
                Identifier resolveActionId;
                workingCopyManager.connect(handle, IWorkItem.DEFAULT_PROFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                workingCopy = workingCopyManager.getWorkingCopy(handle);
                IWorkflowInfo workflowInfo = WorkflowUtilities.findWorkflowInfo((IWorkItem)workingCopy.getWorkItem(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                String action = null;
                if (workflowInfo != null && (resolveActionId = workflowInfo.getResolveActionId()) != null) {
                    action = resolveActionId.getStringIdentifier();
                }
                workingCopy.setWorkflowAction(action);
                workingCopy.save((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                workingCopyManager.disconnect(handle);
            }
            IWorkItem iWorkItem = workItemClient.resolveWorkItem(handle, IWorkItem.FULL_PROFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            return iWorkItem;
        }
        finally {
            monitor.done();
        }
    }

    private void doSetLinks(WorkItemWorkingCopy workingCopy, List<IWorkItem> targets, IEndPointDescriptor endPoint) {
        IWorkItemReferences references = workingCopy.getReferences();
        for (IWorkItem target : targets) {
            references.add(endPoint, (IReference)WorkItemLinkTypes.createWorkItemReference((IWorkItem)target));
        }
    }

    protected void doAddLink(WorkItemWorkingCopy wc, IWorkItem other, IEndPointDescriptor endPoint, IProgressMonitor monitor) throws TeamRepositoryException {
        wc.getReferences().add(endPoint, (IReference)WorkItemLinkTypes.createWorkItemReference((IWorkItem)other));
    }
}

