/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.setup.client.builder.internal;

import com.ibm.team.foundation.setup.client.repository.IPredefinedArtifact;
import com.ibm.team.foundation.setup.client.repository.ISetupContext;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.client.workingcopies.IContributorListWorkingCopy;
import com.ibm.team.process.client.workingcopies.IProcessAreaWorkingCopy;
import com.ibm.team.process.client.workingcopies.ITeamWorkingCopy;
import com.ibm.team.process.client.workingcopies.IWorkingCopyManager;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.process.setup.client.builder.TeamAreaBuilder;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.IDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamAreaBuilderImpl
extends TeamAreaBuilder {
    protected IProjectAreaHandle fProjectArea;
    protected String fName = null;
    protected IDevelopmentLineHandle fDevelopmentLine = null;
    protected List<Member> fMembers = new ArrayList<Member>();
    protected List<TeamAreaBuilderImpl> fChildTeamAreas = new ArrayList<TeamAreaBuilderImpl>();
    private TeamAreaBuilderImpl fParentTeamAreaBuilder;
    private String fSummary;
    private String fDescription;

    public TeamAreaBuilderImpl(ISetupContext projectSetupContext, IProjectAreaHandle projectArea) {
        this(projectSetupContext, projectArea, null);
    }

    private TeamAreaBuilderImpl(ISetupContext projectSetupContext, IProjectAreaHandle projectArea, TeamAreaBuilderImpl parentTeamAreaBuilder) {
        super(projectSetupContext);
        this.fProjectArea = projectArea;
        this.fParentTeamAreaBuilder = parentTeamAreaBuilder;
    }

    @Override
    public TeamAreaBuilder predefined(IPredefinedArtifact<ITeamArea> artifact) {
        this.setPredefined(artifact);
        this.name(artifact.getName());
        return this;
    }

    public TeamAreaBuilder projectArea(IProjectAreaHandle projectArea) {
        this.fProjectArea = projectArea;
        return this;
    }

    @Override
    public TeamAreaBuilder name(String name) {
        this.fName = this.decorateForTVT(name);
        return this;
    }

    @Override
    public TeamAreaBuilder summary(String summary) {
        this.fSummary = this.decorateForTVT(summary);
        return this;
    }

    @Override
    public TeamAreaBuilder description(String description) {
        this.fDescription = this.decorateForTVT(description);
        return this;
    }

    @Override
    public TeamAreaBuilder developmentLine(IDevelopmentLineHandle developmentLine) {
        this.fDevelopmentLine = developmentLine;
        return this;
    }

    @Override
    public TeamAreaBuilder developmentLine(IPredefinedArtifact<IDevelopmentLine> developmentLine) {
        return this.developmentLine((IDevelopmentLineHandle)this.resolve(developmentLine));
    }

    @Override
    public TeamAreaBuilder teamMember(IContributorHandle contributor, IRole ... roles) {
        Member member = new Member(contributor);
        IRole[] iRoleArray = roles;
        int n = roles.length;
        int n2 = 0;
        while (n2 < n) {
            IRole role = iRoleArray[n2];
            member.fRoles.add(role);
            ++n2;
        }
        this.fMembers.add(member);
        return this;
    }

    @Override
    public TeamAreaBuilder teamMember(IPredefinedArtifact<IContributor> contributor, IPredefinedArtifact<IRole> ... roles) {
        Member member = new Member((IContributorHandle)this.resolve(contributor));
        IPredefinedArtifact<IRole>[] iPredefinedArtifactArray = roles;
        int n = roles.length;
        int n2 = 0;
        while (n2 < n) {
            IPredefinedArtifact<IRole> role = iPredefinedArtifactArray[n2];
            member.fRoles.add((IRole)this.resolve(role));
            ++n2;
        }
        this.fMembers.add(member);
        return this;
    }

    @Override
    public TeamAreaBuilder teamMember(IContributor contributor, IPredefinedArtifact<IRole> ... roles) {
        Member member = new Member((IContributorHandle)contributor);
        IPredefinedArtifact<IRole>[] iPredefinedArtifactArray = roles;
        int n = roles.length;
        int n2 = 0;
        while (n2 < n) {
            IPredefinedArtifact<IRole> role = iPredefinedArtifactArray[n2];
            member.fRoles.add((IRole)this.resolve(role));
            ++n2;
        }
        this.fMembers.add(member);
        return this;
    }

    @Override
    public TeamAreaBuilder subTeamArea() {
        TeamAreaBuilderImpl subTeamAreaBuilder = new TeamAreaBuilderImpl(this.getProjectSetupContext(), this.fProjectArea, this);
        this.fChildTeamAreas.add(subTeamAreaBuilder);
        return subTeamAreaBuilder;
    }

    @Override
    public TeamAreaBuilder subTeamAreaDone() {
        return this.fParentTeamAreaBuilder;
    }

    protected ITeamArea doBuild(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fParentTeamAreaBuilder == null ? this.internalBuild(null, monitor) : null;
    }

    private ITeamArea internalBuild(ITeamArea parent, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamWorkingCopy teamWorkingCopy;
        List currentMembers;
        IAuditableClient auditableClient = (IAuditableClient)this.getProjectSetupContext().getClientLibrary(IAuditableClient.class);
        IItemManager itemManager = this.getProjectSetupContext().getTeamRepository().itemManager();
        IProjectArea projectArea = (IProjectArea)itemManager.fetchCompleteItem((IItemHandle)this.fProjectArea, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        ITeamArea result = null;
        ITeamAreaHierarchy teamAreaHierarchy = projectArea.getTeamAreaHierarchy();
        Set children = parent != null ? teamAreaHierarchy.getChildren((ITeamAreaHandle)parent) : teamAreaHierarchy.getRoots();
        for (ITeamAreaHandle teamAreaHandle : children) {
            ITeamArea teamArea = (ITeamArea)auditableClient.resolveAuditable((IAuditableHandle)teamAreaHandle, ItemProfile.TEAM_AREA_DEFAULT, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (!teamArea.getName().equals(this.fName)) continue;
            result = teamArea;
        }
        if (result == null) {
            result = (ITeamArea)auditableClient.createAuditable(ITeamArea.ITEM_TYPE);
            result.setName(this.fName);
            result.setProjectArea((IProjectAreaHandle)projectArea);
            projectArea = (IProjectArea)projectArea.getWorkingCopy();
            if (parent == null) {
                IDevelopmentLine line = null;
                List lines = auditableClient.resolveAuditables(Arrays.asList(projectArea.getDevelopmentLines()), ItemProfile.DEVELOPMENT_LINE_DEFAULT, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                for (IDevelopmentLine current : lines) {
                    if (!current.sameItemId((IItemHandle)this.fDevelopmentLine)) continue;
                    line = current;
                    break;
                }
                projectArea.getTeamAreaHierarchy().addRoot((ITeamAreaHandle)result, line);
            } else {
                projectArea.getTeamAreaHierarchy().addChild((ITeamAreaHandle)parent, (ITeamAreaHandle)result);
            }
            this.doApplyExtensions((IItem)result, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ArrayList<Object> toBeSaved = new ArrayList<Object>();
            toBeSaved.add(projectArea);
            toBeSaved.add(result);
            List saveProcessItems = auditableClient.saveProcessItems(toBeSaved, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            result = (ITeamArea)saveProcessItems.get(1);
        }
        IProcessItemService processItemService = (IProcessItemService)this.getProjectSetupContext().getClientLibrary(IProcessItemService.class);
        IWorkingCopyManager workingCopyManager = processItemService.getWorkingCopyManager();
        IProcessAreaWorkingCopy processAreaWorkingCopy = (IProcessAreaWorkingCopy)workingCopyManager.createPrivateWorkingCopy((IProcessItem)result);
        if (this.fSummary != null) {
            IDocument summary = processAreaWorkingCopy.getSummary();
            summary.set(this.fSummary);
        }
        if (this.fDescription != null) {
            IDocument description = processAreaWorkingCopy.getDescription();
            description.set(this.fDescription);
        }
        if (!(currentMembers = (teamWorkingCopy = processAreaWorkingCopy.getTeam()).getContributors()).isEmpty()) {
            teamWorkingCopy.removeContributors(currentMembers.toArray(new IContributorHandle[currentMembers.size()]));
        }
        ArrayList<IContributor> resolvedMembers = new ArrayList<IContributor>();
        for (Member member : this.fMembers) {
            resolvedMembers.add((IContributor)itemManager.fetchCompleteItem((IItemHandle)member.fContributor, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
        }
        teamWorkingCopy.addContributors(resolvedMembers.toArray(new IContributor[resolvedMembers.size()]));
        for (Member member : this.fMembers) {
            teamWorkingCopy.setRoleCast(member.fContributor, member.fRoles.toArray(new IRole[member.fRoles.size()]));
        }
        IContributorListWorkingCopy administrators = processAreaWorkingCopy.getAdministrators();
        administrators.addContributors(new IContributor[]{(IContributor)itemManager.fetchCompleteItem((IItemHandle)auditableClient.getUser(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1))});
        processAreaWorkingCopy.save((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (parent != null) {
            this.doPostBuild((IItem)result);
        }
        for (TeamAreaBuilderImpl builder : this.fChildTeamAreas) {
            builder.internalBuild(result, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        return result;
    }

    private static class Member {
        IContributorHandle fContributor;
        List<IRole> fRoles = new ArrayList<IRole>();

        public Member(IContributorHandle contributor) {
            this.fContributor = contributor;
        }
    }
}

