/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.setup.client.builder.internal;

import com.ibm.team.foundation.setup.client.repository.IPredefinedArtifact;
import com.ibm.team.foundation.setup.client.repository.ISetupContext;
import com.ibm.team.process.client.IClientProcess;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.client.workingcopies.IContributorListWorkingCopy;
import com.ibm.team.process.client.workingcopies.IProcessAreaWorkingCopy;
import com.ibm.team.process.client.workingcopies.ITeamWorkingCopy;
import com.ibm.team.process.client.workingcopies.IWorkingCopyManager;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessDefinition;
import com.ibm.team.process.common.IProcessDefinitionHandle;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.internal.common.ProjectArea;
import com.ibm.team.process.setup.client.builder.ProjectAreaBuilder;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.ItemURI;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.IDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectAreaBuilderImpl
extends ProjectAreaBuilder {
    private String fProcessDefinitionId;
    private String fProcessDefinitionName;
    private String fProcessDefinitionDescription;
    private IContent fSpecification;
    private IContent fState;
    private String fProjectAreaName;
    protected IPredefinedArtifact<IDevelopmentLine> fDevelopmentLine = null;
    protected List<Member> fMembers = new ArrayList<Member>();
    private String fSummary;
    private String fDescription;
    private String fLocale;

    public ProjectAreaBuilderImpl(ISetupContext projectSetupContext) {
        super(projectSetupContext);
    }

    @Override
    public ProjectAreaBuilder predefined(IPredefinedArtifact<IProjectArea> artifact) {
        this.setPredefined(artifact);
        this.projectAreaName(artifact.getName());
        return this;
    }

    @Override
    public ProjectAreaBuilderImpl processDefinitionId(String id) {
        this.fProcessDefinitionId = id;
        return this;
    }

    @Override
    public ProjectAreaBuilderImpl processDefinitionName(String name) {
        this.fProcessDefinitionName = name;
        return this;
    }

    @Override
    public ProjectAreaBuilderImpl processDefinitionDescription(String description) {
        this.fProcessDefinitionDescription = description;
        return this;
    }

    @Override
    public ProjectAreaBuilderImpl processSpecification(IContent specification) {
        this.fSpecification = specification;
        return this;
    }

    @Override
    public ProjectAreaBuilderImpl processState(IContent state) {
        this.fState = state;
        return this;
    }

    @Override
    public ProjectAreaBuilderImpl projectAreaName(String name) {
        this.fProjectAreaName = this.decorateForTVT(name);
        return this;
    }

    @Override
    public ProjectAreaBuilder projectAreaSummary(String summary) {
        this.fSummary = this.decorateForTVT(summary);
        return this;
    }

    @Override
    public ProjectAreaBuilder projectAreaDescription(String description) {
        this.fDescription = this.decorateForTVT(description);
        return this;
    }

    @Override
    public ProjectAreaBuilder locale(String locale) {
        this.fLocale = locale;
        return this;
    }

    @Override
    public ProjectAreaBuilder developmentLine(IPredefinedArtifact<IDevelopmentLine> developmentLine) {
        this.fDevelopmentLine = developmentLine;
        return this;
    }

    @Override
    public ProjectAreaBuilderImpl teamMember(IPredefinedArtifact<IContributor> contributor, IPredefinedArtifact<IRole> ... roles) {
        Member member = new Member((IContributorHandle)this.resolve(contributor));
        IPredefinedArtifact<IRole>[] iPredefinedArtifactArray = roles;
        int n = roles.length;
        int n2 = 0;
        while (n2 < n) {
            IPredefinedArtifact<IRole> role = iPredefinedArtifactArray[n2];
            member.fRoles.add(role);
            ++n2;
        }
        this.fMembers.add(member);
        return this;
    }

    @Override
    public ProjectAreaBuilderImpl teamMember(IContributor contributor, IPredefinedArtifact<IRole> ... roles) {
        Member member = new Member((IContributorHandle)contributor);
        IPredefinedArtifact<IRole>[] iPredefinedArtifactArray = roles;
        int n = roles.length;
        int n2 = 0;
        while (n2 < n) {
            IPredefinedArtifact<IRole> role = iPredefinedArtifactArray[n2];
            member.fRoles.add(role);
            ++n2;
        }
        this.fMembers.add(member);
        return this;
    }

    protected IProjectArea doBuild(IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamWorkingCopy teamWorkingCopy;
        List currentMembers;
        IAuditableCommon auditableClient = (IAuditableCommon)this.getProjectSetupContext().getClientLibrary(IAuditableCommon.class);
        IItemManager itemManager = this.getProjectSetupContext().getTeamRepository().itemManager();
        IProcessDefinition processDefinition = auditableClient.findProcessDefinition(this.fProcessDefinitionId, ItemProfile.createFullProfile((IItemType)IProcessDefinition.ITEM_TYPE), monitor);
        IProcessItemService processItemService = (IProcessItemService)this.getProjectSetupContext().getClientLibrary(IProcessItemService.class);
        IWorkingCopyManager workingCopyManager = processItemService.getWorkingCopyManager();
        IContributor loggedInUser = (IContributor)itemManager.fetchCompleteItem((IItemHandle)auditableClient.getUser(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        IContent originalProcessState = null;
        IContent originalProcessSpec = null;
        Map definitionData = null;
        if (processDefinition == null) {
            processDefinition = (IProcessDefinition)auditableClient.createAuditable(IProcessDefinition.ITEM_TYPE);
            processDefinition.setProcessId(this.fProcessDefinitionId);
            processDefinition.setName(this.fProcessDefinitionName);
            processDefinition.getDescription().setSummary(this.fProcessDefinitionDescription);
            definitionData = processDefinition.getProcessData();
        } else {
            processDefinition = (IProcessDefinition)processDefinition.getWorkingCopy();
            definitionData = processDefinition.getProcessData();
            originalProcessState = (IContent)definitionData.get("com.ibm.team.internal.process.state.xml");
            originalProcessSpec = (IContent)definitionData.get("com.ibm.team.internal.process.compiled.xml");
        }
        definitionData.put("com.ibm.team.internal.process.state.xml", this.fState);
        definitionData.put("com.ibm.team.internal.process.compiled.xml", this.fSpecification);
        processDefinition = (IProcessDefinition)auditableClient.saveProcessItem((IProcessItem)processDefinition, monitor);
        IProjectArea projectArea = null;
        try {
            IProcessArea processArea = auditableClient.findProcessAreaByURI(new URI(ItemURI.encode((String)this.fProjectAreaName)), ItemProfile.createFullProfile((IItemType)IProjectArea.ITEM_TYPE), monitor);
            if (processArea instanceof IProjectArea) {
                projectArea = (IProjectArea)processArea;
            } else {
                projectArea = (IProjectArea)auditableClient.createAuditable(IProjectArea.ITEM_TYPE);
                projectArea.setName(this.fProjectAreaName);
                if (this.fLocale != null) {
                    ((ProjectArea)projectArea).setLocale(this.fLocale);
                }
                IProcessDefinition definition = auditableClient.findProcessDefinition(this.fProcessDefinitionId, ItemProfile.createFullProfile((IItemType)IProcessDefinition.ITEM_TYPE), monitor);
                projectArea.setProcessDefinition((IProcessDefinitionHandle)definition);
                projectArea = (IProjectArea)auditableClient.saveProcessItem((IProcessItem)projectArea, monitor);
                auditableClient.initializeProjectArea((IProjectAreaHandle)projectArea, monitor);
            }
        }
        catch (URISyntaxException x) {
            throw new TeamRepositoryException((Throwable)x);
        }
        if (originalProcessState != null || originalProcessSpec != null) {
            processDefinition = (IProcessDefinition)processDefinition.getWorkingCopy();
            definitionData = processDefinition.getProcessData();
            if (originalProcessState != null) {
                definitionData.put("com.ibm.team.internal.process.state.xml", originalProcessState);
            }
            if (originalProcessSpec != null) {
                definitionData.put("com.ibm.team.internal.process.compiled.xml", originalProcessSpec);
            }
            processDefinition = (IProcessDefinition)auditableClient.saveProcessItem((IProcessItem)processDefinition, monitor);
        }
        IProcessAreaWorkingCopy processAreaWorkingCopy = (IProcessAreaWorkingCopy)workingCopyManager.createPrivateWorkingCopy((IProcessItem)projectArea);
        if (this.fSummary != null) {
            IDocument summary = processAreaWorkingCopy.getSummary();
            summary.set(this.fSummary);
        }
        if (this.fDescription != null) {
            IDocument description = processAreaWorkingCopy.getDescription();
            description.set(this.fDescription);
        }
        if (!(currentMembers = (teamWorkingCopy = processAreaWorkingCopy.getTeam()).getContributors()).isEmpty()) {
            teamWorkingCopy.removeContributors(currentMembers.toArray(new IContributorHandle[currentMembers.size()]));
        }
        ArrayList<IContributor> resolvedMembers = new ArrayList<IContributor>();
        for (Member member : this.fMembers) {
            resolvedMembers.add((IContributor)itemManager.fetchCompleteItem((IItemHandle)member.fContributor, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
        }
        teamWorkingCopy.addContributors(resolvedMembers.toArray(new IContributor[resolvedMembers.size()]));
        IProcessItemService service = (IProcessItemService)this.getProjectSetupContext().getClientLibrary(IProcessItemService.class);
        IClientProcess clientProcess = service.getClientProcess((IProcessArea)projectArea, monitor);
        IRole[] availableRoles = clientProcess.getRoles((IProcessArea)projectArea, monitor);
        HashMap<IPredefinedArtifact<IRole>, IRole> allRoles = new HashMap<IPredefinedArtifact<IRole>, IRole>();
        for (Member member : this.fMembers) {
            block4: for (IPredefinedArtifact<IRole> predefinedRole : member.fRoles) {
                if (allRoles.containsKey(predefinedRole)) continue;
                allRoles.put(predefinedRole, null);
                IRole[] iRoleArray = availableRoles;
                int n = availableRoles.length;
                int n2 = 0;
                while (n2 < n) {
                    IRole role = iRoleArray[n2];
                    if (predefinedRole.isInstance((Object)role)) {
                        allRoles.put(predefinedRole, role);
                        continue block4;
                    }
                    ++n2;
                }
            }
        }
        for (Member member : this.fMembers) {
            ArrayList<IRole> actualRoles = new ArrayList<IRole>(member.fRoles.size());
            for (IPredefinedArtifact<IRole> predefinedRole : member.fRoles) {
                IRole actualRole = (IRole)allRoles.get(predefinedRole);
                if (actualRole == null) continue;
                actualRoles.add(actualRole);
            }
            if (actualRoles.isEmpty()) continue;
            teamWorkingCopy.setRoleCast(member.fContributor, actualRoles.toArray(new IRole[actualRoles.size()]));
        }
        IContributorListWorkingCopy administrators = processAreaWorkingCopy.getAdministrators();
        administrators.addContributors(new IContributor[]{loggedInUser});
        processAreaWorkingCopy.save((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (this.fDevelopmentLine != null) {
            List lines = auditableClient.resolveAuditables(Arrays.asList(projectArea.getDevelopmentLines()), ItemProfile.DEVELOPMENT_LINE_DEFAULT, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            for (IDevelopmentLine current : lines) {
                if (!this.fDevelopmentLine.isInstance((Object)current)) continue;
                projectArea = (IProjectArea)projectArea.getWorkingCopy();
                projectArea.setProjectDevelopmentLine((IDevelopmentLineHandle)current);
                projectArea = (IProjectArea)processItemService.save((IProcessItem)projectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                break;
            }
        }
        return projectArea;
    }

    private static class Member {
        IContributorHandle fContributor;
        List<IPredefinedArtifact<IRole>> fRoles = new ArrayList<IPredefinedArtifact<IRole>>();

        public Member(IContributorHandle contributor) {
            this.fContributor = contributor;
        }
    }
}

