/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.workitempicker;

import com.ibm.team.foundation.common.internal.util.Dates;
import com.ibm.team.jface.internal.FilteringElementSelector;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.expression.VariableAttributeExpression;
import com.ibm.team.workitem.common.expression.variables.IAttributeVariable;
import com.ibm.team.workitem.common.expression.variables.StatusVariable;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.query.IQueryResult;
import com.ibm.team.workitem.common.query.IResolvedResult;
import com.ibm.team.workitem.common.query.ResultSize;
import com.ibm.team.workitem.rcp.core.ClientModel;
import com.ibm.team.workitem.rcp.core.WorkItemEditorHistoryEntry;
import com.ibm.team.workitem.rcp.ui.internal.explorer.view.WorkItemFilter;
import com.ibm.team.workitem.rcp.ui.workitempicker.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemSelector
extends FilteringElementSelector {
    public static final IWorkItemHandle[] EMPTY_SELECTION = new IWorkItemHandle[0];
    private static final Point PREFERRED_TOOLTIP_FOCUS_SIZE = new Point(320, 200);
    private static final SelectionHistory fgSelectionHistory = new SelectionHistory(100);
    private WorkItemMatcher fMatcher;
    private ITeamRepository fRepository;
    private IProjectAreaHandle fProjectArea;
    private Object fMutex = new Object();
    private FilterList fFilterList = new FilterList();
    private Expression fExpression;
    private ResolvedAttributes fResolvedAttributes = new ResolvedAttributes();
    private ItemProfile<IWorkItem> fItemProfile;
    private ResultSize fLastResultSize = ResultSize.UNINITIALIZED;
    private ParameterUpdater fParameterUpdater = new ParameterUpdater();
    private IWorkItemType fWorkItemType;

    @Deprecated
    public WorkItemSelector(ITeamRepository repository, Composite parent, int flags, String initalPattern) {
        super(parent, flags, initalPattern, WorkItemSelector.createLabelProvider());
        this.fRepository = repository;
        new TooltipSupport((Control)this.getTable(), true, false).setPreferredFocusSize(PREFERRED_TOOLTIP_FOCUS_SIZE);
        fgSelectionHistory.initFromHistory();
    }

    public WorkItemSelector(IProjectAreaHandle projectArea, Composite parent, int flags, String initalPattern) {
        this(projectArea == null ? null : (ITeamRepository)projectArea.getOrigin(), parent, flags, initalPattern);
        this.fProjectArea = projectArea;
    }

    public void setProjectArea(IProjectAreaHandle projectAreaHandle) {
        this.fProjectArea = projectAreaHandle;
        this.fRepository = (ITeamRepository)projectAreaHandle.getOrigin();
        FilteringElementSelector.SyncJob syncJob = this.createSyncJob();
        syncJob.schedule();
    }

    public void setWorkItemType(IWorkItemType workItemType) {
        this.fWorkItemType = workItemType;
    }

    public void setSearchPattern(String text) {
        this.setSearchParameters(text, false, false);
    }

    public void setSearchParameters(String text, boolean currentUserOnly, boolean openStatesOnly) {
        this.fParameterUpdater.setSearchParameters(text, currentUserOnly, openStatesOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSearchParameters(String text, boolean currentUserOnly, boolean openStatesOnly) {
        Object object = this.fMutex;
        synchronized (object) {
            this.fMatcher = new WorkItemMatcher(text, currentUserOnly, openStatesOnly);
            super.setSearchPattern(text);
        }
    }

    public IWorkItemHandle[] getWorkItemHandles() {
        Object[] selection = this.getSelection();
        ArrayList<IWorkItemHandle> result = new ArrayList<IWorkItemHandle>();
        int i = 0;
        while (i < selection.length) {
            if (selection[i] instanceof IWorkItemHandle) {
                result.add((IWorkItemHandle)selection[i]);
            }
            ++i;
        }
        return result.toArray(new IWorkItemHandle[result.size()]);
    }

    public void setBaseExpression(Expression expression) {
        this.fExpression = expression;
    }

    public Expression getBaseExpression() {
        return this.fExpression;
    }

    public void addFilter(IFilter filter) {
        this.fFilterList.addFilter(filter);
    }

    public void removeFilter(IFilter filter) {
        this.fFilterList.removeFilter(filter);
    }

    public void clearFilters() {
        this.fFilterList.clearFilters();
    }

    public static void addToHistory(IWorkItemHandle[] handles) {
        int i = 0;
        while (i < handles.length) {
            fgSelectionHistory.add(handles);
            ++i;
        }
    }

    public static void addToHistory(IWorkItemHandle handle) {
        fgSelectionHistory.add(handle);
    }

    protected String getSeparatorMessage() {
        return Messages.WorkItemSelector_REPOSITORY_MATCHES;
    }

    protected FilteringElementSelector.SyncJob createSyncJob() {
        return new FilteringElementSelector.SyncJob(this){

            protected IStatus doSync(IProgressMonitor monitor) {
                try {
                    WorkItemSelector.this.fResolvedAttributes.resolve(WorkItemSelector.this.getRepository(), WorkItemSelector.this.fProjectArea, monitor);
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.workitem.rcp.ui", Messages.WorkItemSelector_RESOLVING_ATTRIBUTES_ERROR, (Throwable)e);
                }
            }
        };
    }

    protected FilteringElementSelector.AbstractSearchJob createSearchJob() {
        return new RepositoryBasedSearchJob((FilteringElementSelector)this);
    }

    protected boolean canUseCachedResult() {
        return false;
    }

    protected FilteringElementSelector.AbstractSearchJob createCachedSearchJob(Object[] cachedElements) {
        return null;
    }

    protected Object[] getHistoryElements() {
        try {
            List<IWorkItem> recentWorkItems = fgSelectionHistory.getWorkItems(this.getAuditableClient(), this.getItemProfile());
            ArrayList<IWorkItem> filteredWorkItems = new ArrayList<IWorkItem>(recentWorkItems.size());
            for (IWorkItem workItem : recentWorkItems) {
                if (!this.fMatcher.matches(workItem, (IProgressMonitor)new NullProgressMonitor()) || !this.fFilterList.select(workItem)) continue;
                filteredWorkItems.add(workItem);
            }
            return filteredWorkItems.toArray();
        }
        catch (TeamRepositoryException teamRepositoryException) {
            return new Object[0];
        }
    }

    private IQueryableAttribute getAttribute(String identifier) throws TeamRepositoryException {
        return this.fResolvedAttributes.getAttribute(this.fProjectArea, identifier);
    }

    private ItemProfile<IWorkItem> getItemProfile() {
        if (this.fItemProfile == null) {
            HashSet<String> properties = new HashSet<String>();
            properties.addAll(IWorkItem.SMALL_PROFILE.getProperties());
            properties.add(IWorkItem.SUMMARY_PROPERTY);
            properties.add(IWorkItem.DESCRIPTION_PROPERTY);
            properties.add(IWorkItem.OWNER_PROPERTY);
            properties.add(IWorkItem.PROJECT_AREA_PROPERTY);
            properties.add(IWorkItem.STATE_PROPERTY);
            this.fItemProfile = ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, properties);
        }
        return this.fItemProfile;
    }

    private IAuditableClient getAuditableClient() throws NotLoggedInException {
        return (IAuditableClient)this.getRepository().getClientLibrary(IAuditableClient.class);
    }

    private IQueryClient getQueryClient() throws NotLoggedInException {
        return (IQueryClient)this.getRepository().getClientLibrary(IQueryClient.class);
    }

    private ITeamRepository getRepository() throws NotLoggedInException {
        if (this.fRepository == null || !this.fRepository.loggedIn()) {
            throw new NotLoggedInException();
        }
        return this.fRepository;
    }

    private static FilteringElementSelector.ElementLabelProvider createLabelProvider() {
        return new FilteringElementSelector.ElementLabelProvider(){
            private StandardLabelProvider fLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
            private ViewerLabel fCachedLabel;
            private Object fLastElement;

            public String getText(Object element) {
                ViewerLabel label = this.getLabel(element);
                return label != null ? label.getText() : "";
            }

            public ImageDescriptor getImageDescriptor(Object element) {
                ViewerLabel label = this.getLabel(element);
                if (label == null) {
                    return null;
                }
                Image image = label.getImage();
                return image != null ? ImageDescriptor.createFromImage((Image)image) : null;
            }

            public Font getFont(Object element) {
                ViewerLabel label = this.getLabel(element);
                return label != null ? label.getFont() : null;
            }

            public void dispose() {
                this.fLabelProvider.dispose();
                this.fLabelProvider = null;
            }

            private ViewerLabel getLabel(Object element) {
                if (this.fLabelProvider == null) {
                    return null;
                }
                if (element == this.fLastElement) {
                    return this.fCachedLabel;
                }
                ViewerLabel label = new ViewerLabel(Messages.WorkItemSelector_UNKNOWN_LABEL, null);
                this.fLabelProvider.updateLabel(label, element);
                this.fLastElement = element;
                this.fCachedLabel = label;
                return label;
            }
        };
    }

    public ResultSize getLastResultSize() {
        return this.fLastResultSize;
    }

    private class CacheBasedSearchJob
    extends FilteringElementSelector.AbstractSearchJob {
        private CacheBasedSearchJob(FilteringElementSelector viewer) {
            super(viewer);
        }

        protected Object[] getHistoryResult(IProgressMonitor monitor) throws CoreException {
            return WorkItemSelector.this.getHistoryElements();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected FilteringElementSelector.SearchResult getSearchResult(Object[] historyElements, IProgressMonitor monitor) throws CoreException {
            try {
                ArrayList<IWorkItem> result = new ArrayList<IWorkItem>();
                ItemHandleAwareHashSet historyItems = new ItemHandleAwareHashSet();
                historyItems.addAll(Arrays.asList(historyElements));
                List cachedWorkItems = WorkItemSelector.this.getAuditableClient().findAllCachedAuditables(WorkItemSelector.this.getItemProfile());
                Object object = WorkItemSelector.this.fMutex;
                synchronized (object) {
                    if (WorkItemSelector.this.fMatcher.isReset()) {
                        WorkItemSelector.this.fLastResultSize = ResultSize.EMPTY;
                        return new FilteringElementSelector.SearchResult(result.toArray(), true);
                    }
                    for (IWorkItem workItem : cachedWorkItems) {
                        if (historyItems.contains((Object)workItem) || !WorkItemSelector.this.fMatcher.matches(workItem, monitor) || !WorkItemSelector.this.fFilterList.select(workItem)) continue;
                        result.add(workItem);
                    }
                    WorkItemSelector.this.fLastResultSize = new ResultSize(result.size(), -1);
                }
                return new FilteringElementSelector.SearchResult(result.toArray(), true);
            }
            catch (NotLoggedInException notLoggedInException) {
                return new FilteringElementSelector.SearchResult(new Object[0], true);
            }
            catch (TeamRepositoryException e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.team.workitem.rcp.ui", 4, e.getLocalizedMessage(), (Throwable)e));
            }
        }
    }

    private static class FilterList
    implements IFilter {
        private ArrayList<IFilter> fFilters = new ArrayList();

        private FilterList() {
        }

        public boolean select(Object toTest) {
            for (IFilter filter : this.fFilters) {
                if (filter.select(toTest)) continue;
                return false;
            }
            return true;
        }

        public void addFilter(IFilter filter) {
            if (!this.fFilters.contains(filter)) {
                this.fFilters.add(filter);
            }
        }

        public void removeFilter(IFilter filter) {
            this.fFilters.remove(filter);
        }

        public void clearFilters() {
            this.fFilters.clear();
        }
    }

    private class ParameterUpdater
    implements Runnable {
        private String fText;
        private boolean fCurrentUserOnly;
        private boolean fOpenStatesOnly;

        private ParameterUpdater() {
        }

        public void setSearchParameters(String text, boolean currentUserOnly, boolean openStatesOnly) {
            this.fText = text;
            this.fCurrentUserOnly = currentUserOnly;
            this.fOpenStatesOnly = openStatesOnly;
            if (!WorkItemSelector.this.getTable().isDisposed()) {
                WorkItemSelector.this.getTable().getDisplay().timerExec(500, (Runnable)this);
            }
        }

        public void run() {
            if (!WorkItemSelector.this.getTable().isDisposed()) {
                WorkItemSelector.this.updateSearchParameters(this.fText, this.fCurrentUserOnly, this.fOpenStatesOnly);
            }
        }
    }

    private class RepositoryBasedSearchJob
    extends CacheBasedSearchJob {
        private static final int PAGE_SIZE = 10;
        private static final int MAX_ITEMS = 100;
        private IQueryResult<IResolvedResult<IWorkItem>> fResult;
        private int fTotal;
        private int fMax;

        private RepositoryBasedSearchJob(FilteringElementSelector viewer) {
            super(viewer);
            this.fResult = null;
            this.fTotal = 0;
            this.fMax = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected FilteringElementSelector.SearchResult getSearchResult(Object[] historyElements, IProgressMonitor monitor) throws CoreException {
            ItemHandleAwareHashSet historyItems = new ItemHandleAwareHashSet();
            historyItems.addAll(Arrays.asList(historyElements));
            try {
                boolean isLastPage;
                if (this.fResult == null) {
                    this.fResult = WorkItemSelector.this.getQueryClient().getResolvedExpressionResults(WorkItemSelector.this.fProjectArea, WorkItemSelector.this.fMatcher.getExpression(monitor), WorkItemSelector.this.getItemProfile());
                    this.fResult.setPageSize(10);
                    this.fResult.setLimit(100);
                    monitor.beginTask(Messages.WorkItemSelector_SEARCHING_PROGRESS, 100);
                    ResultSize resultSize = this.fResult.getResultSize(monitor);
                    this.fMax = Math.min(resultSize.getTotal(), 100);
                    WorkItemSelector.this.fLastResultSize = resultSize;
                }
                List page = this.fResult.nextPage(monitor);
                if (this.fMax > 0) {
                    monitor.worked(page.size() * 100 / this.fMax);
                }
                this.fTotal += page.size();
                ArrayList<IWorkItem> result = new ArrayList<IWorkItem>();
                Object object = WorkItemSelector.this.fMutex;
                synchronized (object) {
                    if (WorkItemSelector.this.fMatcher.isReset()) {
                        return new FilteringElementSelector.SearchResult(result.toArray(), true);
                    }
                    for (IResolvedResult resolved : page) {
                        IWorkItem workItem = (IWorkItem)resolved.getItem();
                        if (historyItems.contains((Object)workItem) || !WorkItemSelector.this.fFilterList.select(workItem)) continue;
                        result.add(workItem);
                    }
                }
                boolean bl = isLastPage = !this.fResult.hasNext(null) || this.fTotal >= this.fMax;
                if (isLastPage) {
                    monitor.done();
                }
                return new FilteringElementSelector.SearchResult(result.toArray(), isLastPage);
            }
            catch (NotLoggedInException notLoggedInException) {
                return new FilteringElementSelector.SearchResult(new Object[0], true);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                return new FilteringElementSelector.SearchResult(new Object[0], true);
            }
            catch (TeamRepositoryException e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.team.workitem.rcp.ui", 4, e.getMessage(), (Throwable)e));
            }
        }
    }

    private static class ResolvedAttributes {
        private HashMap<UUID, HashMap<String, IQueryableAttribute>> fMap = new HashMap();

        private ResolvedAttributes() {
        }

        public void resolve(ITeamRepository repository, IProjectAreaHandle additionalProjectArea, IProgressMonitor monitor) throws TeamRepositoryException {
            IAuditableClient auditableClient = (IAuditableClient)repository.getClientLibrary(IAuditableClient.class);
            IQueryableAttributeFactory factory = QueryableAttributes.getFactory((IItemType)IWorkItem.ITEM_TYPE);
            ItemHandleAwareHashSet projectAreas = new ItemHandleAwareHashSet();
            projectAreas.addAll(ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(repository));
            if (additionalProjectArea != null) {
                projectAreas.add(additionalProjectArea);
            }
            for (IProjectAreaHandle projectAreaHandle : projectAreas) {
                this.addAttribute(projectAreaHandle, factory.findAttribute(projectAreaHandle, IWorkItem.ID_PROPERTY, (IAuditableCommon)auditableClient, monitor));
                this.addAttribute(projectAreaHandle, factory.findAttribute(projectAreaHandle, IWorkItem.PROJECT_AREA_PROPERTY, (IAuditableCommon)auditableClient, monitor));
                this.addAttribute(projectAreaHandle, factory.findAttribute(projectAreaHandle, IWorkItem.OWNER_PROPERTY, (IAuditableCommon)auditableClient, monitor));
                this.addAttribute(projectAreaHandle, factory.findAttribute(projectAreaHandle, IWorkItem.STATE_PROPERTY, (IAuditableCommon)auditableClient, monitor));
                this.addAttribute(projectAreaHandle, factory.findAttribute(projectAreaHandle, IWorkItem.TYPE_PROPERTY, (IAuditableCommon)auditableClient, monitor));
                this.addAttribute(projectAreaHandle, factory.findAttribute(projectAreaHandle, "all", (IAuditableCommon)auditableClient, monitor));
            }
        }

        public boolean isResolved(IProjectAreaHandle projectAreaHandle) {
            if (projectAreaHandle == null) {
                return false;
            }
            HashMap<String, IQueryableAttribute> attributeMap = this.fMap.get(projectAreaHandle.getItemId());
            return attributeMap != null && !attributeMap.isEmpty();
        }

        private void addAttribute(IProjectAreaHandle projectAreaHandle, IQueryableAttribute attribute) {
            HashMap<String, Object> attributeMap = this.fMap.get(projectAreaHandle.getItemId());
            if (attributeMap == null) {
                attributeMap = new HashMap();
                this.fMap.put(projectAreaHandle.getItemId(), attributeMap);
            }
            if (attribute != null) {
                attributeMap.put(attribute.getIdentifier(), attribute);
            }
        }

        public IQueryableAttribute getAttribute(IProjectAreaHandle projectAreaHandle, String identifier) throws ItemNotFoundException {
            HashMap<String, IQueryableAttribute> attributeMap = this.fMap.get(projectAreaHandle.getItemId());
            if (attributeMap == null) {
                throw new ItemNotFoundException(Messages.WorkItemSelector_ATTRIBUTE_NOT_FOUND);
            }
            IQueryableAttribute attribute = attributeMap.get(identifier);
            if (attribute == null) {
                throw new ItemNotFoundException(Messages.WorkItemSelector_ATTRIBUTE_NOT_FOUND);
            }
            return attribute;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SelectionHistory {
        private int fMaximum;
        private LinkedList<Entry> fHistory;

        public SelectionHistory(int max) {
            this.fMaximum = max;
            this.fHistory = new LinkedList();
        }

        private void add(Entry addition) {
            int index = this.fHistory.indexOf(addition);
            if (index > -1) {
                Entry existing = this.fHistory.get(index);
                if (existing.lastAccessed != null && addition.lastAccessed != null && existing.lastAccessed.before(addition.lastAccessed)) {
                    existing.lastAccessed = addition.lastAccessed;
                }
            } else {
                this.fHistory.add(addition);
            }
        }

        private void prune() {
            while (this.fHistory.size() > this.fMaximum) {
                this.fHistory.removeLast();
            }
        }

        private void sort() {
            Collections.sort(this.fHistory, new Comparator<Entry>(){

                @Override
                public int compare(Entry o1, Entry o2) {
                    return Dates.compareTo((Date)o2.lastAccessed, (Date)o1.lastAccessed);
                }
            });
        }

        public synchronized void add(IWorkItemHandle handle) {
            this.add(new Entry(handle));
            this.sort();
            this.prune();
        }

        public synchronized void add(IWorkItemHandle[] handles) {
            IWorkItemHandle[] iWorkItemHandleArray = handles;
            int n = handles.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkItemHandle handle = iWorkItemHandleArray[n2];
                this.add(new Entry(handle));
                ++n2;
            }
            this.sort();
            this.prune();
        }

        public synchronized void initFromHistory() {
            WorkItemEditorHistoryEntry[] history = ClientModel.getHistoryManager().getHistoryEntries();
            int i = 0;
            while (i < Math.min(history.length, this.fMaximum)) {
                this.add(new Entry(history[i].getWorkItem(), history[i].getDate()));
                ++i;
            }
            this.sort();
            this.prune();
        }

        public List<IWorkItem> getWorkItems(IAuditableClient auditableClient, ItemProfile profile) {
            LinkedList<IWorkItem> workItems = new LinkedList<IWorkItem>();
            for (Entry entry : this.fHistory) {
                IWorkItemHandle handle = (IWorkItemHandle)auditableClient.createAuditableHandle(IWorkItem.ITEM_TYPE, entry.itemId, null);
                IAuditable workItem = auditableClient.findCachedAuditable((IAuditableHandle)handle, profile);
                if (workItem == null) continue;
                workItems.add((IWorkItem)workItem);
            }
            return workItems;
        }

        private static class Entry {
            UUID itemId;
            Date lastAccessed;

            public Entry(IWorkItemHandle handle) {
                this(handle, new Date());
            }

            public Entry(IWorkItemHandle handle, Date timestamp) {
                this.itemId = handle.getItemId();
                this.lastAccessed = timestamp;
            }

            public boolean equals(Object obj) {
                if (obj instanceof Entry) {
                    return ((Entry)obj).itemId.equals((Object)this.itemId);
                }
                return false;
            }

            public int hashCode() {
                return this.itemId.hashCode();
            }
        }
    }

    private class WorkItemMatcher {
        private Expression fFilterExpression;
        private IFilter fFilter;
        private String fPattern;
        private boolean fCurrentUserOnly;
        private boolean fOpenStatesOnly;

        public WorkItemMatcher(String pattern, boolean currentUserOnly, boolean openStatesOnly) {
            this.fPattern = pattern;
            this.fCurrentUserOnly = currentUserOnly;
            this.fOpenStatesOnly = openStatesOnly;
        }

        public boolean matches(IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
            return this.getFilter(monitor).select((Object)workItem);
        }

        public boolean isReset() {
            return this.fPattern == null;
        }

        private IFilter getFilter(IProgressMonitor monitor) throws TeamRepositoryException {
            if (this.fFilter == null) {
                this.fFilter = WorkItemFilter.createFilter(this.fPattern, WorkItemSelector.this.fProjectArea, this.getExpression(monitor), monitor);
            }
            return this.fFilter;
        }

        public Expression getExpression(IProgressMonitor monitor) throws TeamRepositoryException {
            if (this.fFilterExpression == null) {
                this.fFilterExpression = WorkItemSelector.this.fExpression != null ? new Term(0, new Expression[]{WorkItemSelector.this.fExpression, this.createFilterExpression()}) : this.createFilterExpression();
            }
            return this.fFilterExpression;
        }

        private Expression createFilterExpression() throws TeamRepositoryException {
            int id = this.getId(this.fPattern);
            LinkedList<Object> expressions = new LinkedList<Object>();
            if (id > -1) {
                expressions.add(new AttributeExpression(WorkItemSelector.this.getAttribute(IWorkItem.ID_PROPERTY), AttributeOperation.EQUALS, (Object)new Integer(id)));
            } else {
                if (WorkItemSelector.this.fProjectArea != null) {
                    expressions.add(new AttributeExpression(WorkItemSelector.this.getAttribute(IWorkItem.PROJECT_AREA_PROPERTY), AttributeOperation.EQUALS, (Object)WorkItemSelector.this.fProjectArea));
                }
                if (this.fCurrentUserOnly) {
                    expressions.add(new AttributeExpression(WorkItemSelector.this.getAttribute(IWorkItem.OWNER_PROPERTY), AttributeOperation.EQUALS, (Object)WorkItemSelector.this.getRepository().loggedInContributor()));
                }
                if (this.fOpenStatesOnly) {
                    expressions.add(new VariableAttributeExpression(WorkItemSelector.this.getAttribute(IWorkItem.STATE_PROPERTY), AttributeOperation.EQUALS, (IAttributeVariable)new StatusVariable(5)));
                }
                if (WorkItemSelector.this.fWorkItemType != null) {
                    expressions.add(new AttributeExpression(WorkItemSelector.this.getAttribute(IWorkItem.TYPE_PROPERTY), AttributeOperation.EQUALS, (Object)WorkItemSelector.this.fWorkItemType.getIdentifier()));
                }
                expressions.add(new AttributeExpression(WorkItemSelector.this.getAttribute("all"), AttributeOperation.CONTAINS, (Object)this.fPattern));
            }
            if (expressions.size() > 1) {
                return new Term(0, expressions.toArray(new Expression[expressions.size()]));
            }
            return (Expression)expressions.get(0);
        }

        private int getId(String pattern) {
            if (pattern.length() == 0) {
                return -1;
            }
            char first = pattern.charAt(0);
            if (first == '#' || Character.isDigit(first)) {
                try {
                    String idText = first == '#' ? pattern.substring(1) : pattern;
                    return Integer.parseInt(idText);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return -1;
        }
    }
}

