/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards.templates;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemTemplateClient;
import com.ibm.team.workitem.common.internal.template.WorkItemTemplateDescriptor;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.template.IWorkItemTemplateDescriptor;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.DefineTemplateVariablesPage;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.Messages;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.SelectWorkItemsPage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewWorkItemTemplateWizard
extends Wizard
implements INewWizard {
    private List<IWorkItemHandle> fInput;
    private IWorkItem[] fWorkItems;
    private WorkItemTemplateDescriptor fTemplate;

    public NewWorkItemTemplateWizard() {
        this.setDefaultPageImageDescriptor(ImagePool.NEW_WORKITEM_TEMPLATE_WIZARD);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.NewWorkItemTemplateWizard_WIZARD_TITLE);
    }

    public IWorkItem[] getWorkItems() {
        return this.fWorkItems;
    }

    public WorkItemTemplateDescriptor getTemplateDescriptor() {
        if (this.fTemplate == null) {
            this.initializeWizard();
        }
        return this.fTemplate;
    }

    public void addPages() {
        super.addPage((IWizardPage)new SelectWorkItemsPage("selectWorkItemsPage", Messages.NewWorkItemTemplateWizard_SELECT_WORKITEMS_PAGE_TITLE, null));
        super.addPage((IWizardPage)new DefineTemplateVariablesPage("defineTemplateVariablesPage", Messages.NewWorkItemTemplateWizard_VARIABLES_PAGE_TITLE, null));
    }

    public boolean performFinish() {
        SelectWorkItemsPage selItemPage = (SelectWorkItemsPage)this.getPage("selectWorkItemsPage");
        if (selItemPage != null) {
            selItemPage.updateTemplate();
        }
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
                    try {
                        try {
                            progress.beginTask("", 1);
                            ((IWorkItemTemplateClient)NewWorkItemTemplateWizard.this.getRepository().getClientLibrary(IWorkItemTemplateClient.class)).createTemplate((IWorkItemTemplateDescriptor)NewWorkItemTemplateWizard.this.fTemplate, (IProgressMonitor)progress);
                            progress.worked(1);
                        }
                        catch (TeamRepositoryException ex) {
                            throw new InvocationTargetException(ex, ex.getMessage());
                        }
                        catch (IllegalStateException ex) {
                            throw new InvocationTargetException(ex, ex.getMessage());
                        }
                    }
                    finally {
                        progress.done();
                    }
                }
            });
        }
        catch (Exception ex) {
            if (ex instanceof InterruptedException) {
                throw new OperationCanceledException(ex.getLocalizedMessage());
            }
            WizardPage curPage = (WizardPage)this.getContainer().getCurrentPage();
            String reason = ex.getLocalizedMessage();
            if (reason == null) {
                curPage.setErrorMessage(Messages.NewWorkItemTemplateWizard_ERROR_ON_SAVE_TEMPLATE);
            } else {
                curPage.setErrorMessage(NLS.bind((String)Messages.NewWorkItemTemplateWizard_ERROR_REASON_SAVE_TEMPLATE, (Object)Messages.NewWorkItemTemplateWizard_ERROR_ON_SAVE_TEMPLATE, (Object[])new Object[]{reason}));
            }
            curPage.setPageComplete(false);
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            ArrayList<IWorkItemHandle> input = new ArrayList<IWorkItemHandle>();
            for (Object cur : selection.toList()) {
                if (!(cur instanceof IWorkItemHandle)) continue;
                input.add((IWorkItemHandle)cur);
            }
            this.fInput = input;
        }
    }

    private void initializeWizard() {
        try {
            this.fWorkItems = new IWorkItem[this.getInput() != null ? this.getInput().size() : 0];
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
                    try {
                        try {
                            progress.beginTask("", 3);
                            try {
                                if (!NewWorkItemTemplateWizard.this.getRepository().loggedIn()) {
                                    NewWorkItemTemplateWizard.this.getRepository().login((IProgressMonitor)progress);
                                }
                                progress.worked(1);
                                IAuditableClient client = (IAuditableClient)NewWorkItemTemplateWizard.this.getRepository().getClientLibrary(IAuditableClient.class);
                                List itemList = client.fetchCurrentAuditables(NewWorkItemTemplateWizard.this.getInput(), IWorkItem.DEFAULT_PROFILE, (IProgressMonitor)progress);
                                NewWorkItemTemplateWizard.this.fWorkItems = itemList.toArray(new IWorkItem[itemList.size()]);
                                progress.worked(1);
                            }
                            catch (TeamRepositoryException ex) {
                                throw new InvocationTargetException(ex, Messages.NewWorkItemTemplateWizard_ERROR_ON_RESOLVE_WORKITEM_HANDLES);
                            }
                            try {
                                IProjectAreaHandle project = null;
                                if (NewWorkItemTemplateWizard.this.fWorkItems.length > 0 && NewWorkItemTemplateWizard.this.fWorkItems[0] != null) {
                                    project = NewWorkItemTemplateWizard.this.fWorkItems[0].getProjectArea();
                                }
                                if (project != null) {
                                    IWorkItemTemplateClient templateClient = (IWorkItemTemplateClient)NewWorkItemTemplateWizard.this.getRepository().getClientLibrary(IWorkItemTemplateClient.class);
                                    NewWorkItemTemplateWizard.this.fTemplate = new WorkItemTemplateDescriptor(templateClient.createTemplateIdentifier(project, (IProgressMonitor)progress), project);
                                }
                                progress.worked(1);
                            }
                            catch (TeamRepositoryException ex) {
                                throw new InvocationTargetException(ex, Messages.NewWorkItemTemplateWizard_ERROR_ON_IDENTIFIER_GENERATION);
                            }
                        }
                        catch (IllegalStateException ex) {
                            throw new InvocationTargetException(ex, ex.getMessage());
                        }
                    }
                    finally {
                        progress.done();
                    }
                }
            });
        }
        catch (Exception ex) {
            if (ex instanceof InterruptedException) {
                throw new OperationCanceledException(ex.getLocalizedMessage());
            }
            this.reportErrorMessage(ex);
        }
    }

    private void reportErrorMessage(Exception ex) {
        WizardPage curPage = (WizardPage)this.getContainer().getCurrentPage();
        if (curPage != null) {
            curPage.setErrorMessage(ex.getLocalizedMessage());
            curPage.setPageComplete(false);
        }
    }

    private ITeamRepository getRepository() throws IllegalStateException {
        if (this.fInput == null) {
            throw new IllegalStateException(Messages.NewWorkItemTemplateWizard_ERROR_NO_WORKITEMS_SELECTED);
        }
        Iterator<IWorkItemHandle> iterator = this.fInput.iterator();
        if (iterator.hasNext()) {
            IWorkItemHandle cur = iterator.next();
            return (ITeamRepository)cur.getOrigin();
        }
        return null;
    }

    private List<IWorkItemHandle> getInput() {
        return this.fInput == null || this.fInput.size() == 0 ? Collections.emptyList() : this.fInput;
    }
}

