/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards.export;

import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.transport.client.ITeamRestServiceClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.internal.query.IExportDescriptor;
import com.ibm.team.workitem.common.internal.query.util.ExportLocations;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.util.RepositoryOperationRunnable;
import com.ibm.team.workitem.rcp.ui.internal.wizards.export.Messages;
import com.ibm.team.workitem.rcp.ui.internal.wizards.export.WorkItemExportWizardAttributePage;
import com.ibm.team.workitem.rcp.ui.internal.wizards.export.WorkItemExportWizardContext;
import com.ibm.team.workitem.rcp.ui.internal.wizards.export.WorkItemExportWizardMainPage;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemExportWizard
extends Wizard
implements IExportWizard {
    private WorkItemExportWizardContext fContext;
    private WorkItemExportWizardMainPage fMainPage;
    private WorkItemExportWizardAttributePage fAttributePage;
    private IWorkbench fWorkbench;

    public WorkItemExportWizard() {
        this.setWindowTitle(Messages.WorkItemExportWizard_WINDOW_TITLE);
        this.setNeedsProgressMonitor(true);
        this.initSettings();
    }

    private void initSettings() {
        IDialogSettings settings = WorkItemRCPUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection("WorkItemExportWizard");
        if (section == null) {
            section = settings.addNewSection("WorkItemExportWizard");
        }
        this.setDialogSettings(section);
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            IQueryDescriptor query = this.fContext.getQuery();
            IExportDescriptor exportDescriptor = this.fContext.getExportDescriptor();
            String repositoryURI = this.fContext.getTeamRepository().getRepositoryURI();
            Map<String, List<String>> parameters = this.createParameters();
            Location location = ExportLocations.createExportLocation((IQueryDescriptorHandle)query, (IExportDescriptor)exportDescriptor, parameters, (String)repositoryURI);
            File file = this.fetchContents(location);
            this.fContext.saveState(this.getDialogSettings());
            if (file != null && this.fContext.openAutomatically()) {
                WorkItemUI.open(this.fWorkbench.getActiveWorkbenchWindow().getActivePage(), file.toURI());
            }
            return file != null;
        }
        return false;
    }

    private Map<String, List<String>> createParameters() {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        ArrayList<String> columns = new ArrayList<String>();
        for (WorkItemExportWizardContext.Column column : this.fContext.getSelectedColumns()) {
            String identifier = column.attribute.getIdentifier();
            columns.add(identifier);
            if (column.showLabel) continue;
            parameters.put(identifier, Collections.singletonList("id"));
        }
        parameters.put("col", columns);
        parameters.put("_linkStyle", Collections.singletonList("absolute"));
        return parameters;
    }

    private File fetchContents(final Location location) {
        File file;
        block8: {
            ITeamRestServiceClient restClient;
            FileOutputStream outputStream;
            block7: {
                block6: {
                    try {
                        file = new File(this.fContext.getFilePath());
                        if (this.fContext.overWriteExisting() || !file.exists() || MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.WorkItemExportWizard_CONFIRM_REPLACE, (String)Messages.WorkItemExportWizard_OVERWRITE_EXISTING)) break block6;
                        return null;
                    }
                    catch (FileNotFoundException e) {
                        this.fMainPage.setErrorMessage(e.getLocalizedMessage());
                        return null;
                    }
                }
                outputStream = new FileOutputStream(file);
                TeamRepository repository = (TeamRepository)this.fContext.getTeamRepository();
                restClient = repository.getItemRestService();
                if (restClient != null) break block7;
                this.fMainPage.setErrorMessage(Messages.WorkItemExportWizard_LOCAL_REPOSITORY_NOT_SUPPORTED);
                return null;
            }
            RepositoryOperationRunnable<Boolean> runnable = new RepositoryOperationRunnable<Boolean>(){

                @Override
                protected Boolean performOperation(IProgressMonitor monitor) throws TeamRepositoryException {
                    InputStream inputStream = null;
                    try {
                        monitor.beginTask(Messages.WorkItemExportWizard_EXPORTING_WORKITEMS_PROGRESS, -1);
                        ITeamRestServiceClient.IRestClientConnection connection = restClient.getConnection(location);
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        ITeamRestServiceClient.IRestClientConnection.Response response = connection.doGet();
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        inputStream = response.getResponseStream();
                        try {
                            ClientUtils.copyStream((InputStream)inputStream, (OutputStream)outputStream, (IProgressMonitor)monitor);
                        }
                        catch (IOException e) {
                            throw new TeamRepositoryException(e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    catch (Throwable throwable) {
                        ClientUtils.silentClose(inputStream);
                        ClientUtils.silentClose((Closeable)outputStream);
                        monitor.done();
                        throw throwable;
                    }
                    ClientUtils.silentClose((Closeable)inputStream);
                    ClientUtils.silentClose((Closeable)outputStream);
                    monitor.done();
                    return true;
                }
            };
            runnable.run((IRunnableContext)this.getContainer());
            if (runnable.getStatus().isOK()) break block8;
            if (runnable.getStatus().getSeverity() != 8) {
                this.fMainPage.setErrorMessage(runnable.getStatus().getMessage());
            }
            return null;
        }
        return file;
    }

    public boolean canFinish() {
        return this.fContext.isInitialized() && this.fContext.getExportDescriptor() != null && this.fContext.getFilePath() != null && this.fContext.getFilePath().trim().length() > 0;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (!(page != this.fMainPage || this.fContext.getExportDescriptor() != null && this.fContext.getExportDescriptor().isColumnsSupported())) {
            return null;
        }
        return super.getNextPage(page);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fWorkbench = workbench;
        IQueryDescriptorHandle handle = null;
        if (selection.getFirstElement() instanceof IQueryDescriptorHandle) {
            handle = (IQueryDescriptorHandle)selection.getFirstElement();
        }
        this.fContext = new WorkItemExportWizardContext(handle);
        this.fContext.restoreState(this.getDialogSettings());
        this.fMainPage = new WorkItemExportWizardMainPage(this.fContext);
        this.fAttributePage = new WorkItemExportWizardAttributePage(this.fContext);
        this.addPage((IWizardPage)this.fMainPage);
        this.addPage((IWizardPage)this.fAttributePage);
    }
}

