/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards.bugzilla;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.rcp.ui.internal.ProjectAreaPicker;
import com.ibm.team.workitem.rcp.ui.internal.wizards.bugzilla.Messages;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WizardHelper {
    private static final int BUGINPUTS_SIZE = 40;

    public static Label createLabel(Composite parent, String text) {
        return WizardHelper.createIndentedLabel(parent, text, 0);
    }

    public static Label createIndentedLabel(Composite parent, String text, int indent) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 1;
        data.horizontalIndent = indent;
        label.setLayoutData((Object)data);
        return label;
    }

    public static Text createTextFieldWithSpan(Composite parent, int span) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData(1, 1, false, false, span, 1);
        data.widthHint = 40;
        text.setLayoutData((Object)data);
        return text;
    }

    public static Text createTextField(Composite parent) {
        return WizardHelper.createTextFieldWithSpan(parent, 1);
    }

    public static Composite createComposite(Composite parent, int numColumns, boolean fillHorizontal) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, fillHorizontal, true);
        composite.setLayoutData((Object)data);
        return composite;
    }

    public static Composite createIndentedComposite(Composite parent, int numColumns, int indent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, false, true);
        data.horizontalIndent = indent;
        composite.setLayoutData((Object)data);
        return composite;
    }

    public static Combo createProjectAreaCombo(Composite parent, IProjectAreaHandle[] areas, String selectedProjectAreaId) {
        Combo combo = new Combo(parent, 2060);
        combo.setLayoutData((Object)new GridData(4, 4, true, false));
        WizardHelper.restoreValuesForCombo(areas, selectedProjectAreaId, combo);
        return combo;
    }

    private static void restoreValuesForCombo(IProjectAreaHandle[] areas, String projectAreaId, Combo combo) {
        if (areas.length == 0) {
            return;
        }
        int index = 0;
        int i = 0;
        while (i < areas.length) {
            combo.add(ProjectAreaPicker.getUnambiguousProjectName(ProjectAreaPicker.getAllConnectedProjectAreas(true), areas[i]));
            if (areas[i].getItemId().getUuidValue().equals(projectAreaId)) {
                index = i;
            }
            ++i;
        }
        combo.select(index);
    }

    public static IProjectAreaHandle[] getLoggedInProjectAreas() {
        return ProjectAreaPicker.getAllConnectedProjectAreas(false).toArray(new IProjectAreaHandle[0]);
    }

    public static Combo createTeamRepositoryCombo(Composite parent, ITeamRepository[] services, String repositoryURI) {
        Combo combo = new Combo(parent, 2060);
        combo.setLayoutData((Object)new GridData(4, 4, true, false));
        WizardHelper.restoreValuesForCombo(services, repositoryURI, combo);
        return combo;
    }

    public static ITeamRepository[] getLoggedInTeamServices() {
        ArrayList<ITeamRepository> loggedIn = new ArrayList<ITeamRepository>();
        ITeamRepository[] teamRepositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < teamRepositories.length) {
            if (teamRepositories[i].loggedIn()) {
                loggedIn.add(teamRepositories[i]);
            }
            ++i;
        }
        return loggedIn.toArray(new ITeamRepository[loggedIn.size()]);
    }

    private static void restoreValuesForCombo(ITeamRepository[] services, String repositoryURI, Combo combo) {
        if (services.length == 0) {
            return;
        }
        int index = 0;
        int i = 0;
        while (i < services.length) {
            String name = services[i].getName();
            String uri = services[i].getRepositoryURI();
            if (name == null) {
                name = uri;
            }
            combo.add(name);
            if (uri.equals(repositoryURI)) {
                index = i;
            }
            ++i;
        }
        combo.select(index);
    }

    public static boolean requestUserConfirmation(Shell shell, ITeamRepository repository) {
        if (repository == null) {
            return false;
        }
        return WizardHelper.requestUserConfirmation(shell, repository.getRepositoryURI(), repository.getName(), false);
    }

    public static boolean requestUserConfirmation(Shell shell, IProjectAreaHandle projectArea, boolean isUpdate) {
        if (projectArea == null) {
            return false;
        }
        ITeamRepository repository = (ITeamRepository)projectArea.getOrigin();
        return WizardHelper.requestUserConfirmation(shell, repository.getRepositoryURI(), repository.getName(), isUpdate);
    }

    private static boolean requestUserConfirmation(Shell shell, String repositoryURI, String repositoryName, boolean isUpdate) {
        if (!repositoryURI.startsWith("local:")) {
            String title = Messages.WizardHelper_CONFIRM_IMPORT_TITLE;
            String message = isUpdate ? (repositoryName != null && repositoryName.length() > 0 ? NLS.bind((String)Messages.WizardHelper_WizardHelper_CONFIRM_IMPORT_UPDATE_QUESTION_WITH_NAME, (Object)repositoryName, (Object[])new Object[]{repositoryURI}) : NLS.bind((String)Messages.WizardHelper_WizardHelper_CONFIRM_IMPORT_UPDATE_QUESTION, (Object)repositoryURI, (Object[])new Object[0])) : (repositoryName != null && repositoryName.length() > 0 ? NLS.bind((String)Messages.WizardHelper_CONFIRM_IMPORT_QUESTION_WITH_NAME, (Object)repositoryName, (Object[])new Object[]{repositoryURI}) : NLS.bind((String)Messages.WizardHelper_CONFIRM_IMPORT_QUESTION, (Object)repositoryURI, (Object[])new Object[0]));
            MessageDialog dialog = new MessageDialog(shell, title, null, message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
            if (dialog.open() != 0) {
                return false;
            }
        }
        return true;
    }
}

