/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards.bugzilla;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaConfiguration;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaException;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaFilteredRetrieval;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaImporter;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaLogStatusMonitor;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaNumberedRetrieval;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaZipFileRetrieval;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.IBugRetrievalStrategy;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.IBugzillaStatusMonitor;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.BugzillaMapping;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.wizards.bugzilla.ImportBugzillaMainPage;
import com.ibm.team.workitem.rcp.ui.internal.wizards.bugzilla.Messages;
import com.ibm.team.workitem.rcp.ui.internal.wizards.bugzilla.SettingsHelper;
import com.ibm.team.workitem.rcp.ui.internal.wizards.bugzilla.WizardHelper;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class BugzillaImportWizard
extends Wizard
implements IImportWizard {
    ImportBugzillaMainPage fMainPage;

    public BugzillaImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(ImagePool.BUGZILLA_IMPORT_WIZARD);
        this.setWindowTitle(Messages.BugzillaImportWizard_IMPORT_BUGS);
    }

    public void addPages() {
        this.fMainPage = new ImportBugzillaMainPage("bugzillaImportMainPage", Messages.BugzillaImportWizard_IMPORT_BUGS, null);
        this.addPage((IWizardPage)this.fMainPage);
    }

    public boolean performFinish() {
        return BugzillaImportWizard.performOperation(this.getContainer(), this.fMainPage, null);
    }

    public static boolean performOperation(IWizardContainer container, ImportBugzillaMainPage mainPage, String computeMappingFile) {
        Object strategy;
        String bugzillaURL = mainPage.getBugzillaURL();
        String fromBug = mainPage.getFromBugId();
        String toBug = mainPage.getToBugId();
        String userName = mainPage.getUserName();
        String passWord = mainPage.getPassword();
        String saveFileName = mainPage.getSaveFileName();
        String[] saveDirList = mainPage.getSaveFileList();
        boolean needsAuthentication = mainPage.needsAuthentication();
        boolean isBasicHTTPAuthentication = mainPage.isBasicHTTPAuthentication();
        boolean saveXML = mainPage.isSaveXML();
        IProjectAreaHandle projectArea = mainPage.getProjectArea();
        boolean overWrite = mainPage.isOverWrite();
        boolean isBugzillaImport = mainPage.isBugzillaImport();
        boolean isFilteredImport = mainPage.isFilterProduct();
        final boolean isUseCustomMapping = mainPage.isUseCustomMapping();
        final String customMappingFile = mainPage.getCustomMappingFile();
        String[] customMappingFileList = mainPage.getCustomMappingFileList();
        String productName = mainPage.getProductName();
        String importFile = mainPage.getImportFile();
        String[] importDirList = mainPage.getImportFileList();
        SettingsHelper.saveImportWizardSettings(bugzillaURL, fromBug, toBug, productName, userName, needsAuthentication, isBasicHTTPAuthentication, saveXML, projectArea != null ? projectArea.getItemId().getUuidValue() : null, saveFileName, overWrite, saveDirList, importFile, importDirList, isBugzillaImport, isUseCustomMapping, customMappingFile, customMappingFileList);
        if (!isBugzillaImport) {
            bugzillaURL = "";
        }
        if (saveXML) {
            projectArea = null;
        }
        if (computeMappingFile == null && projectArea != null && !WizardHelper.requestUserConfirmation(container.getShell(), projectArea, false)) {
            return false;
        }
        final BugzillaConfiguration configuration = new BugzillaConfiguration(bugzillaURL, projectArea);
        configuration.setComputeMappingFileOnly(computeMappingFile != null);
        configuration.setSaveMappingFile(computeMappingFile);
        if (isBugzillaImport) {
            configuration.setNeedsAuthentication(needsAuthentication);
            configuration.setIsBasicHTTPAuthentication(isBasicHTTPAuthentication);
            configuration.setUsername(userName);
            configuration.setPassword(passWord);
            configuration.setIsSaveXML(saveXML);
            if (saveXML) {
                configuration.setOverWriteExisting(overWrite);
                configuration.setSaveFileName(saveFileName);
            }
        }
        if (!isBugzillaImport) {
            try {
                strategy = new BugzillaZipFileRetrieval(importFile);
            }
            catch (BugzillaException e) {
                ErrorDialog.openError((Shell)container.getShell(), (String)Messages.BugzillaImportWizard_ERROR_IMPORTING_BUGS, null, (IStatus)e.getStatus());
                return false;
            }
        } else {
            strategy = isFilteredImport ? new BugzillaFilteredRetrieval(configuration, productName) : new BugzillaNumberedRetrieval(configuration, Integer.parseInt(fromBug), Integer.parseInt(toBug));
        }
        try {
            container.run(true, true, new IRunnableWithProgress((IBugRetrievalStrategy)strategy){
                private final /* synthetic */ IBugRetrievalStrategy val$strategy;
                {
                    this.val$strategy = iBugRetrievalStrategy;
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    BugzillaLogStatusMonitor statusMonitor;
                    block7: {
                        if (isUseCustomMapping) {
                            try {
                                URL url = new File(customMappingFile).toURL();
                                BugzillaMapping customMapping = BugzillaMapping.readMapping((String)url.toString());
                                configuration.setMapping(customMapping);
                            }
                            catch (MalformedURLException x) {
                                throw new InvocationTargetException(x);
                            }
                            catch (TeamRepositoryException x) {
                                throw new InvocationTargetException(x);
                            }
                        }
                        BugzillaImporter importer = new BugzillaImporter(configuration);
                        statusMonitor = new BugzillaLogStatusMonitor();
                        try {
                            importer.doImport(this.val$strategy, (IBugzillaStatusMonitor)statusMonitor, monitor);
                        }
                        catch (OperationCanceledException x) {
                            IStatus status = statusMonitor.getStatus();
                            if (!status.isOK()) break block7;
                            throw x;
                        }
                    }
                    IStatus status = statusMonitor.getStatus();
                    if (!status.isOK()) {
                        throw new InvocationTargetException(new CoreException(status));
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            Object status = null;
            status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, "com.ibm.team.workitem.rcp.ui", 4, Messages.BugzillaImportWizard_ERROR_IMPORTING_BUGS, t);
            ErrorDialog.openError((Shell)container.getShell(), (String)Messages.BugzillaImportWizard_ERROR_IMPORTING_BUGS, null, (IStatus)status);
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

