/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards;

import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.actions.NewWorkItemAction;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ItemComparer;
import com.ibm.team.workitem.rcp.ui.internal.wizards.INewWorkItemWizardContext;
import com.ibm.team.workitem.rcp.ui.internal.wizards.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectWorkItemTypeWizardPage
extends WizardPage {
    private INewWorkItemWizardContext fContext;
    private TableViewer fViewer;
    ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());

    public SelectWorkItemTypeWizardPage(INewWorkItemWizardContext context) {
        super(Messages.SelectWorkItemTypeWizardPage_CHOOSE_WORK_ITEM_TYPE_PAGE, Messages.SelectWorkItemTypeWizardPage_CHOOSE_WORK_ITEM_TYPE_PAGE, null);
        this.fContext = context;
        this.setDescription(Messages.SelectWorkItemTypeWizardPage_CHOOSE_WORK_ITEM_TYPE_PAGE_DESCRIPTION);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(Messages.SelectWorkItemTypeWizardPage_WORK_ITEM_TYPES);
        this.fViewer = new TableViewer(container, 2820);
        this.fViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fViewer.setContentProvider((IContentProvider)new SimpleContentProvider());
        this.fViewer.setComparer((IElementComparer)new ItemComparer());
        this.setPageComplete(false);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        HelpContextIds.hookHelpListener((Control)container, "com.ibm.team.workitem.rcp.ui.new_work_item_wizard_work_item_type_page");
    }

    public void setVisible(boolean visible) {
        try {
            if (visible) {
                this.computeTypes();
            } else {
                this.setPageComplete(false);
            }
        }
        catch (InterruptedException interruptedException) {
            FoundationUIJob j = new FoundationUIJob(Messages.SelectWorkItemTypeWizardPage_CLOSING_WIZARD){

                protected IStatus runProtectedInUI(IProgressMonitor monitor) throws Exception {
                    SelectWorkItemTypeWizardPage.this.getWizard().performCancel();
                    if (SelectWorkItemTypeWizardPage.this.getContainer() instanceof WizardDialog) {
                        ((WizardDialog)SelectWorkItemTypeWizardPage.this.getContainer()).close();
                    }
                    return Status.OK_STATUS;
                }
            };
            j.setSystem(true);
            j.schedule();
        }
        super.setVisible(visible);
    }

    private void computeTypes() throws InterruptedException {
        try {
            this.setMessage(null, 0);
            if (this.fContext.getProjectArea() != null) {
                final ArrayList<IWorkItemType> types = new ArrayList<IWorkItemType>();
                final ITeamRepository repository = (ITeamRepository)this.fContext.getProjectArea().getOrigin();
                if (!repository.loggedIn()) {
                    this.fViewer.setInput((Object)new String[]{Messages.SelectWorkItemTypeWizardPage_WAITING_FOR_LOGIN});
                    this.getContainer().run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                repository.login(monitor);
                            }
                            catch (OperationCanceledException operationCanceledException) {
                                if (monitor.isCanceled()) {
                                    throw new InterruptedException();
                                }
                            }
                            catch (TeamRepositoryException x) {
                                throw new InvocationTargetException(x, x.getMessage());
                            }
                        }
                    });
                }
                if (!repository.loggedIn()) {
                    this.fViewer.setInput((Object)Messages.SelectWorkItemTypeWizardPage_NOT_LOGGED_IN);
                } else {
                    this.getContainer().run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                IWorkItemClient workItemClient = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
                                types.addAll(NewWorkItemAction.findWorkItemTypes(workItemClient, SelectWorkItemTypeWizardPage.this.fContext.getProjectArea(), monitor));
                                if (monitor.isCanceled()) {
                                    throw new InterruptedException();
                                }
                            }
                            catch (OperationCanceledException operationCanceledException) {
                                if (monitor.isCanceled()) {
                                    throw new InterruptedException();
                                }
                            }
                            catch (TeamRepositoryException x) {
                                throw new InvocationTargetException(x, x.getMessage());
                            }
                        }
                    });
                    if (types.isEmpty()) {
                        this.fViewer.setInput((Object)NewWorkItemAction.NO_TYPES_AVAILABLE_TITLE);
                        this.setMessage(NewWorkItemAction.NO_TYPES_AVAILABLE_MESSAGE, 1);
                    } else {
                        this.fViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                            public Image getImage(Object element) {
                                if (element instanceof IWorkItemType && ((IWorkItemType)element).getIconURL() != null) {
                                    return JazzResources.getImageWithDefault((ResourceManager)SelectWorkItemTypeWizardPage.this.fResourceManager, (ImageDescriptor)WorkItemUI.getImageDescriptor(((IWorkItemType)element).getIconURL()));
                                }
                                return null;
                            }

                            public String getText(Object element) {
                                if (element instanceof IWorkItemType) {
                                    return ((IWorkItemType)element).getDisplayName();
                                }
                                if (element instanceof String) {
                                    return (String)element;
                                }
                                return "";
                            }
                        });
                        this.fViewer.setInput(types);
                        this.fViewer.addOpenListener(new IOpenListener(){

                            public void open(OpenEvent event) {
                                IWizardContainer container = SelectWorkItemTypeWizardPage.this.getContainer();
                                if (container instanceof WizardDialog) {
                                    WizardDialog dialog = (WizardDialog)container;
                                    if (SelectWorkItemTypeWizardPage.this.getWizard().canFinish()) {
                                        try {
                                            SelectWorkItemTypeWizardPage.this.getWizard().performFinish();
                                        }
                                        finally {
                                            dialog.close();
                                        }
                                    }
                                }
                            }
                        });
                        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                            public void selectionChanged(SelectionChangedEvent event) {
                                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                                SelectWorkItemTypeWizardPage.this.fContext.setType((IWorkItemType)selection.getFirstElement());
                            }
                        });
                        if (this.fContext.getType() != null && types.contains(this.fContext.getType())) {
                            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)this.fContext.getType()));
                        } else if (this.fContext.getTypeId() != null && this.find(types, this.fContext.getTypeId()) != null) {
                            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)this.find(types, this.fContext.getTypeId())));
                        } else {
                            this.fViewer.setSelection((ISelection)new StructuredSelection(this.fViewer.getElementAt(0)));
                        }
                    }
                }
            } else {
                this.fViewer.setInput((Object)Messages.SelectWorkItemTypeWizardPage_NO_PROJECT_AREA_SELECTED);
            }
        }
        catch (InvocationTargetException x) {
            this.fViewer.setInput((Object)x.getMessage());
        }
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        this.setPageComplete(selection.getFirstElement() instanceof IWorkItemType);
    }

    private IWorkItemType find(List<IWorkItemType> types, String typeId) {
        for (IWorkItemType type : types) {
            if (!type.getIdentifier().equals(typeId)) continue;
            return type;
        }
        return null;
    }

    public void dispose() {
        this.fResourceManager.dispose();
    }

    private static class SimpleContentProvider
    implements IStructuredContentProvider {
        private SimpleContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[]{inputElement};
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

