/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.rcp.ui.internal.ConnectedProjectAreas;
import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.ProjectAreaPicker;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ItemComparer;
import com.ibm.team.workitem.rcp.ui.internal.wizards.INewWorkItemWizardContext;
import com.ibm.team.workitem.rcp.ui.internal.wizards.Messages;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SelectProjectAreaWizardPage
extends WizardPage {
    private INewWorkItemWizardContext fContext;
    private TableViewer fViewer;
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private ProjectAreaPicker.ProjectAreaLabelProvider fLabelProvider = new ProjectAreaPicker.ProjectAreaLabelProvider(ProjectAreaPicker.getAllConnectedProjectAreas(true));

    public SelectProjectAreaWizardPage(INewWorkItemWizardContext context) {
        super(Messages.SelectProjectAreaWizardPage_CHOOSE_PROJECT_AREA_PAGE, Messages.SelectProjectAreaWizardPage_CHOOSE_PROJECT_AREA_PAGE, null);
        this.fContext = context;
        this.setDescription(Messages.SelectProjectAreaWizardPage_CHOOSE_PROJECT_AREA_PAGE_DESCRIPTION);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(Messages.SelectProjectAreaWizardPage_PROJECT_AREAS);
        this.fViewer = new TableViewer(container, 2820);
        this.fViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fViewer.setContentProvider((IContentProvider)new SimpleContentProvider());
        this.fViewer.setSorter(new ViewerSorter());
        this.fViewer.setComparer((IElementComparer)new ItemComparer());
        this.setPageComplete(this.fContext.getProjectArea() != null);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        HelpContextIds.hookHelpListener((Control)container, "com.ibm.team.workitem.rcp.ui.new_work_item_wizard_project_area_page");
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.computeTypes();
        }
        super.setVisible(visible);
    }

    private void computeTypes() {
        List<IProjectAreaHandle> areas = this.fContext.getAvailableProjectAreas();
        if (areas.isEmpty()) {
            this.fViewer.setInput((Object)Messages.SelectProjectAreaWizardPage_NO_PROJECT_AREAS_AVAILABLE);
        } else {
            this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
            this.fViewer.setInput(areas);
            this.fViewer.addOpenListener(new IOpenListener(){

                public void open(OpenEvent event) {
                    SelectProjectAreaWizardPage.this.getContainer().showPage(SelectProjectAreaWizardPage.this.getNextPage());
                }
            });
            this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    IProjectAreaHandle selected = (IProjectAreaHandle)selection.getFirstElement();
                    if (!selected.sameItemId((IItemHandle)SelectProjectAreaWizardPage.this.fContext.getProjectArea())) {
                        SelectProjectAreaWizardPage.this.fContext.setType(null);
                        SelectProjectAreaWizardPage.this.getContainer().updateButtons();
                    }
                    SelectProjectAreaWizardPage.this.fContext.setProjectArea(selected);
                }
            });
            if (this.fContext.getProjectArea() != null && areas.contains(this.fContext.getProjectArea())) {
                this.fViewer.setSelection((ISelection)new StructuredSelection((Object)this.fContext.getProjectArea()));
            } else if (ConnectedProjectAreas.getInstance().getDefaultProjectArea(true) != null && areas.contains(ConnectedProjectAreas.getInstance().getDefaultProjectArea(true))) {
                this.fViewer.setSelection((ISelection)new StructuredSelection((Object)ConnectedProjectAreas.getInstance().getDefaultProjectArea(true)));
            } else {
                this.fViewer.setSelection((ISelection)new StructuredSelection(this.fViewer.getElementAt(0)));
            }
        }
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        this.setPageComplete(selection.getFirstElement() instanceof IProjectAreaHandle);
    }

    public void dispose() {
        this.fResourceManager.dispose();
        this.fLabelProvider.dispose();
    }

    private static class SimpleContentProvider
    implements IStructuredContentProvider {
        private SimpleContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[]{inputElement};
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

