/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.workitem.common.internal.util.Utils;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ItemComparer;
import com.ibm.team.workitem.rcp.ui.internal.wizards.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkTypePage
extends WizardPage {
    private TableViewer fViewer;
    private boolean fLinksFromMultiple;
    private List<IEndPointDescriptor> fExclusions;
    private IEndPointDescriptor fEndPoint;

    public LinkTypePage(boolean linksFromMultiple, IEndPointDescriptor ... exclusions) {
        super(Messages.LinkTypePage_CHOOSE_LINK_TYPE_PAGE, Messages.LinkTypePage_LINK_TYPE_TITLE, null);
        this.setDescription(Messages.LinkTypePage_SELECT_LINK_TYPE_MSG);
        this.fLinksFromMultiple = linksFromMultiple;
        this.fExclusions = Arrays.asList(exclusions);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(Messages.LinkTypePage_LINK_TYPES);
        this.fViewer = new TableViewer(container, 2820);
        this.fViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fViewer.setContentProvider((IContentProvider)new SimpleContentProvider());
        this.fViewer.setSorter(new ViewerSorter());
        this.fViewer.setComparer((IElementComparer)new ItemComparer());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new LinkEndPointLabelProvider());
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                LinkTypePage.this.getContainer().showPage(LinkTypePage.this.getNextPage());
            }
        });
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                LinkTypePage.this.fEndPoint = (IEndPointDescriptor)selection.getFirstElement();
            }
        });
        final List<IEndPointDescriptor> endPoints = this.getAvailableEndPoints();
        this.fViewer.setComparator(new ViewerComparator(new Comparator(){

            public int compare(Object o1, Object o2) {
                return endPoints.indexOf(o2) - endPoints.indexOf(o1);
            }
        }));
        this.fViewer.setInput(endPoints);
        if (this.fEndPoint != null && endPoints.contains(this.fEndPoint)) {
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)this.fEndPoint));
        } else if (!endPoints.isEmpty()) {
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)endPoints.get(0)));
        }
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        this.setPageComplete(!selection.isEmpty());
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        HelpContextIds.hookHelpListener((Control)container, "com.ibm.team.workitem.rcp.ui.link_work_item_wizard_choose_link_type_page");
    }

    private List<IEndPointDescriptor> getAvailableEndPoints() {
        ArrayList<IEndPointDescriptor> endPoints = new ArrayList<IEndPointDescriptor>();
        List allEndPoints = Utils.getSortedWriteableDescriptors();
        for (IEndPointDescriptor current : allEndPoints) {
            IEndPointDescriptor opposite;
            ILinkType linkType = current.getLinkType();
            IEndPointDescriptor source = linkType.getSourceEndPointDescriptor();
            IEndPointDescriptor target = linkType.getTargetEndPointDescriptor();
            IEndPointDescriptor iEndPointDescriptor = opposite = current == target ? source : target;
            if (WorkItemLinkTypes.isSymmetric((ILinkType)linkType) && (endPoints.contains(source) || endPoints.contains(target)) || this.fLinksFromMultiple && opposite.isSingleValued() || this.fExclusions.contains(current) || source.getReferencedItemType() != IWorkItem.ITEM_TYPE || target.getReferencedItemType() != IWorkItem.ITEM_TYPE) continue;
            endPoints.add(current);
        }
        return endPoints;
    }

    public IEndPointDescriptor getEndPoint() {
        return this.fEndPoint;
    }

    public void setEndPoint(IEndPointDescriptor endPoint) {
        this.fEndPoint = endPoint;
    }

    private static class LinkEndPointLabelProvider
    extends CellLabelProvider {
        private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());

        private LinkEndPointLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof IEndPointDescriptor) {
                IEndPointDescriptor endPoint = (IEndPointDescriptor)element;
                ImageDescriptor descriptor = WorkItemUI.getImageDescriptor(endPoint.getIcon());
                Image image = JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)descriptor);
                cell.setImage(image);
                cell.setText(endPoint.getDisplayName());
            }
        }

        public void dispose() {
            super.dispose();
            if (this.fResourceManager != null) {
                this.fResourceManager.dispose();
                this.fResourceManager = null;
            }
        }
    }

    private static class SimpleContentProvider
    implements IStructuredContentProvider {
        private SimpleContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[]{inputElement};
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

