/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards;

import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.wizards.LinkTypePage;
import com.ibm.team.workitem.rcp.ui.internal.wizards.LinkWorkItemOperation;
import com.ibm.team.workitem.rcp.ui.internal.wizards.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkNewWorkItemWizard
extends Wizard {
    private static final String DIALOG_SETTINGS_KEY = "linkWorkItem";
    private static final String LINK_TYPE_KEY = "linkType";
    private static final String END_POINT_KEY = "endPoint";
    private IDialogSettings fDialogSettings;
    private ITeamRepository fTeamRepository;
    private List<IWorkItemHandle> fWorkItems;
    private IProjectAreaHandle fProjectArea;
    private LinkTypePage fLinkTypePage;

    public LinkNewWorkItemWizard(ITeamRepository teamRepository, List<IWorkItemHandle> workItems) {
        this.fTeamRepository = teamRepository;
        this.fWorkItems = workItems;
        this.setWindowTitle(Messages.LinkWorkItemWizard_LINK_TO_WORK_ITEM_WINDOW);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.fLinkTypePage = new LinkTypePage(this.fWorkItems.size() > 1, new IEndPointDescriptor[0]);
        this.addPage((IWizardPage)this.fLinkTypePage);
        this.loadSettings();
    }

    public IEndPointDescriptor getEndPoint() {
        return this.fLinkTypePage.getEndPoint();
    }

    private void resolve() {
        if (!this.fWorkItems.isEmpty()) {
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IAuditableClient auditableClient = (IAuditableClient)LinkNewWorkItemWizard.this.fTeamRepository.getClientLibrary(IAuditableClient.class);
                        try {
                            ItemProfile profile = ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, Arrays.asList(IWorkItem.PROJECT_AREA_PROPERTY), (boolean)true);
                            IWorkItemHandle handle = (IWorkItemHandle)LinkNewWorkItemWizard.this.fWorkItems.get(0);
                            if (handle != null) {
                                IWorkItem workItem = (IWorkItem)auditableClient.resolveAuditable((IAuditableHandle)handle, profile, monitor);
                                LinkNewWorkItemWizard.this.fProjectArea = workItem.getProjectArea();
                            }
                        }
                        catch (TeamRepositoryException teamRepositoryException) {}
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean performFinish() {
        this.resolve();
        final Shell shell = this.getContainer().getShell();
        new FoundationUIJob(Messages.LinkNewWorkItemWizard_CREATING_WORKITEM){

            protected IStatus runProtectedInUI(IProgressMonitor monitor) throws Exception {
                ILinkType linkType = LinkNewWorkItemWizard.this.getEndPoint().getLinkType();
                IEndPointDescriptor opposite = LinkNewWorkItemWizard.this.getEndPoint() == linkType.getTargetEndPointDescriptor() ? linkType.getSourceEndPointDescriptor() : linkType.getTargetEndPointDescriptor();
                WorkItemUI.createWorkItem(shell, LinkNewWorkItemWizard.this.fProjectArea, LinkWorkItemOperation.create(opposite, LinkNewWorkItemWizard.this.fWorkItems, false));
                return Status.OK_STATUS;
            }
        }.schedule();
        this.storeSettings();
        return true;
    }

    private void loadSettings() {
        String linkTypeId;
        this.fDialogSettings = WorkItemRCPUIPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (this.fDialogSettings != null && this.fDialogSettings.get(LINK_TYPE_KEY) != null && ILinkTypeRegistry.INSTANCE.isRegistered(linkTypeId = this.fDialogSettings.get(LINK_TYPE_KEY))) {
            ILinkType linkType = ILinkTypeRegistry.INSTANCE.getLinkType(linkTypeId);
            boolean isTarget = this.fDialogSettings.get(END_POINT_KEY) != null ? this.fDialogSettings.getBoolean(END_POINT_KEY) : true;
            this.fLinkTypePage.setEndPoint(isTarget ? linkType.getTargetEndPointDescriptor() : linkType.getSourceEndPointDescriptor());
        }
    }

    private void storeSettings() {
        if (this.fDialogSettings == null) {
            this.fDialogSettings = WorkItemRCPUIPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        }
        this.fDialogSettings.put(LINK_TYPE_KEY, this.getEndPoint() != null ? this.getEndPoint().getLinkType().getLinkTypeId() : null);
        this.fDialogSettings.put(END_POINT_KEY, (this.getEndPoint() != null ? Boolean.valueOf(this.getEndPoint() == this.getEndPoint().getLinkType().getTargetEndPointDescriptor()) : null).booleanValue());
    }

    public static class LinkWorkItemAction
    implements IObjectActionDelegate {
        private IWorkbenchPart fTargetPart;
        private ISelection fSelection;

        public void run(IAction action) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (this.fTargetPart == null && window == null || this.fSelection == null) {
                return;
            }
            if (!(this.fSelection instanceof IStructuredSelection) || this.fSelection.isEmpty()) {
                return;
            }
            ArrayList<IWorkItemHandle> handles = new ArrayList<IWorkItemHandle>();
            for (Object element : ((IStructuredSelection)this.fSelection).toList()) {
                if (!(element instanceof IWorkItemHandle) || !handles.isEmpty() && ((IWorkItemHandle)handles.get(0)).getOrigin() != ((IWorkItemHandle)element).getOrigin()) continue;
                handles.add((IWorkItemHandle)element);
            }
            if (handles.isEmpty()) {
                return;
            }
            Shell shell = this.fTargetPart != null ? this.fTargetPart.getSite().getShell() : window.getShell();
            LinkNewWorkItemWizard wizard = new LinkNewWorkItemWizard((ITeamRepository)((IWorkItemHandle)handles.get(0)).getOrigin(), handles);
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.open();
        }

        public void selectionChanged(IAction action, ISelection selection) {
            this.fSelection = selection;
            if (action != null) {
                action.setEnabled(this.isEnabled(selection));
            }
        }

        private boolean isEnabled(ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                for (Object next : structuredSelection) {
                    if (next instanceof IWorkItemHandle) {
                        IWorkItem workitem;
                        IWorkItemHandle handle = (IWorkItemHandle)next;
                        if (!handle.hasFullState() || !(workitem = (IWorkItem)handle.getFullState()).isNewItem()) continue;
                        return false;
                    }
                    return false;
                }
                return !structuredSelection.isEmpty();
            }
            return false;
        }

        public void setActivePart(IAction action, IWorkbenchPart targetPart) {
            this.fTargetPart = targetPart;
        }
    }
}

