/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.ILinkCollection;
import com.ibm.team.links.common.IReference;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemOperation;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.client.internal.ArtifactLink;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyManager;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.CopyToProjectOperation;
import com.ibm.team.workitem.common.internal.util.EMFHelper;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.internal.util.Utils;
import com.ibm.team.workitem.common.internal.workflow.WorkflowManager;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IAttachmentHandle;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IComments;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.common.workflow.IWorkflowAction;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import com.ibm.team.workitem.rcp.ui.WorkItemUIOperation;
import com.ibm.team.workitem.rcp.ui.internal.wizards.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyToProjectAreaOperation
extends WorkItemUIOperation {
    private CopyToProjectOperation fOperation;

    public CopyToProjectAreaOperation(String name, IProjectAreaHandle targetArea, boolean commitChanges, boolean move, boolean resolveSource, boolean moveAttachments) {
        super(name, IWorkItem.FULL_PROFILE);
        this.fOperation = new CopyToProjectOperation(name, targetArea, commitChanges, move, resolveSource, moveAttachments){
            private Map<UUID, WorkItemWorkingCopy> fCache;
            {
                this.fCache = new HashMap<UUID, WorkItemWorkingCopy>();
            }

            protected void execute(IWorkItem sourceWorkItem, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
                if (sourceWorkItem.getOrigin() != this.getTargetArea().getOrigin()) {
                    this.addCopyProblem(new CopyToProjectOperation.CopyProblem(Messages.CopyToProjectAreaOperation_COPY_TO_OTHER_REPOSITORY_NOT_SUPPORTED));
                    return;
                }
                super.execute(sourceWorkItem, workItemCommon, monitor);
            }

            protected void handleAttachments(IWorkItem sourceWorkItem, IWorkItem targetWorkItem, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
                IWorkItemWorkingCopyManager workingCopyManager = ((IWorkItemClient)workItemCommon).getWorkItemWorkingCopyManager();
                WorkItemWorkingCopy sourceCopy = workingCopyManager.getWorkingCopy((IWorkItemHandle)sourceWorkItem);
                this.handleAttachments(sourceCopy, this.getWorkingCopy(targetWorkItem, workItemCommon), monitor);
            }

            protected IWorkItemReferences getWorkItemReferences(IWorkItem workItem, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
                WorkItemWorkingCopy copy = this.getWorkingCopy(workItem, workItemCommon);
                if (copy != null) {
                    return copy.getReferences();
                }
                IWorkItemWorkingCopyManager workingCopyManager = ((IWorkItemClient)workItemCommon).getWorkItemWorkingCopyManager();
                return workingCopyManager.getWorkingCopy((IWorkItemHandle)workItem).getReferences();
            }

            protected IWorkItem createNewWorkItem(IWorkItemType type, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
                IWorkItemWorkingCopyManager workingCopyManager = ((IWorkItemClient)workItemCommon).getWorkItemWorkingCopyManager();
                WorkItemWorkingCopy targetCopy = ((WorkItemWorkingCopyManager)workingCopyManager).createNewUnconnected(type, monitor);
                this.fCache.put(targetCopy.getWorkItem().getItemId(), targetCopy);
                return targetCopy.getWorkItem();
            }

            protected void commit(IWorkItem sourceWorkItem, IWorkItem targetWorkItem, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
                if (this.isMove()) {
                    IWorkItemWorkingCopyManager workingCopyManager = ((IWorkItemClient)workItemCommon).getWorkItemWorkingCopyManager();
                    workingCopyManager.connect((IWorkItemHandle)sourceWorkItem, IWorkItem.FULL_PROFILE, monitor);
                    try {
                        WorkItemWorkingCopy workingCopy = workingCopyManager.getWorkingCopy((IWorkItemHandle)sourceWorkItem);
                        EMFHelper.merge((EObject)((EObject)workingCopy.getWorkItem()), (EObject)((EObject)targetWorkItem), (List)EXCLUDE_ON_MOVE);
                    }
                    finally {
                        workingCopyManager.disconnect((IWorkItemHandle)sourceWorkItem);
                    }
                }
                IComments comments = targetWorkItem.getComments();
                LocalizationContext targetContext = LocalizationContext.createProjectAreaContext((IAuditableCommon)workItemCommon.getAuditableCommon(), (IProjectAreaHandle)targetWorkItem.getProjectArea(), (IProgressMonitor)monitor);
                String text = NLS.bind((String)Messages.getString(targetContext, "CopyToProjectAreaOperation_COPIED_FROM"), (Object)sourceWorkItem.getId(), (Object[])new Object[0]);
                IComment comment = comments.createComment((IContributorHandle)workItemCommon.getAuditableCommon().resolveAuditable((IAuditableHandle)workItemCommon.getAuditableCommon().getUser(), ItemProfile.CONTRIBUTOR_DEFAULT, monitor), Utils.createSynthetic((XMLString)XMLString.createFromPlainText((String)text)));
                comments.append(comment);
                IWorkItemWorkingCopyManager workingCopyManager = ((IWorkItemClient)workItemCommon).getWorkItemWorkingCopyManager();
                WorkItemWorkingCopy targetCopy = this.getWorkingCopy(targetWorkItem, workItemCommon);
                IWorkItemReferences references = targetCopy.getReferences();
                references.add(WorkItemEndPoints.COPIED_FROM_WORK_ITEM, (IReference)WorkItemLinkTypes.createWorkItemReference((IWorkItem)sourceWorkItem));
                LocalizationContext sourceContext = LocalizationContext.createProjectAreaContext((IAuditableCommon)workItemCommon.getAuditableCommon(), (IProjectAreaHandle)sourceWorkItem.getProjectArea(), (IProgressMonitor)monitor);
                targetCopy.addWorkingCopyListener((IWorkingCopyListener)new InternalPostSaveListener((IWorkItemHandle)sourceWorkItem, this.isResolveSource(), sourceContext));
                ((WorkItemWorkingCopyImpl)targetCopy).setDirty(true);
                ((WorkItemWorkingCopyManager)workingCopyManager).connectNew(targetCopy, monitor);
                try {
                    CopyToProjectAreaOperation.super.commit(new WorkItemWorkingCopy[]{targetCopy}, monitor);
                }
                finally {
                    workingCopyManager.disconnect((IWorkItemHandle)targetCopy.getWorkItem());
                }
                this.addCopy(targetCopy.getWorkItem());
            }

            protected void copyWorkFlow(IWorkItem sourceWorkItem, IWorkItem targetWorkItem, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
                Identifier resolutionState;
                IWorkItemWorkingCopyManager workingCopyManager = ((IWorkItemClient)workItemCommon).getWorkItemWorkingCopyManager();
                WorkItemWorkingCopy sourceCopy = workingCopyManager.getWorkingCopy((IWorkItemHandle)sourceWorkItem);
                WorkItemWorkingCopy targetCopy = this.getWorkingCopy(targetWorkItem, workItemCommon);
                WorkflowManager workflowManager = (WorkflowManager)workItemCommon.getWorkflowManager();
                IWorkItemType targetType = workItemCommon.findWorkItemType(targetWorkItem.getProjectArea(), targetWorkItem.getWorkItemType(), monitor);
                String workflowId = targetType != null ? workflowManager.getWorkflowIdForCategory(targetWorkItem.getProjectArea(), targetType.getCategory(), false, monitor) : null;
                IWorkflowInfo targetInfo = workflowId != null ? workflowManager.getWorkflowInfo(targetWorkItem.getProjectArea(), workflowId, false, monitor) : null;
                IWorkflowInfo sourceInfo = workItemCommon.findWorkflowInfo(sourceWorkItem, monitor);
                if (targetInfo != null && !sourceInfo.getIdentifier().equals(targetInfo.getIdentifier())) {
                    targetCopy.setWorkflowAction(null);
                    if (this.isMove() && this.isCommitChanges()) {
                        sourceCopy.setWorkflowAction(null);
                    }
                    this.addCopyProblem(new CopyToProjectOperation.CopyProblem(NLS.bind((String)Messages.CopyToProjectAreaOperation_WORKFLOWS_DIFFER, (Object)targetInfo.getName(), (Object[])new Object[]{sourceInfo.getName()})));
                    return;
                }
                Identifier state = sourceWorkItem.getState2();
                String action = sourceCopy.getWorkflowAction();
                Identifier actionId = null;
                if (action != null) {
                    actionId = Identifier.create(IWorkflowAction.class, (String)action);
                }
                Identifier resolution = sourceWorkItem.getResolution2();
                boolean stateExists = state == null || targetInfo != null && Arrays.asList(targetInfo.getAllStateIds()).contains(state);
                boolean actionExists = action == null || actionId != null && targetInfo != null && Arrays.asList(targetInfo.getActionIds(state)).contains(actionId);
                boolean resolutionExists = false;
                if (actionId != null) {
                    resolutionState = targetInfo.getActionResultState(actionId);
                    if (resolutionState != null) {
                        resolutionState = Identifier.create(IState.class, (String)this.stripPrefix(resolutionState.getStringIdentifier()));
                    }
                } else {
                    resolutionState = state;
                }
                if (resolutionState != null) {
                    List<Identifier> stateResolutions = Arrays.asList(targetInfo.getStateResolutionIds(resolutionState));
                    if (resolution != null && stateResolutions.contains(resolution) || stateResolutions.isEmpty() && resolution == null || resolution != null && "0".equals(resolution.getStringIdentifier())) {
                        resolutionExists = true;
                    }
                }
                if (!(stateExists && resolutionExists && (actionExists || action == null) || sourceWorkItem.getId() == -1)) {
                    targetCopy.setWorkflowAction(null);
                    if (this.isMove() && this.isCommitChanges()) {
                        sourceCopy.setWorkflowAction(null);
                    }
                    String sta = "";
                    String res = "";
                    String act = "";
                    if (!stateExists) {
                        String stateName = null;
                        if (sourceInfo != null) {
                            stateName = sourceInfo.getStateName(state);
                        }
                        if (stateName == null) {
                            stateName = state != null ? state.getStringIdentifier() : Messages.CopyToProjectAreaOperation_NONE;
                        }
                        sta = NLS.bind((String)Messages.CopyToProjectAreaOperation_PROPERTY_NOT_FOUND, (Object)Messages.CopyToProjectAreaOperation_STATE, (Object[])new Object[]{stateName});
                    }
                    if (!resolutionExists) {
                        String resolutionName = null;
                        if (sourceInfo != null) {
                            resolutionName = sourceInfo.getResolutionName(resolution);
                        }
                        if (resolutionName == null) {
                            resolutionName = resolution != null ? resolution.getStringIdentifier() : Messages.CopyToProjectAreaOperation_NONE;
                        }
                        res = NLS.bind((String)Messages.CopyToProjectAreaOperation_PROPERTY_NOT_FOUND, (Object)Messages.CopyToProjectAreaOperation_RESOLUTION, (Object[])new Object[]{resolutionName});
                    }
                    if (action != null && !actionExists) {
                        String actionName = null;
                        if (sourceInfo != null && actionId != null) {
                            actionName = sourceInfo.getActionName(actionId);
                        }
                        if (actionName == null) {
                            actionName = action;
                        }
                        act = NLS.bind((String)Messages.CopyToProjectAreaOperation_PROPERTY_NOT_FOUND, (Object)Messages.CopyToProjectAreaOperation_ACTION, (Object[])new Object[]{actionName});
                    }
                    String message = String.valueOf(Messages.CopyToProjectAreaOperation_WORKFLOW_DOES_NOT_MATCH) + sta + res + act;
                    this.addCopyProblem(new CopyToProjectOperation.CopyProblem(message));
                } else {
                    targetWorkItem.setState2(state);
                    targetWorkItem.setResolution2(resolution);
                    targetCopy.setWorkflowAction(action);
                }
            }

            private String stripPrefix(String s) {
                int l = s.length();
                if (l > 1 && s.charAt(0) == 's') {
                    int i = 1;
                    while (i < l) {
                        if (!Character.isDigit(s.charAt(i))) {
                            return s;
                        }
                        ++i;
                    }
                    return s.substring(1);
                }
                return s;
            }

            private WorkItemWorkingCopy getWorkingCopy(IWorkItem workItem, IWorkItemCommon workItemCommon) {
                return this.fCache.get(workItem.getItemId());
            }

            private void handleAttachments(WorkItemWorkingCopy sourceCopy, WorkItemWorkingCopy targetCopy, IProgressMonitor monitor) throws TeamRepositoryException {
                block9: {
                    if (!this.isMove()) break block9;
                    if (this.isCommitChanges()) {
                        for (ArtifactLink link : ((WorkItemWorkingCopyImpl)sourceCopy).getArtifactLinks()) {
                            link.setMoved();
                        }
                    } else {
                        for (ArtifactLink link : ((WorkItemWorkingCopyImpl)sourceCopy).getArtifactLinks()) {
                            if (!link.getReference().isItemReference()) continue;
                            IAttachmentHandle handle = (IAttachmentHandle)((IItemReference)link.getReference()).getReferencedItem();
                            IAuditableClient auditableClient = (IAuditableClient)sourceCopy.getTeamRepository().getClientLibrary(IAuditableClient.class);
                            IAttachment att = (IAttachment)auditableClient.resolveAuditable((IAuditableHandle)handle, IAttachment.DEFAULT_PROFILE, monitor);
                            ILinkManager mgr = (ILinkManager)sourceCopy.getTeamRepository().getClientLibrary(ILinkManager.class);
                            ILinkCollection links = mgr.findLinks(link.getReference(), monitor).getAllLinksFromHereOn();
                            for (ILink l : links) {
                                IReference other = null;
                                IReference sourceRef = l.getSourceRef();
                                IReference targetRef = l.getTargetRef();
                                if (sourceRef.isItemReference() && handle.sameItemId(((IItemReference)sourceRef).getReferencedItem())) {
                                    other = targetRef;
                                } else if (targetRef.isItemReference() && handle.sameItemId(((IItemReference)targetRef).getReferencedItem())) {
                                    other = sourceRef;
                                }
                                if (other == null || other.isItemReference() && ((IItemReference)other).getReferencedItem().sameItemId((IItemHandle)sourceCopy.getWorkItem())) continue;
                                String name = NLS.bind((String)"''{0}''", (Object)other.getComment(), (Object[])new Object[0]);
                                if (other.isItemReference() && ((IItemReference)other).getReferencedItem() instanceof IWorkItemHandle) {
                                    IWorkItem referenced = (IWorkItem)auditableClient.resolveAuditable((IAuditableHandle)((IWorkItemHandle)((IItemReference)other).getReferencedItem()), IWorkItem.SMALL_PROFILE, monitor);
                                    name = NLS.bind((String)Messages.CopyToProjectAreaOperation_WORKITEM_ID_SUMMARY, (Object)referenced.getId(), (Object[])new Object[]{referenced.getHTMLSummary().getPlainText()});
                                }
                                this.addCopyProblem(new CopyToProjectOperation.CopyProblem(NLS.bind((String)Messages.CopyToProjectAreaOperation_ATTACHMENT_ID_NAME_IS_REFERENCED, (Object)att.getId(), (Object[])new Object[]{att.getName(), name})));
                            }
                        }
                    }
                }
            }
        };
    }

    protected void execute(WorkItemWorkingCopy[] workingCopies, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IWorkItem> workItems = new ArrayList<IWorkItem>();
        WorkItemWorkingCopy[] workItemWorkingCopyArray = workingCopies;
        int n = workingCopies.length;
        int n2 = 0;
        while (n2 < n) {
            WorkItemWorkingCopy copy = workItemWorkingCopyArray[n2];
            workItems.add(copy.getWorkItem());
            ++n2;
        }
        this.fOperation.run(workItems, (IWorkItemCommon)((ITeamRepository)this.fOperation.getTargetArea().getOrigin()).getClientLibrary(IWorkItemCommon.class), monitor);
    }

    public List<CopyToProjectOperation.CopyProblem> getCopyProblems() {
        return this.fOperation.getCopyProblems();
    }

    public List<IWorkItem> getCopies() {
        return this.fOperation.getCopies();
    }

    @Override
    protected void commit(WorkItemWorkingCopy[] workingCopies, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fOperation.isCommitChanges() && this.fOperation.isMove()) {
            super.commit(workingCopies, monitor);
        }
    }

    private static class InternalPostSaveListener
    implements IWorkingCopyListener {
        private IWorkItemHandle fSourceHandle;
        private boolean fResolve;
        private LocalizationContext fSourceContext;

        private InternalPostSaveListener(IWorkItemHandle sourceHandle, boolean resolve, LocalizationContext sourceContext) {
            this.fSourceHandle = sourceHandle;
            this.fResolve = resolve;
            this.fSourceContext = sourceContext;
        }

        public void workingCopyEvent(WorkingCopyEvent event) {
            WorkItemWorkingCopy workingCopy = event.getSource();
            if (event.hasType("saved")) {
                workingCopy.removeWorkingCopyListener((IWorkingCopyListener)this);
                String text = NLS.bind((String)Messages.getString(this.fSourceContext, "CopyToProjectAreaOperation_COPIED_TO"), (Object)workingCopy.getWorkItem().getId(), (Object[])new Object[0]);
                InternalPostSaveOperation operation = new InternalPostSaveOperation(Utils.createSynthetic((XMLString)XMLString.createFromPlainText((String)text)), this.fResolve);
                operation.runInSystemJob(this.fSourceHandle);
            } else if (event.hasType("aboutToBeDisposed")) {
                workingCopy.removeWorkingCopyListener((IWorkingCopyListener)this);
            }
        }
    }

    private static class InternalPostSaveOperation
    extends WorkItemOperation {
        private XMLString fComment;
        private boolean fResolve;

        public InternalPostSaveOperation(XMLString comment, boolean resolve) {
            super(Messages.CopyToProjectAreaOperation_UPDATING_SOURCE, IWorkItem.SMALL_PROFILE);
            this.fComment = comment;
            this.fResolve = resolve;
        }

        protected void execute(WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
            Identifier actionId;
            IWorkflowInfo workflowInfo;
            ITeamRepository teamRepository = workingCopy.getTeamRepository();
            IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
            IComments comments = workingCopy.getWorkItem().getComments();
            IComment comment = comments.createComment((IContributorHandle)workingCopy.getTeamRepository().loggedInContributor(), this.fComment);
            comments.append(comment);
            if (this.fResolve && (workflowInfo = workItemClient.findWorkflowInfo(workingCopy.getWorkItem(), monitor)) != null && !Arrays.asList(workflowInfo.getStateIds(2)).contains(workingCopy.getWorkItem().getState2()) && (actionId = workflowInfo.getResolveActionId()) != null) {
                workingCopy.setWorkflowAction(actionId.getStringIdentifier());
            }
        }
    }
}

