/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.viewer;

import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.tooltip.INavigatorContent;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeColumn;
import com.ibm.team.workitem.rcp.ui.internal.attribute.ImageOnlyLabelProvider;
import com.ibm.team.workitem.rcp.ui.internal.explorer.Utils;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IColumnObjectProvider;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IRelation;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IResultModel;
import com.ibm.team.workitem.rcp.ui.internal.viewer.WorkItemViewer;
import com.ibm.team.workitem.rcp.ui.internal.viewer.WorkItemViewerLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;

class WorkItemViewerTooltipSupport
extends TooltipSupport {
    private static final Point PREFERRED_WORK_ITEM_FOCUS_TOOLTIP_SIZE = new Point(350, 150);
    private Utils.ColumnPosition fColumnPosition;
    private AttributeColumn fColumn;
    private boolean fShowWorkItem;
    private boolean fFocusTooltip;
    private WorkItemViewer fViewer;

    public WorkItemViewerTooltipSupport(WorkItemViewer viewer) {
        super(viewer.getViewer().getControl(), true, true);
        this.fViewer = viewer;
    }

    protected void openRequested(Object element) {
        NavigatorContent content;
        Object current;
        if (element instanceof NavigatorContent && (current = (content = (NavigatorContent)element).current()) instanceof ResolvedWorkItem) {
            ResolvedWorkItem wI = (ResolvedWorkItem)current;
            IWorkbenchPage activePage = FoundationUIUtils.getActivePage();
            if (activePage != null) {
                WorkItemUI.openEditor(activePage, wI);
            }
        }
    }

    protected Object mapElement(int x, int y) {
        Point point = new Point(x, y);
        TreeItem item = this.getTree().getItem(point);
        this.fColumnPosition = Utils.mapColumn(this.getTree(), x);
        if (this.fColumnPosition == null || item == null) {
            return null;
        }
        boolean isImageTooltip = item.getImageBounds(this.fColumnPosition.creationIndex).contains(x, y);
        this.fColumn = this.getColumnObjectProvider().getColumn(this.fColumnPosition.creationIndex);
        this.fShowWorkItem = this.fColumn.showWorkItemToolTip();
        this.fFocusTooltip = this.fColumn.showFocusToolTip();
        this.setPreferredFocusSize(this.fShowWorkItem ? PREFERRED_WORK_ITEM_FOCUS_TOOLTIP_SIZE : PREFERRED_SIZE);
        if ((isImageTooltip || !this.isHoverHotspotReduced()) && this.fShowWorkItem && item.getData() instanceof ResolvedWorkItem) {
            return new NavigatorContent(item.getData());
        }
        if (isImageTooltip || !this.isHoverHotspotReduced()) {
            return item.getData();
        }
        return null;
    }

    protected String getMarkup(Object element, boolean isFocus) {
        if (element instanceof ResolvedWorkItem) {
            ResolvedWorkItem resolved = (ResolvedWorkItem)element;
            Object value = null;
            value = this.fShowWorkItem ? resolved.getWorkItem() : this.getColumnObjectProvider().getObject(resolved, this.fColumnPosition.creationIndex);
            this.setFocusable(this.fFocusTooltip);
            if (this.fShowWorkItem || DomainAdapterUtils.getDomainAdapter((Object)value) != null) {
                this.setOpenable(this.fShowWorkItem);
                this.setUseBrowser(true);
                return super.getMarkup(value, isFocus);
            }
            this.setOpenable(true);
            this.setUseBrowser(false);
            ILabelProvider labelProvider = this.getLabelProvider().getLabelProvider(element, this.fColumnPosition.creationIndex);
            if (labelProvider instanceof ImageOnlyLabelProvider) {
                labelProvider = ((ImageOnlyLabelProvider)labelProvider).getWrappedLabelProvider();
            }
            return labelProvider.getText(element);
        }
        if (element instanceof IRelation) {
            this.setOpenable(false);
            this.setUseBrowser(false);
            this.setFocusable(false);
            return ((IRelation)element).getDescriptor().getTooltip();
        }
        return super.getMarkup(element, isFocus);
    }

    private Tree getTree() {
        return (Tree)this.fViewer.getViewer().getControl();
    }

    private WorkItemViewerLabelProvider getLabelProvider() {
        return (WorkItemViewerLabelProvider)this.fViewer.getViewer().getLabelProvider();
    }

    private IColumnObjectProvider getColumnObjectProvider() {
        return this.fViewer.getColumnObjectProvider();
    }

    private IResultModel getResultModel() {
        return this.fViewer.getInput() != null ? this.fViewer.getInput().getWorkItemSource().getRetrievalStrategy().getResultModel() : null;
    }

    private class NavigatorContent
    implements INavigatorContent {
        private int fIndex;
        private Object fCurrent;

        private NavigatorContent(Object item) {
            this.fIndex = WorkItemViewerTooltipSupport.this.getResultModel().indexOf(IResultModel.ROOT, item);
            this.fCurrent = item;
        }

        public int getPosition() {
            return this.fIndex;
        }

        public boolean hasNext() {
            return this.fIndex + 1 < WorkItemViewerTooltipSupport.this.getResultModel().size();
        }

        public boolean hasPrevious() {
            return this.fIndex - 1 >= 0;
        }

        public Object current() {
            return this.fCurrent;
        }

        public Object next() {
            this.fCurrent = WorkItemViewerTooltipSupport.this.getResultModel().getChild(IResultModel.ROOT, ++this.fIndex);
            return this.fCurrent;
        }

        public Object previous() {
            this.fCurrent = WorkItemViewerTooltipSupport.this.getResultModel().getChild(IResultModel.ROOT, --this.fIndex);
            return this.fCurrent;
        }

        public void setPosition(int position) {
            this.fIndex = position;
        }

        public int size() {
            return WorkItemViewerTooltipSupport.this.getResultModel().size();
        }
    }
}

