/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.viewer;

import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeColumn;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IColumnObjectProvider;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IRelation;
import com.ibm.team.workitem.rcp.ui.internal.viewer.RelationLabelProvider;
import java.util.HashMap;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;

public class WorkItemViewerLabelProvider
extends CellLabelProvider {
    private IColumnObjectProvider fColumnObjectProvider;
    private HashMap<AttributeColumn, ILabelProvider> fLabelProviderCache = new HashMap();
    private ILabelProvider fRelationLabelProvider;
    private ILabelProvider fStandardLabelProvider;

    public WorkItemViewerLabelProvider(IColumnObjectProvider provider) {
        this.fColumnObjectProvider = provider;
        this.fRelationLabelProvider = new RelationLabelProvider();
    }

    public void setColumnObjectProvider(IColumnObjectProvider provider) {
        this.fColumnObjectProvider = provider;
    }

    public void update(ViewerCell cell) {
        ViewerLabel label = new ViewerLabel("", null);
        this.updateLabel(label, cell.getElement(), cell.getColumnIndex());
        Utils.copyLabel(label, cell);
    }

    public void updateLabel(ViewerLabel label, Object rowElement, int columnIndex) {
        Object element = this.getElement(rowElement, columnIndex);
        ILabelProvider provider = this.getLabelProvider(rowElement, columnIndex);
        if (provider == null) {
            return;
        }
        if (provider instanceof IViewerLabelProvider) {
            IViewerLabelProvider viewerLabelProvider = (IViewerLabelProvider)provider;
            viewerLabelProvider.updateLabel(label, element);
            return;
        }
        label.setText(provider.getText(element));
        label.setImage(provider.getImage(element));
        if (provider instanceof IFontProvider) {
            IFontProvider fontProvider = (IFontProvider)provider;
            label.setFont(fontProvider.getFont(element));
        }
        if (provider instanceof IColorProvider) {
            IColorProvider colorProvider = (IColorProvider)provider;
            label.setBackground(colorProvider.getBackground(element));
            label.setForeground(colorProvider.getForeground(element));
        }
    }

    protected ILabelProvider getLabelProvider(Object element, int columnIndex) {
        int visibleIndex = this.getColumnObjectProvider().getVisibleIndex(columnIndex);
        if (element instanceof IWorkItem || element instanceof ResolvedWorkItem) {
            AttributeColumn column;
            Object provider = this.getColumnLabelProvider(columnIndex);
            if (visibleIndex == 0 && (column = this.getColumnObjectProvider().getColumn(columnIndex)).getAttribute().getIdentifier().equals(IWorkItem.SUMMARY_PROPERTY)) {
                provider = new DecoratingLabelProvider((ILabelProvider)provider, null){

                    public Image getImage(Object element) {
                        if (element instanceof ResolvedWorkItem) {
                            ResolvedWorkItem resolved = (ResolvedWorkItem)element;
                            return WorkItemViewerLabelProvider.this.getStandardLabelProvider().getImage((Object)resolved.getWorkItem());
                        }
                        if (element instanceof IWorkItem) {
                            return WorkItemViewerLabelProvider.this.getStandardLabelProvider().getImage(element);
                        }
                        return null;
                    }
                };
            }
            return provider;
        }
        if (visibleIndex == 0) {
            if (element instanceof IRelation) {
                return this.fRelationLabelProvider;
            }
            return this.getStandardLabelProvider();
        }
        return null;
    }

    protected Object getElement(Object element, int columnIndex) {
        Object object;
        AttributeColumn column = this.getColumnObjectProvider().getColumn(columnIndex);
        if (column.getAttribute().isSynthetic() && (object = this.getColumnObjectProvider().getObject(element, columnIndex)) != null) {
            return object;
        }
        return element;
    }

    protected IColumnObjectProvider getColumnObjectProvider() {
        return this.fColumnObjectProvider;
    }

    private ILabelProvider getColumnLabelProvider(int columnIndex) {
        ILabelProvider provider = null;
        AttributeColumn column = this.getColumnObjectProvider().getColumn(columnIndex);
        if (column != null && (provider = this.fLabelProviderCache.get(column)) == null) {
            provider = column.createLabelProvider();
            this.fLabelProviderCache.put(column, provider);
        }
        return provider;
    }

    public void dispose() {
        super.dispose();
        this.clearElements();
        this.fLabelProviderCache = null;
        if (this.fRelationLabelProvider != null) {
            this.fRelationLabelProvider.dispose();
            this.fRelationLabelProvider = null;
        }
    }

    private ILabelProvider getStandardLabelProvider() {
        if (this.fStandardLabelProvider == null) {
            this.fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        }
        return this.fStandardLabelProvider;
    }

    public void clearElements() {
        if (this.fLabelProviderCache != null) {
            for (ILabelProvider provider : this.fLabelProviderCache.values()) {
                provider.dispose();
            }
            this.fLabelProviderCache.clear();
        }
        if (this.fStandardLabelProvider != null) {
            this.fStandardLabelProvider.dispose();
            this.fStandardLabelProvider = null;
        }
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
    }
}

