/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.viewer;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.rcp.core.internal.queries.QueryView;
import com.ibm.team.workitem.rcp.core.internal.queries.QueryViewColumn;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeColumn;
import com.ibm.team.workitem.rcp.ui.internal.explorer.view.UnreadFilter;
import com.ibm.team.workitem.rcp.ui.internal.explorer.view.WorkItemFilter;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IResultModel;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IWorkItemSource;
import com.ibm.team.workitem.rcp.ui.internal.viewer.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemViewerInput {
    private IWorkItemSource fSource;
    private QueryView fView;
    private IStatus fStatus;
    private String fDefaultViewIdentifier;

    public WorkItemViewerInput(IWorkItemSource sourceDefinition) {
        Assert.isNotNull((Object)sourceDefinition);
        this.fSource = sourceDefinition;
        this.fStatus = Status.OK_STATUS;
    }

    public String getName() {
        if (this.fSource.isResolved()) {
            return this.fSource.getName();
        }
        return Messages.WorkItemViewerInput_UNKNOWN;
    }

    public IWorkItemSource getWorkItemSource() {
        return this.fSource;
    }

    public QueryView getView() {
        if (this.fView == null) {
            this.fView = this.fSource.getView(this.getDefaultViewId());
            this.updateViewDependencies();
        }
        return this.fView;
    }

    public String getDefaultViewId() {
        return this.fDefaultViewIdentifier;
    }

    public void setDefaultViewId(String identifier) {
        this.fDefaultViewIdentifier = identifier;
    }

    public void setView(QueryView view) {
        this.fView = view;
        this.updateViewDependencies();
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    public List<AttributeColumn.Constraint> getConstraints() {
        ArrayList<AttributeColumn.Constraint> constraints = new ArrayList<AttributeColumn.Constraint>();
        if (this.getWorkItemSource().isScored()) {
            constraints.add(new AttributeColumn.Constraint(0, "score"));
        }
        if (this.hasRelationships()) {
            constraints.add(new AttributeColumn.Constraint(0, IWorkItem.SUMMARY_PROPERTY));
            constraints.add(new AttributeColumn.Constraint(-1, IWorkItem.TYPE_PROPERTY));
        }
        return constraints;
    }

    public IStatus resolve(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        try {
            this.fSource.resolve(monitor);
        }
        catch (TeamRepositoryException e) {
            status = new Status(4, "com.ibm.team.workitem.rcp.ui", e.getLocalizedMessage(), (Throwable)e);
        }
        this.fStatus = status;
        return status;
    }

    private void updateViewDependencies() {
        this.fSource.getRetrievalStrategy().setColumnIdentifiers(this.getColumnIdentifiers(this.fView));
        this.fSource.getRetrievalStrategy().setSortCriteria(this.fView.getSortCriteria());
    }

    protected Collection<String> getColumnIdentifiers(QueryView view) {
        HashSet<String> attributes = new HashSet<String>();
        QueryViewColumn[] queryViewColumnArray = view.getColumns();
        int n = queryViewColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            QueryViewColumn column = queryViewColumnArray[n2];
            attributes.add(column.getAttributeIdentifier());
            ++n2;
        }
        return attributes;
    }

    public boolean hasRelationships() {
        return this.fSource.getRetrievalStrategy().hasRelationships();
    }

    public boolean isResolved() {
        return this.fSource.isResolved() || !this.fStatus.isOK();
    }

    public void enableUnreadFilter(boolean enable) {
        if (enable) {
            this.getResultModel().setFilter("com.ibm.team.workitem.filter.unread", new UnreadFilter());
        } else {
            this.getResultModel().removeFilter("com.ibm.team.workitem.filter.unread");
        }
    }

    public boolean isUnreadFilterSet() {
        return this.getResultModel().isFilterSet("com.ibm.team.workitem.filter.unread");
    }

    public boolean isTextFilterSet() {
        return this.getResultModel().isFilterSet("WorkItemFilter");
    }

    public String getFilterText() {
        IFilter filter = this.getResultModel().getFilter("WorkItemFilter");
        if (filter instanceof WorkItemFilter) {
            return ((WorkItemFilter)filter).getFilterText();
        }
        return "";
    }

    private IResultModel getResultModel() {
        return this.fSource.getRetrievalStrategy().getResultModel();
    }
}

