/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.viewer;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.rcp.ui.dnd.ViewerDragSupport;
import com.ibm.team.jface.util.ConvertingSelectionProvider;
import com.ibm.team.jface.viewerutilities.SelectionProvider;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.SortCriteria;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.rcp.core.internal.queries.QueryView;
import com.ibm.team.workitem.rcp.core.internal.queries.QueryViewColumn;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeColumn;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeComparatorFactory;
import com.ibm.team.workitem.rcp.ui.internal.explorer.Utils;
import com.ibm.team.workitem.rcp.ui.internal.explorer.view.WorkItemFilter;
import com.ibm.team.workitem.rcp.ui.internal.viewer.AttributeColumnManager;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IColumnObjectProvider;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IResultModel;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IWorkItemRetrievalStrategy;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ItemComparer;
import com.ibm.team.workitem.rcp.ui.internal.viewer.Messages;
import com.ibm.team.workitem.rcp.ui.internal.viewer.QuickFilter;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ResultModelContentProvider;
import com.ibm.team.workitem.rcp.ui.internal.viewer.WorkItemViewerInput;
import com.ibm.team.workitem.rcp.ui.internal.viewer.WorkItemViewerLabelProvider;
import com.ibm.team.workitem.rcp.ui.internal.viewer.WorkItemViewerTooltipSupport;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class WorkItemViewer {
    private static boolean AVOID_VM_CRASH = "gtk".equals(SWT.getPlatform());
    private TreeViewer fTreeViewer;
    private final WorkItemViewerLabelProvider fLabelProvider;
    private WorkItemViewerInput fInput;
    private final ColumnObjectProvider fColumnObjectProvider;
    private ISelectionProvider fColumnSelectionProvider = new SelectionProvider();
    private ISelectionProvider fRowSelectionProvider;
    private QuickFilter fQuickFilter;
    private QuickFilterJob fQuickFilterJob = new QuickFilterJob();
    private AttributeColumnManager fColumnManager = new AttributeColumnManager();
    private boolean fSuspendViewEvents = false;
    private SelectionListener fSortListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            WorkItemViewer.this.handleSorting(event);
        }
    };
    private ModifyListener fQuickFilterListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (WorkItemViewer.this.getRetrievalStrategy() == null) {
                return;
            }
            Text text = (Text)e.widget;
            WorkItemViewer.this.fQuickFilterJob.setText(text.getText());
        }
    };
    private Listener fColumnResizeListener = new Listener(){

        public void handleEvent(Event event) {
            if (!WorkItemViewer.this.fSuspendViewEvents) {
                WorkItemViewer.this.handleColumnResize(event);
            }
        }
    };
    private Listener fColumnMoveListener = new Listener(){

        public void handleEvent(Event event) {
            if (!WorkItemViewer.this.fSuspendViewEvents) {
                WorkItemViewer.this.handleColumnMove(event);
            }
        }
    };
    private Runnable fSelectFirstRunnable = new Runnable(){

        public void run() {
            IResultModel model = WorkItemViewer.this.getResultModel();
            if (model != null && model.size() > 0) {
                Object firstChild = model.getChild(IResultModel.ROOT, 0);
                WorkItemViewer.this.fTreeViewer.setSelection((ISelection)new StructuredSelection(firstChild));
                WorkItemViewer.this.fTreeViewer.getControl().setFocus();
            }
        }
    };

    public WorkItemViewer(Composite parent) {
        this(parent, null);
    }

    public WorkItemViewer(Composite parent, WorkItemViewerLabelProvider labelProvider) {
        this(parent, 268501762, labelProvider);
    }

    public WorkItemViewer(Composite parent, int style, WorkItemViewerLabelProvider labelProvider) {
        this.fColumnObjectProvider = new ColumnObjectProvider();
        this.fLabelProvider = labelProvider != null ? labelProvider : new WorkItemViewerLabelProvider(this.fColumnObjectProvider);
        this.fLabelProvider.setColumnObjectProvider(this.fColumnObjectProvider);
        this.createContent(parent, style);
    }

    protected void createContent(Composite parent, int style) {
        Composite viewerArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(viewerArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)viewerArea);
        Tree tree = new Tree(viewerArea, style);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tree);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        this.fTreeViewer = new TreeViewer(tree);
        this.fTreeViewer.setComparer((IElementComparer)new ItemComparer());
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeViewer.setContentProvider((IContentProvider)new ResultModelContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fRowSelectionProvider = new RowSelectionProvider((ISelectionProvider)this.fTreeViewer);
        new WorkItemViewerTooltipSupport(this);
        this.fQuickFilter = new QuickFilter(viewerArea, this.fTreeViewer.getControl());
        this.fQuickFilter.addModifyListener(this.fQuickFilterListener);
        this.fQuickFilter.hideQuickFilterArea();
        this.fQuickFilter.setRunOnEnter(this.fSelectFirstRunnable);
        this.addDragSupport();
        this.addColumnSelectionSupport();
    }

    public void setInput(WorkItemViewerInput input) {
        this.fTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        if (AVOID_VM_CRASH && this.fInput != null) {
            IWorkItemRetrievalStrategy root = this.fInput.getWorkItemSource().getRetrievalStrategy();
            this.fTreeViewer.setChildCount((Object)root, 0);
        }
        this.fInput = input;
        this.updateColumns();
        this.fLabelProvider.clearElements();
        this.fTreeViewer.setInput(this.fInput == null ? null : this.fInput.getWorkItemSource().getRetrievalStrategy());
        this.updateQuickFilter();
    }

    public WorkItemViewerInput getInput() {
        return this.fInput;
    }

    public void setView(QueryView view) {
        Assert.isNotNull((Object)view);
        this.fInput.setView(view);
        this.updateColumns();
        this.fTreeViewer.refresh();
    }

    public QueryView getView() {
        return this.fInput != null ? this.fInput.getView() : null;
    }

    public StructuredViewer getViewer() {
        return this.fTreeViewer;
    }

    public ISelectionProvider getRowSelectionProvider() {
        return this.fRowSelectionProvider;
    }

    public ISelectionProvider getColumnSelectionProvider() {
        return this.fColumnSelectionProvider;
    }

    public void reload() {
        if (this.fInput != null) {
            this.fInput.getWorkItemSource().getRetrievalStrategy().getResultModel().invalidate(IResultModel.ROOT);
            this.updateSortOrderIndication(this.fInput.getWorkItemSource().getRetrievalStrategy().getSortCriteria());
        }
    }

    public void setFocus() {
        this.fTreeViewer.getControl().setFocus();
    }

    public void installContextMenu(MenuManager menuManager) {
        Menu menu = menuManager.createContextMenu(this.fTreeViewer.getControl());
        this.fTreeViewer.getControl().setMenu(menu);
    }

    public void dispose() {
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
        }
        if (this.fQuickFilter != null) {
            this.fQuickFilter.dispose();
        }
    }

    public IColumnObjectProvider getColumnObjectProvider() {
        return this.fColumnObjectProvider;
    }

    protected void addDragSupport() {
        new ViewerDragSupport((Viewer)this.fTreeViewer, 4){

            public ISelection getSelection() {
                return WorkItemViewer.this.getRowSelectionProvider().getSelection();
            }
        };
    }

    protected void addColumnSelectionSupport() {
        this.fTreeViewer.getControl().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Utils.ColumnPosition pos = Utils.mapColumn(WorkItemViewer.this.fTreeViewer.getTree(), event.x);
                if (WorkItemViewer.this.fTreeViewer.getSelection().isEmpty() || pos == null) {
                    WorkItemViewer.this.fColumnSelectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
                } else {
                    IStructuredSelection selection = (IStructuredSelection)WorkItemViewer.this.fTreeViewer.getSelection();
                    Object columnObject = WorkItemViewer.this.fColumnObjectProvider.getObject(selection.getFirstElement(), pos.creationIndex);
                    if (columnObject != null) {
                        WorkItemViewer.this.fColumnSelectionProvider.setSelection((ISelection)new ColumnSelection(columnObject, pos));
                    } else {
                        WorkItemViewer.this.fColumnSelectionProvider.setSelection((ISelection)new ColumnSelection(pos));
                    }
                }
            }
        });
    }

    protected void handleSorting(SelectionEvent event) {
        if (this.getRetrievalStrategy() == null || this.getRetrievalStrategy().isRetrieving(IResultModel.ROOT)) {
            return;
        }
        AttributeColumn selectedColumn = (AttributeColumn)event.widget.getData();
        boolean ascending = this.updateSortOrderIndication(selectedColumn);
        IQueryableAttribute attribute = selectedColumn.getAttribute();
        Comparator<Object> comparator = AttributeComparatorFactory.createComparator(attribute);
        if (!ascending) {
            comparator = AttributeComparatorFactory.reverseComparator(comparator);
        }
        SortCriteria[] sortCriteria = new SortCriteria[]{new SortCriteria(attribute, ascending)};
        this.getRetrievalStrategy().setSortCriteria(sortCriteria);
        IResultModel model = this.getRetrievalStrategy().getResultModel();
        if (attribute.isSynthetic()) {
            model.sort(IResultModel.ROOT, attribute.getIdentifier(), comparator);
        } else {
            model.sort(IResultModel.ROOT, comparator);
        }
    }

    private void updateSortOrderIndication(SortCriteria[] sortCriteria) {
        Tree tree = this.fTreeViewer.getTree();
        if (sortCriteria.length == 0) {
            tree.setSortColumn(null);
            return;
        }
        int i = 0;
        while (i < tree.getColumnCount()) {
            AttributeColumn column = (AttributeColumn)tree.getColumn(i).getData();
            if (column.getAttribute().getIdentifier().equals(sortCriteria[0].getAttributeIdentifier())) {
                tree.setSortColumn(tree.getColumn(i));
                tree.setSortDirection(sortCriteria[0].isAscending() ? 128 : 1024);
                return;
            }
            ++i;
        }
    }

    private boolean updateSortOrderIndication(AttributeColumn sortColumn) {
        Tree tree = this.fTreeViewer.getTree();
        AttributeColumn previous = tree.getSortColumn() != null ? (AttributeColumn)tree.getSortColumn().getData() : null;
        int i = 0;
        while (i < tree.getColumnCount()) {
            AttributeColumn column = (AttributeColumn)tree.getColumn(i).getData();
            if (column.equals(sortColumn)) {
                TreeColumn treeColumn = tree.getColumn(i);
                tree.setSortColumn(treeColumn);
                if (previous != null && previous.equals(sortColumn)) {
                    int direction = tree.getSortDirection();
                    tree.setSortDirection(direction == 1024 || direction == 0 ? 128 : 1024);
                } else {
                    tree.setSortDirection(128);
                }
                return tree.getSortDirection() == 128;
            }
            ++i;
        }
        return true;
    }

    private void updateColumns() {
        try {
            TreeColumn treeColumn;
            this.fSuspendViewEvents = true;
            this.fColumnManager.setConstraints(this.fInput.getConstraints());
            List<AttributeColumn> columns = this.fColumnManager.getAttributeColumns(this.fInput.getWorkItemSource().getTeamRepository(), this.fInput.getWorkItemSource().getProjectArea(), this.fInput.getView());
            Tree tree = this.fTreeViewer.getTree();
            if (AVOID_VM_CRASH) {
                TreeColumn[] treeColumnArray = tree.getColumns();
                int n = treeColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeColumn treeColumn2 = treeColumnArray[n2];
                    treeColumn2.dispose();
                    ++n2;
                }
            }
            int[] columnOrder = tree.getColumnOrder();
            int newColumnLength = columns.size();
            int i = 0;
            while (i < newColumnLength) {
                AttributeColumn attributeColumn = columns.get(i);
                if (i < columnOrder.length) {
                    treeColumn = tree.getColumn(columnOrder[i]);
                    this.updateTreeColumn(i, treeColumn, attributeColumn);
                } else {
                    treeColumn = this.createTreeColumn(i, tree, attributeColumn);
                }
                ++i;
            }
            ArrayList<TreeColumn> toDispose = new ArrayList<TreeColumn>();
            int i2 = newColumnLength;
            while (i2 < columnOrder.length) {
                treeColumn = tree.getColumn(columnOrder[i2]);
                toDispose.add(treeColumn);
                ++i2;
            }
            for (TreeColumn treeColumn3 : toDispose) {
                treeColumn3.dispose();
            }
            this.fColumnObjectProvider.setColumns(columns, tree.getColumnOrder());
            this.updateSortOrderIndication(this.fInput.getWorkItemSource().getRetrievalStrategy().getSortCriteria());
        }
        finally {
            this.fSuspendViewEvents = false;
        }
    }

    private void updateTreeColumn(int index, TreeColumn column, AttributeColumn attributeColumn) {
        if (column.getData() != attributeColumn) {
            column.setData((Object)attributeColumn);
            column.setAlignment(attributeColumn.getAlignment());
            column.setText(attributeColumn.getHeaderName());
            column.setToolTipText(attributeColumn.getHeaderToolTip());
            int columnWidth = this.getColumnWidth(attributeColumn);
            column.setWidth(index == 0 ? columnWidth + 16 : columnWidth);
        }
    }

    private TreeColumn createTreeColumn(int index, Tree tree, AttributeColumn attributeColumn) {
        TreeColumn column = new TreeColumn(tree, attributeColumn.getAlignment());
        column.setResizable(true);
        column.setMoveable(true);
        column.addSelectionListener(this.fSortListener);
        column.addListener(11, this.fColumnResizeListener);
        column.addListener(10, this.fColumnMoveListener);
        this.updateTreeColumn(index, column, attributeColumn);
        return column;
    }

    private int getColumnWidth(AttributeColumn attributeColumn) {
        QueryViewColumn viewColumn;
        QueryView view = this.getView();
        if (view != null && (viewColumn = view.getColumn(attributeColumn.getAttribute().getIdentifier())) != null && viewColumn.getWidth() > 0) {
            return viewColumn.getWidth();
        }
        return attributeColumn.getWidth();
    }

    private void handleColumnResize(Event event) {
        TreeColumn treeColumn;
        AttributeColumn attributeColumn;
        QueryViewColumn viewColumn;
        QueryView view = this.getView();
        if (view != null && (viewColumn = view.getColumn((attributeColumn = (AttributeColumn)(treeColumn = (TreeColumn)event.widget).getData()).getAttribute().getIdentifier())) != null) {
            viewColumn.setWidth(treeColumn.getWidth());
        }
    }

    private void handleColumnMove(Event event) {
        QueryView view = this.getView();
        if (view != null) {
            ArrayList<String> columns = new ArrayList<String>();
            Tree tree = this.fTreeViewer.getTree();
            int[] nArray = tree.getColumnOrder();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int order = nArray[n2];
                AttributeColumn column = (AttributeColumn)tree.getColumn(order).getData();
                columns.add(column.getAttribute().getIdentifier());
                ++n2;
            }
            view.setColumnOrder(columns);
        }
    }

    private void updateQuickFilter() {
        if (this.fInput != null && this.fInput.isTextFilterSet()) {
            this.fQuickFilter.showQuickFilterArea(this.fInput.getFilterText());
        } else {
            this.hideQuickFindBar();
        }
    }

    public void showQuickFindBar() {
        this.fQuickFilter.showQuickFilterArea("");
    }

    public void hideQuickFindBar() {
        this.fQuickFilter.hideQuickFilterArea();
    }

    public boolean isQuickFindBarVisible() {
        return this.fQuickFilter.isVisible();
    }

    private IWorkItemRetrievalStrategy getRetrievalStrategy() {
        if (this.fInput == null) {
            return null;
        }
        return this.fInput.getWorkItemSource().getRetrievalStrategy();
    }

    private IResultModel getResultModel() {
        if (this.getRetrievalStrategy() != null) {
            return this.getRetrievalStrategy().getResultModel();
        }
        return null;
    }

    public void cancelLoad() {
        if (this.getRetrievalStrategy() != null) {
            this.getRetrievalStrategy().cancelRetrieval(IResultModel.ROOT);
        }
    }

    public void selectAll() {
        this.fTreeViewer.setSelection((ISelection)new StructuredSelection(this.getResultModel().getChildren(IResultModel.ROOT)));
    }

    public IStructuredSelection getRawSelection() {
        return (IStructuredSelection)this.fTreeViewer.getSelection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ColumnObjectProvider
    implements IColumnObjectProvider {
        private List<AttributeColumn> fColumns;
        private int[] fOrder;

        private ColumnObjectProvider() {
        }

        @Override
        public Object getObject(Object element, int columnIndex) {
            AttributeColumn column = this.getColumn(columnIndex);
            if (column != null) {
                ResolvedWorkItem resolved;
                if (column.getAttribute().isSynthetic()) {
                    return WorkItemViewer.this.getResultModel().getAnnotation(element, column.getAttribute().getIdentifier());
                }
                if (element instanceof ResolvedWorkItem && (resolved = (ResolvedWorkItem)element).contains(column.getAttribute().getIdentifier())) {
                    return resolved.getValue(column.getAttribute().getIdentifier());
                }
            }
            return null;
        }

        @Override
        public AttributeColumn getColumn(int columnIndex) {
            if (columnIndex >= 0 && this.fColumns.size() > columnIndex) {
                return this.fColumns.get(this.getVisibleIndex(columnIndex));
            }
            return null;
        }

        @Override
        public int getVisibleIndex(int creationIndex) {
            int i = 0;
            while (i < this.fOrder.length) {
                if (this.fOrder[i] == creationIndex) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        public void setColumns(List<AttributeColumn> columns, int[] order) {
            Assert.isTrue((columns.size() == order.length ? 1 : 0) != 0);
            this.fColumns = columns;
            this.fOrder = order;
        }
    }

    public static class ColumnSelection
    extends StructuredSelection {
        private final Utils.ColumnPosition fPosition;

        protected ColumnSelection(Utils.ColumnPosition position) {
            this.fPosition = position;
        }

        protected ColumnSelection(Object selection, Utils.ColumnPosition position) {
            super(selection);
            this.fPosition = position;
        }

        public Utils.ColumnPosition getPosition() {
            return this.fPosition;
        }
    }

    private class QuickFilterJob
    extends FoundationJob
    implements Runnable {
        private String fFilterText;

        public QuickFilterJob() {
            super(Messages.WorkItemViewer_FILTER_RESULTS_JOB_NAME);
        }

        public void setText(String filterText) {
            this.fFilterText = filterText;
            WorkItemViewer.this.fTreeViewer.getControl().getDisplay().timerExec(300, (Runnable)this);
        }

        public void run() {
            this.schedule();
        }

        protected IStatus runProtected(IProgressMonitor monitor) {
            Control control = WorkItemViewer.this.fTreeViewer.getControl();
            if (!control.isDisposed()) {
                try {
                    IProjectAreaHandle projectArea = WorkItemViewer.this.fInput.getWorkItemSource().getProjectArea();
                    if (projectArea == null) {
                        IAuditableClient auditableClient = (IAuditableClient)WorkItemViewer.this.fInput.getWorkItemSource().getTeamRepository().getClientLibrary(IAuditableClient.class);
                        projectArea = QueryUtils.findSomeProjectArea((IAuditableCommon)auditableClient, (IProgressMonitor)monitor);
                    }
                    final IFilter filter = WorkItemFilter.createSummaryOrDescriptionFilter(projectArea, this.fFilterText, monitor);
                    control.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            IResultModel model = WorkItemViewer.this.getRetrievalStrategy().getResultModel();
                            if (model != null) {
                                if (QuickFilterJob.this.fFilterText.length() == 0) {
                                    model.removeFilter("WorkItemFilter");
                                } else {
                                    model.setFilter("WorkItemFilter", filter);
                                }
                            }
                        }
                    });
                }
                catch (TeamRepositoryException e) {
                    WorkItemRCPUIPlugin.getDefault().log(Messages.WorkItemViewer_CANNOT_CREATE_FILTER_EXPRESSION, e);
                }
            }
            return Status.OK_STATUS;
        }
    }

    private static class RowSelectionProvider
    extends ConvertingSelectionProvider {
        public RowSelectionProvider(ISelectionProvider provider) {
            super(provider);
        }

        protected ISelection convertFrom(ISelection viewerSelection) {
            IStructuredSelection selection = (IStructuredSelection)viewerSelection;
            ArrayList<Object> converted = new ArrayList<Object>();
            for (Object element : selection) {
                if (element instanceof ResolvedWorkItem) {
                    ResolvedWorkItem resolved = (ResolvedWorkItem)element;
                    converted.add(resolved.getWorkItem());
                    continue;
                }
                converted.add(element);
            }
            return new StructuredSelection(converted);
        }
    }
}

