/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.viewer;

import com.ibm.team.collaboration.core.CollaborationCore;
import com.ibm.team.collaboration.core.session.CollaborationPresenceEvent;
import com.ibm.team.collaboration.core.session.ICollaborationPresenceListener;
import com.ibm.team.foundation.rcp.core.readstate.IReadStateListener;
import com.ibm.team.foundation.rcp.core.readstate.IReadStateManager;
import com.ibm.team.foundation.rcp.core.readstate.ReadStateChangeEvent;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.client.internal.util.WorkItemEventResolver;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.query.IResult;
import com.ibm.team.workitem.rcp.core.ClientModel;
import com.ibm.team.workitem.rcp.core.activation.WorkItemActivationEvent;
import com.ibm.team.workitem.rcp.core.activation.WorkItemActivationParticipant;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IRelation;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IRelationProvider;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IRelationshipDescriptor;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IResultModel;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IWorkItemRetrievalStrategy;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ItemComparer;
import com.ibm.team.workitem.rcp.ui.internal.viewer.Messages;
import com.ibm.team.workitem.rcp.ui.internal.viewer.RelationshipRegistry;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ResultModel;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ResultRetrievalStrategy;
import com.ibm.team.workitem.rcp.ui.internal.viewer.WorkItemResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.IFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkItemRetrievalStrategy
extends ResultRetrievalStrategy
implements IWorkItemRetrievalStrategy,
IReadStateListener {
    private ResultModel fResultModel = new ResultModel(new ResolvedWorkItemComparer());
    private ItemHandleAwareHashSet fRetrieved = new ItemHandleAwareHashSet();
    private IRelationshipDescriptor[] fRelationships = IRelationshipDescriptor.NO_RELATIONS;
    private HashSet<ITeamRepository> fRepositories = new HashSet();
    private WorkItemResolver fResolver;
    private WorkItemEventResolver fEventResolver;
    private IWorkItemListener fChangeListener = new IWorkItemListener(){

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            if (WorkItemRetrievalStrategy.this.fResultModel.contains(event.getWorkItem())) {
                WorkItemRetrievalStrategy.this.fEventResolver.workItemAttributeChanged(event);
            }
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }
    };
    private IWorkItemListener fChangeUpdater = new IWorkItemListener(){

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            Object element = WorkItemRetrievalStrategy.this.fResultModel.get(event.getWorkItem());
            if (element instanceof ResolvedWorkItem) {
                ResolvedWorkItem resolved = (ResolvedWorkItem)element;
                resolved.getWorkItemListener().workItemAttributeChanged(event);
                WorkItemRetrievalStrategy.this.unmarkRetrieved(resolved);
                WorkItemRetrievalStrategy.this.fResultModel.invalidate(resolved);
            }
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }
    };
    private WorkItemActivationParticipant fActivationParticipant = new WorkItemActivationParticipant(){

        public IStatus handleActivationEvent(WorkItemActivationEvent event, IProgressMonitor monitor) {
            WorkItemRetrievalStrategy.this.fResultModel.notifyChange(event.getWorkItem());
            return super.handleActivationEvent(event, monitor);
        }
    };
    private ICollaborationPresenceListener fPresenceListener = new ICollaborationPresenceListener(){

        public void presenceNotification(CollaborationPresenceEvent event) {
            WorkItemRetrievalStrategy.this.fResultModel.notifyChangeAll();
        }
    };

    public WorkItemRetrievalStrategy() {
        this.fEventResolver = new WorkItemEventResolver(this.fChangeUpdater);
    }

    @Override
    public IResultModel getResultModel() {
        return this.fResultModel;
    }

    @Override
    protected ResultRetrievalStrategy.RetrievalTask getChildRetrievalTask(final Object parent) {
        if (!this.hasRelationships()) {
            return null;
        }
        return new ResultRetrievalStrategy.RetrievalTask(parent){

            public String getDescription() {
                return Messages.WorkItemRetrievalStrategy_RETRIEVING_CHILDREN;
            }

            public void retrieve(IProgressMonitor monitor) throws TeamRepositoryException {
                WorkItemRetrievalStrategy.this.retrieveChildrenBackground(parent, monitor);
            }
        };
    }

    protected void retrieveChildrenBackground(Object parent, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            monitor.beginTask(Messages.WorkItemRetrievalStrategy_RETRIEVING_CHILDREN, 20);
            if (parent instanceof IRelation) {
                IRelation relation = (IRelation)parent;
                List<IWorkItemHandle> elements = relation.getItems((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                this.addWorkItems(parent, elements, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            } else {
                LinkedList<? extends IRelation> relations = new LinkedList<IRelation>();
                List<IRelationProvider> providers = RelationshipRegistry.getInstance().getRelationProviders();
                for (IRelationProvider provider : providers) {
                    relations.addAll(provider.getRelations(parent, (IProgressMonitor)new SubProgressMonitor(monitor, 20 / providers.size())));
                }
                this.fResultModel.add(parent, relations.toArray());
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void connect() {
        for (ITeamRepository repository : this.fRepositories) {
            this.addWorkItemListener(repository);
        }
        IReadStateManager.DEFAULT.addListener((IReadStateListener)this);
        ClientModel.getWorkItemActivationManager().addActivationParticipant(this.fActivationParticipant);
        CollaborationCore.getCollaborationService().addPresenceListener(this.fPresenceListener);
    }

    @Override
    public void disconnect() {
        for (ITeamRepository repository : this.fRepositories) {
            this.removeWorkItemListener(repository);
        }
        IReadStateManager.DEFAULT.removeListener((IReadStateListener)this);
        ClientModel.getWorkItemActivationManager().removeActivationParticipant(this.fActivationParticipant);
        CollaborationCore.getCollaborationService().removePresenceListener(this.fPresenceListener);
    }

    @Override
    protected void initialize() {
        this.fResultModel.clear();
        this.fRetrieved.clear();
        this.fRepositories.clear();
    }

    protected ItemProfile<IWorkItem> getItemProfile() {
        return this.fResolver.getItemProfile();
    }

    @Override
    public void setColumnIdentifiers(Collection<String> identifiers) {
        if (this.fResolver != null && this.fResolver.matches(identifiers)) {
            return;
        }
        this.fResolver = new WorkItemResolver(identifiers);
        this.fResultModel.invalidate(IResultModel.ROOT);
    }

    @Override
    public void setRelationships(IRelationshipDescriptor[] relationships) {
        IRelationshipDescriptor[] iRelationshipDescriptorArray = this.fRelationships = relationships == null ? IRelationshipDescriptor.NO_RELATIONS : relationships;
        if (this.fRelationships.length > 0) {
            this.fResultModel.setFilter("RelationFilter", new RelationFilter(this.fRelationships));
        } else {
            this.fResultModel.removeFilter("RelationFilter");
        }
    }

    @Override
    public IRelationshipDescriptor[] getRelationships() {
        return this.fRelationships;
    }

    @Override
    public boolean hasRelationships() {
        return this.getRelationships().length > 0;
    }

    @Override
    protected boolean avoidRetrieval(Object parent) {
        return !this.hasRelationships();
    }

    @Override
    protected synchronized boolean isRetrieved(Object parent) {
        return this.fRetrieved.contains(parent);
    }

    @Override
    protected synchronized void markRetrieved(Object parent) {
        this.fRetrieved.add(parent);
    }

    protected synchronized void unmarkRetrieved(Object parent) {
        this.fRetrieved.remove(parent);
    }

    protected void checkMonitor(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected void addResultItems(Object parent, List<IResult> elements, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IWorkItemHandle> handles = new ArrayList<IWorkItemHandle>(elements.size());
        for (IResult result : elements) {
            handles.add((IWorkItemHandle)result.getItem());
        }
        this.addWorkItems(parent, handles, monitor);
        for (IResult result : elements) {
            this.fResultModel.addAnnotation(result.getItem(), "score", result.getScore());
        }
    }

    protected void addWorkItems(Object parent, List<IWorkItemHandle> elements, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            monitor.beginTask(Messages.WorkItemRetrievalStrategy_RESOLVING_VALUES, 10);
            List<ResolvedWorkItem> items = this.fResolver.resolve(elements, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            for (ITeamRepository repository : this.fResolver.getTeamRepositories()) {
                this.addNewTeamRepository(repository);
            }
            this.fResultModel.add(parent, items.toArray());
        }
        finally {
            monitor.done();
        }
    }

    public void readStateChanged(ReadStateChangeEvent event) {
        IItemHandle itemHandle = event.getItemHandle();
        if (itemHandle instanceof IWorkItemHandle) {
            this.fResultModel.change(itemHandle);
        }
    }

    private void addNewTeamRepository(ITeamRepository repository) {
        if (!this.fRepositories.contains(repository)) {
            this.fRepositories.add(repository);
            this.addWorkItemListener(repository);
        }
    }

    private void addWorkItemListener(ITeamRepository repository) {
        IWorkItemClient client = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
        client.addWorkItemListener(this.fChangeListener);
    }

    private void removeWorkItemListener(ITeamRepository repository) {
        IWorkItemClient client = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
        client.removeWorkItemListener(this.fChangeListener);
    }

    private static class RelationFilter
    implements IFilter {
        public static final String ID = "RelationFilter";
        private IRelationshipDescriptor[] fRelationships;

        public RelationFilter(IRelationshipDescriptor[] relationships) {
            this.fRelationships = relationships;
        }

        public boolean select(Object toTest) {
            if (toTest instanceof IRelation) {
                boolean matches = false;
                int i = 0;
                while (i < this.fRelationships.length) {
                    matches |= this.fRelationships[i].equals(((IRelation)toTest).getDescriptor());
                    ++i;
                }
                return matches;
            }
            return true;
        }
    }

    private static class ResolvedWorkItemComparer
    extends ItemComparer {
        private ResolvedWorkItemComparer() {
        }

        public boolean equals(Object a, Object b) {
            Object o1 = a instanceof ResolvedWorkItem ? ((ResolvedWorkItem)a).getWorkItem() : a;
            Object o2 = b instanceof ResolvedWorkItem ? ((ResolvedWorkItem)b).getWorkItem() : b;
            return super.equals(o1, o2);
        }

        public int hashCode(Object element) {
            if (element instanceof ResolvedWorkItem) {
                return super.hashCode(((ResolvedWorkItem)element).getWorkItem());
            }
            return super.hashCode(element);
        }
    }
}

