/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.viewer;

import com.ibm.team.workitem.rcp.ui.internal.viewer.IResultRetrievalStrategy;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RetrievalEvent {
    public static final int STARTED = 0;
    public static final int PROGRESS = 1;
    public static final int CANCELED = 2;
    public static final int FINISHED = 3;
    public static final int FAILED = 4;
    private final int fType;
    private final int fExpectedCount;
    private final int fCurrentCount;
    private final long fElapsedTime;
    private final IStatus fStatus;
    private final IResultRetrievalStrategy fStrategy;
    private final Object fParentElement;

    public static RetrievalEvent getStartedEvent(IResultRetrievalStrategy strategy, Object parent) {
        return new RetrievalEvent(strategy, parent, 0, 0L, -1, -1, Status.OK_STATUS);
    }

    public static RetrievalEvent getFinishedEvent(IResultRetrievalStrategy strategy, Object parent, long elapsedTime, IStatus status) {
        return new RetrievalEvent(strategy, parent, 3, elapsedTime, -1, -1, status);
    }

    public static RetrievalEvent getProgressEvent(IResultRetrievalStrategy strategy, Object parent, int expectedCount, int currentCount) {
        return new RetrievalEvent(strategy, parent, 1, 0L, expectedCount, currentCount, Status.OK_STATUS);
    }

    public static RetrievalEvent getCanceledEvent(IResultRetrievalStrategy strategy, Object parent) {
        return new RetrievalEvent(strategy, parent, 2, 0L, -1, -1, Status.CANCEL_STATUS);
    }

    public static RetrievalEvent getFailedEvent(IResultRetrievalStrategy strategy, Object parent, IStatus status) {
        return new RetrievalEvent(strategy, parent, 4, 0L, -1, -1, status);
    }

    public RetrievalEvent(IResultRetrievalStrategy strategy, Object parent, int type, long elapsedTime, int expectedCount, int currentCount, IStatus status) {
        this.fType = type;
        this.fElapsedTime = elapsedTime;
        this.fExpectedCount = expectedCount;
        this.fCurrentCount = currentCount;
        this.fStatus = status;
        this.fStrategy = strategy;
        this.fParentElement = parent;
    }

    public int getType() {
        return this.fType;
    }

    public int getCurrentCount() {
        return this.fCurrentCount;
    }

    public int getExpectedCount() {
        return this.fExpectedCount;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    public long getElapsedTime() {
        return this.fElapsedTime;
    }

    public IResultRetrievalStrategy getResultRetrievalStrategy() {
        return this.fStrategy;
    }

    public Object getParentElement() {
        return this.fParentElement;
    }
}

