/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.viewer;

import com.ibm.team.workitem.rcp.ui.internal.viewer.IResultModel;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IResultModelListener;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ResultModelChangedEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IFilter;

public class ResultModel
extends EventManager
implements IResultModel {
    private static Object[] EMPTY = new Object[0];
    private IElementComparer fComparer;
    private Entry fRoot;
    private HashMap<Key, Entry> fAllElements;
    private Entry fLastAccessed;
    private HashMap<String, IFilter> fFilters;

    public ResultModel(IElementComparer comparer) {
        this.fComparer = comparer;
        this.fFilters = new HashMap();
        this.clear();
    }

    public synchronized void clear() {
        this.fRoot = new Entry(null);
        this.fRoot.setFilter(this.createFilter());
        this.fAllElements = new HashMap();
        this.fLastAccessed = null;
    }

    public synchronized Object[] getChildren(Object parent) {
        Entry entry = this.findEntry(parent);
        return entry != null ? entry.getChildren() : EMPTY;
    }

    public synchronized Object getChild(Object parent, int index) {
        Entry entry = this.findEntry(parent);
        return entry != null ? entry.getChild(index) : null;
    }

    public synchronized int getChildCount(Object element) {
        Entry entry = this.findEntry(element);
        return entry != null ? entry.getChildCount() : 0;
    }

    public synchronized int getUnfilteredChildCount(Object element) {
        Entry entry = this.findEntry(element);
        return entry != null ? entry.getUnfilteredCount() : 0;
    }

    public synchronized Object[] getParents(Object element) {
        Entry entry = this.findEntry(element);
        return entry != null ? entry.getParents() : EMPTY;
    }

    public synchronized int indexOf(Object parent, Object element) {
        Entry entry = this.findEntry(parent);
        return entry != null ? entry.indexOf(element) : -1;
    }

    public synchronized Object getAnnotation(Object element, Object columnKey) {
        Entry entry = this.findEntry(element);
        return entry != null ? entry.getAnnotation(columnKey) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(Object parent, Comparator comparator) {
        Entry entry = null;
        ResultModel resultModel = this;
        synchronized (resultModel) {
            entry = this.findEntry(parent);
            if (entry != null) {
                entry.sort(comparator);
            }
        }
        if (entry != null) {
            this.fireModelChanged(3, entry.getObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sort(Object parent, Object annotationKey, Comparator comparator) {
        Entry entry = null;
        ResultModel resultModel = this;
        synchronized (resultModel) {
            entry = this.findEntry(parent);
            if (entry != null) {
                entry.sort(annotationKey, comparator);
            }
        }
        if (entry != null) {
            this.fireModelChanged(3, entry.getObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(String key, IFilter filter) {
        ResultModel resultModel = this;
        synchronized (resultModel) {
            this.fFilters.put(key, filter);
            this.doFilter();
        }
        this.fireModelChanged(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFilter getFilter(String key) {
        ResultModel resultModel = this;
        synchronized (resultModel) {
            return this.fFilters.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilter(String key) {
        boolean hasChanged = false;
        ResultModel resultModel = this;
        synchronized (resultModel) {
            hasChanged = this.fFilters.remove(key) != null;
            this.doFilter();
        }
        if (hasChanged) {
            this.fireModelChanged(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFilterSet(String id) {
        ResultModel resultModel = this;
        synchronized (resultModel) {
            return this.fFilters.containsKey(id);
        }
    }

    public synchronized int size() {
        return this.fRoot.getChildCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void change(Object object) {
        Entry entry = null;
        ResultModel resultModel = this;
        synchronized (resultModel) {
            entry = this.findEntry(object);
        }
        if (entry != null) {
            this.fireModelChanged(2, entry.getObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(Object object) {
        Entry entry = null;
        ArrayList<Entry> changedParents = new ArrayList<Entry>();
        ResultModel resultModel = this;
        synchronized (resultModel) {
            entry = this.findEntry(object);
            if (entry != null) {
                entry.invalidate();
                if (IResultModel.ROOT == object) {
                    this.fAllElements.clear();
                } else if (!this.fFilters.isEmpty()) {
                    Object[] parents = entry.getParents();
                    Entry[] parentEntries = new Entry[parents.length];
                    int[] counts = new int[parents.length];
                    int i = 0;
                    while (i < parents.length) {
                        parentEntries[i] = this.findEntry(parents[i]);
                        counts[i] = parentEntries[i].getChildCount();
                        ++i;
                    }
                    this.doFilter();
                    i = 0;
                    while (i < parentEntries.length) {
                        if (counts[i] != parentEntries[i].getChildCount()) {
                            changedParents.add(parentEntries[i]);
                        }
                        ++i;
                    }
                }
            }
        }
        if (entry != null) {
            if (!changedParents.isEmpty()) {
                for (Entry parent : changedParents) {
                    this.fireModelChanged(6, parent.getObject());
                }
            } else {
                this.fireModelChanged(5, entry.getObject());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChange(Object parent) {
        Entry entry = null;
        ResultModel resultModel = this;
        synchronized (resultModel) {
            entry = this.findEntry(parent);
        }
        if (entry != null) {
            this.fireModelChanged(2, entry.getObject());
        }
    }

    public void notifyChangeAll() {
        this.fireModelChanged(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object parent, Object[] elements) {
        if (elements == null || elements.length == 0) {
            return;
        }
        Entry entry = null;
        ResultModel resultModel = this;
        synchronized (resultModel) {
            entry = this.findEntry(parent);
            if (entry != null) {
                entry.addChildren(elements);
            }
        }
        if (entry != null) {
            this.fireModelChanged(0, parent, elements);
        }
    }

    public synchronized void addAnnotation(Object element, Object annotationKey, Object annotationValue) {
        Entry entry = this.findEntry(element);
        if (entry != null) {
            entry.addAnnotation(annotationKey, annotationValue);
        }
    }

    public synchronized boolean contains(Object element) {
        return this.findEntry(element) != null;
    }

    public synchronized Object get(Object elementKey) {
        Entry entry = this.findEntry(elementKey);
        return entry != null ? entry.getObject() : null;
    }

    private Entry findEntry(Object element) {
        if (element == null) {
            return this.fRoot;
        }
        if (this.fLastAccessed != null && this.fLastAccessed.equals(element)) {
            return this.fLastAccessed;
        }
        this.fLastAccessed = this.fAllElements.get(new Key(element));
        return this.fLastAccessed;
    }

    private Entry createEntry(Object element) {
        Key key = new Key(element);
        Entry existing = this.fAllElements.get(key);
        if (existing == null) {
            existing = new Entry(element);
            existing.setFilter(this.createFilter());
            this.fAllElements.put(key, existing);
        }
        return existing;
    }

    private void doFilter() {
        IFilter filter = this.createFilter();
        this.fRoot.setFilter(filter);
        for (Entry entry : this.fAllElements.values()) {
            entry.setFilter(filter);
        }
    }

    private IFilter createFilter() {
        return this.fFilters.isEmpty() ? null : new CompositeFilter(this.fFilters.values());
    }

    public void addListener(IResultModelListener listener) {
        this.addListenerObject(listener);
    }

    public void removeListener(IResultModelListener listener) {
        this.removeListenerObject(listener);
    }

    public void removeAllListeners() {
        this.clearListeners();
    }

    protected void fireModelChanged(int type) {
        this.fireModelChanged(new ResultModelChangedEvent(this, type, IResultModel.ROOT, EMPTY));
    }

    protected void fireModelChanged(int type, Object parent) {
        this.fireModelChanged(new ResultModelChangedEvent(this, type, parent, EMPTY));
    }

    protected void fireModelChanged(int type, Object parent, Object[] elements) {
        this.fireModelChanged(new ResultModelChangedEvent(this, type, parent, elements));
    }

    protected void fireModelChanged(ResultModelChangedEvent event) {
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IResultModelListener)listeners[i]).modelChanged(event);
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeFilter
    implements IFilter {
        private Collection<IFilter> fFilters;

        public CompositeFilter(Collection<IFilter> filters) {
            this.fFilters = new LinkedList<IFilter>(filters);
        }

        public boolean select(Object toTest) {
            for (IFilter filter : this.fFilters) {
                if (filter.select(toTest)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry {
        private Object fObject;
        private FilteredList<Object> fChildren;
        private HashMap<Object, Object> fAnnotations;
        private HashSet<Entry> fParents;

        public Entry(Object element) {
            this.fObject = element;
            this.fChildren = new FilteredList();
            this.fAnnotations = new HashMap();
            this.fParents = new HashSet();
        }

        public boolean equals(Object object) {
            if (object instanceof Entry) {
                object = ((Entry)object).getObject();
            }
            return ResultModel.this.fComparer.equals(this.fObject, object);
        }

        public int hashCode() {
            return ResultModel.this.fComparer.hashCode(this.fObject);
        }

        public Object getChild(int index) {
            return this.fChildren.getList().get(index);
        }

        public Object[] getChildren() {
            return this.fChildren.getList().toArray();
        }

        public int getChildCount() {
            return this.fChildren.getList().size();
        }

        public int getUnfilteredCount() {
            return this.fChildren.getAll().size();
        }

        public int indexOf(Object element) {
            int index = 0;
            for (Object object : this.fChildren.getList()) {
                if (ResultModel.this.fComparer.equals(object, element)) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        public Object getObject() {
            return this.fObject;
        }

        public Object getAnnotation(Object annotationKey) {
            return this.fAnnotations.get(annotationKey);
        }

        public void addAnnotation(Object annotationKey, Object annotationValue) {
            this.fAnnotations.put(annotationKey, annotationValue);
        }

        public Object[] getParents() {
            return this.createArray(this.fParents);
        }

        public void invalidate() {
            for (Object element : this.fChildren.getAll()) {
                Entry entry = ResultModel.this.findEntry(element);
                entry.removeParent(this);
            }
            this.fChildren.clear();
        }

        public void sort(Comparator<Object> comparator) {
            Collections.sort(this.fChildren.getList(), comparator);
        }

        public void sort(final Object annotationKey, final Comparator<Object> comparator) {
            Collections.sort(this.fChildren.getList(), new Comparator<Object>(){

                @Override
                public int compare(Object element0, Object element1) {
                    Object annotation0 = ResultModel.this.getAnnotation(element0, annotationKey);
                    Object annotation1 = ResultModel.this.getAnnotation(element1, annotationKey);
                    return comparator.compare(annotation0, annotation1);
                }
            });
        }

        public void setFilter(IFilter filter) {
            this.fChildren.setFilter(filter);
        }

        public void addChildren(Object[] elements) {
            int i = 0;
            while (i < elements.length) {
                Entry entry = ResultModel.this.createEntry(elements[i]);
                entry.addParent(this);
                this.fChildren.add(entry.getObject());
                ++i;
            }
        }

        private void addParent(Entry entry) {
            this.fParents.add(entry);
        }

        private void removeParent(Entry entry) {
            this.fParents.remove(entry);
        }

        private Object[] createArray(Collection<Entry> entries) {
            int i = 0;
            Object[] objects = new Object[entries.size()];
            for (Entry entry : entries) {
                objects[i++] = entry.getObject();
            }
            return objects;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteredList<T> {
        private IFilter fFilter = null;
        private ArrayList<T> fList = new ArrayList();
        private ArrayList<T> fFilteredList = new ArrayList();

        public List<T> getAll() {
            return this.fList;
        }

        public List<T> getList() {
            if (this.fFilter == null) {
                return this.fList;
            }
            return this.fFilteredList;
        }

        public void add(T entry) {
            this.fList.add(entry);
            if (this.fFilter != null && this.fFilter.select(entry)) {
                this.fFilteredList.add(entry);
            }
        }

        public void setFilter(IFilter filter) {
            this.fFilteredList.clear();
            this.fFilter = filter;
            if (this.fFilter != null) {
                for (T entry : this.fList) {
                    if (!this.fFilter.select(entry)) continue;
                    this.fFilteredList.add(entry);
                }
            }
        }

        public void clear() {
            this.fList.clear();
            this.fFilteredList.clear();
        }
    }

    private class Key {
        private Object fObject;

        public Key(Object object) {
            this.fObject = object;
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                object = ((Key)object).fObject;
            }
            return ResultModel.this.fComparer.equals(this.fObject, object);
        }

        public int hashCode() {
            return ResultModel.this.fComparer.hashCode(this.fObject);
        }
    }
}

