/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.viewer;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IRelationProvider;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IRelationshipDescriptor;
import com.ibm.team.workitem.rcp.ui.internal.viewer.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipRegistry {
    public static final String EXTENSION_POINT_ID = "com.ibm.team.workitem.rcp.ui.relationships";
    public static final String CLASS = "class";
    private static RelationshipRegistry fgRegistry = null;
    private ArrayList<IRelationProvider> fRelationProviders = new ArrayList();

    private RelationshipRegistry() {
    }

    public static synchronized RelationshipRegistry getInstance() {
        if (fgRegistry == null) {
            fgRegistry = new RelationshipRegistry();
            fgRegistry.initialize();
        }
        return fgRegistry;
    }

    public List<IRelationProvider> getRelationProviders() {
        return Collections.unmodifiableList(this.fRelationProviders);
    }

    private void initialize() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                try {
                    this.fRelationProviders.add(this.getRelationProvider(elements[j]));
                }
                catch (CoreException e) {
                    WorkItemRCPUIPlugin.getDefault().log(e.getStatus());
                }
                ++j;
            }
            ++i;
        }
    }

    private IRelationProvider getRelationProvider(IConfigurationElement element) throws CoreException {
        Object instance = element.createExecutableExtension(CLASS);
        if (instance instanceof IRelationProvider) {
            return (IRelationProvider)instance;
        }
        String message = NLS.bind((String)Messages.RelationshipRegistry_MUST_IMPLEMENT_INTERFACE, (Object)EXTENSION_POINT_ID, (Object[])new Object[]{element.getAttribute(CLASS)});
        throw new CoreException((IStatus)new Status(4, "com.ibm.team.workitem.rcp.ui", 4, message, null));
    }

    public IRelationshipDescriptor getRelationshipDescriptor(String id) {
        for (IRelationProvider provider : this.fRelationProviders) {
            for (IRelationshipDescriptor iRelationshipDescriptor : provider.getDescriptors()) {
                if (!id.equals(iRelationshipDescriptor.getId())) continue;
                return iRelationshipDescriptor;
            }
        }
        return null;
    }

    public List<IRelationshipDescriptor> getRelationshipDescriptors() {
        LinkedList<IRelationshipDescriptor> descriptors = new LinkedList<IRelationshipDescriptor>();
        for (IRelationProvider provider : this.fRelationProviders) {
            descriptors.addAll(provider.getDescriptors());
        }
        return descriptors;
    }
}

