/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.viewer;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IRelation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class RelationLabelProvider
extends LabelProvider
implements IFontProvider,
IColorProvider {
    private Font fFont;
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());

    public String getText(Object element) {
        if (element instanceof IRelation) {
            return ((IRelation)element).getDescriptor().getName();
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof IRelation) {
            ImageDescriptor descriptor = ((IRelation)element).getDescriptor().getIcon();
            return JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)descriptor);
        }
        return null;
    }

    public Font getFont(Object element) {
        if (this.fFont == null) {
            Font defaultFont = JFaceResources.getDefaultFont();
            FontData[] data = defaultFont.getFontData();
            int i = 0;
            while (i < data.length) {
                data[i].setStyle(1);
                ++i;
            }
            this.fFont = new Font((Device)Display.getCurrent(), data);
        }
        return this.fFont;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        return Display.getCurrent().getSystemColor(16);
    }

    public void dispose() {
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        if (this.fFont != null) {
            this.fFont.dispose();
            this.fFont = null;
        }
    }
}

