/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.viewer;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class QuickFilter {
    private Composite fQuickFilterArea;
    private Text fQuickFilterInput;
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private Runnable fRunOnEnter;

    public QuickFilter(Composite parent, Control keyControl) {
        this.createQuickFilterArea(parent);
        keyControl.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character > ' ') {
                    QuickFilter.this.showQuickFilterArea(String.valueOf(e.character));
                    e.doit = false;
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public void addModifyListener(ModifyListener listener) {
        this.fQuickFilterInput.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.fQuickFilterInput.removeModifyListener(listener);
    }

    public void dispose() {
        this.fResourceManager.dispose();
    }

    private void createQuickFilterArea(Composite parent) {
        this.fQuickFilterArea = new Composite(parent, 0);
        this.fQuickFilterArea.setLayoutData((Object)new GridData(0, 0));
        GridLayoutFactory.swtDefaults().numColumns(4).margins(0, 0).extendedMargins(0, 0, 1, 0).applyTo(this.fQuickFilterArea);
        Label icon = new Label(this.fQuickFilterArea, 0);
        icon.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.QUICKFILTER_ICON));
        this.fQuickFilterInput = new Text(this.fQuickFilterArea, 2432);
        int width = Utils.convertWidthInCharsToPixels((Control)this.fQuickFilterInput, 40);
        this.fQuickFilterInput.setLayoutData((Object)new GridData(width, -1));
        this.fQuickFilterInput.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    QuickFilter.this.hideQuickFilterArea();
                    return;
                }
                if (e.keyCode == 13) {
                    QuickFilter.this.handleEnter();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        ToolBar bar = new ToolBar(this.fQuickFilterArea, 0x800000);
        bar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, true));
        if ((this.fQuickFilterInput.getStyle() & 0x100) == 0) {
            ToolItem clearItem = new ToolItem(bar, 8);
            clearItem.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.QUICKFILTER_CLEAR_ICON));
            clearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    QuickFilter.this.fQuickFilterInput.setText("");
                }
            });
        }
        ToolItem hideItem = new ToolItem(bar, 0x800000);
        hideItem.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.CLOSE_ICON));
        hideItem.setHotImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.CLOSE_ICON_ACTIVE));
        hideItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuickFilter.this.hideQuickFilterArea();
            }
        });
    }

    protected void handleEnter() {
        if (this.fRunOnEnter != null) {
            this.fRunOnEnter.run();
        }
    }

    public void setRunOnEnter(Runnable runnable) {
        this.fRunOnEnter = runnable;
    }

    public void showQuickFilterArea(String initial) {
        this.fQuickFilterArea.setVisible(true);
        this.fQuickFilterArea.setFocus();
        this.fQuickFilterArea.setLayoutData((Object)new GridData());
        this.fQuickFilterArea.getParent().layout();
        this.fQuickFilterInput.setText(initial);
        this.fQuickFilterInput.setSelection(initial.length());
    }

    public void hideQuickFilterArea() {
        this.fQuickFilterInput.setText("");
        this.fQuickFilterArea.setVisible(false);
        this.fQuickFilterArea.setLayoutData((Object)new GridData(0, 0));
        this.fQuickFilterArea.getParent().layout();
    }

    public boolean isVisible() {
        return this.fQuickFilterArea.isVisible();
    }
}

