/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.viewer;

import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.SortCriteria;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.common.query.IQueryResult;
import com.ibm.team.workitem.common.query.ResultSize;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IResultModel;
import com.ibm.team.workitem.rcp.ui.internal.viewer.Messages;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ResultRetrievalStrategy;
import com.ibm.team.workitem.rcp.ui.internal.viewer.WorkItemRetrievalStrategy;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class QueryWorkItemRetrievalStrategy
extends WorkItemRetrievalStrategy {
    private static int INITIAL_PAGE_SIZE = 20;
    private static int PAGE_SIZE_INCREMENT = 80;
    private ITeamRepository fRepository;
    private Expression fExpression;
    private SortCriteria[] fSortCriteria;
    private String fDescription;
    private ResultSize fResultSize;
    private boolean fHasRun = false;

    QueryWorkItemRetrievalStrategy(ITeamRepository repository, Expression expression, String description) {
        this.fRepository = repository;
        this.fExpression = expression;
        this.fDescription = description;
        this.fResultSize = ResultSize.UNINITIALIZED;
        if (this.fDescription == null || this.fDescription.length() == 0) {
            this.fDescription = Messages.QueryWorkItemRetrievalStrategy_RETRIEVING_RESULTS;
        }
    }

    public void setSortCriteria(SortCriteria[] criteria) {
        this.fSortCriteria = criteria;
    }

    public SortCriteria[] getSortCriteria() {
        return this.fSortCriteria;
    }

    protected ResultRetrievalStrategy.RetrievalTask getRootRetrievalTask() {
        return new ResultRetrievalStrategy.RetrievalTask(null){

            public String getDescription() {
                return QueryWorkItemRetrievalStrategy.this.fDescription;
            }

            public void retrieve(IProgressMonitor monitor) throws TeamRepositoryException {
                QueryWorkItemRetrievalStrategy.this.retrieveRootsBackground(monitor);
            }
        };
    }

    protected void retrieveRootsBackground(IProgressMonitor monitor) throws TeamRepositoryException {
        ResultSize resultSize = ResultSize.UNINITIALIZED;
        try {
            this.checkMonitor(monitor);
            FoundationUIUtils.validateRepository((ITeamRepository)this.fRepository, (boolean)false, (IProgressMonitor)monitor);
            Expression expression = QueryUtils.createSortedStatement((Expression)this.fExpression, (SortCriteria[])this.fSortCriteria);
            IQueryClient queryClient = (IQueryClient)this.fRepository.getClientLibrary(IQueryClient.class);
            IProjectAreaHandle projectArea = QueryUtils.getProjectArea((Expression)this.fExpression);
            IQueryResult result = queryClient.getExpressionResults(projectArea, expression);
            result.setPageSize(INITIAL_PAGE_SIZE);
            result.setPageSizeIncrement(PAGE_SIZE_INCREMENT);
            resultSize = result.getResultSize(monitor);
            int count = 0;
            monitor.beginTask(this.fDescription, resultSize.getTotal());
            while (result.hasNext(monitor)) {
                this.checkMonitor(monitor);
                List page = result.nextPage(monitor);
                this.checkMonitor(monitor);
                this.addResultItems(IResultModel.ROOT, page, (IProgressMonitor)new SubProgressMonitor(monitor, page.size()));
                this.fireProgressEvent(null, count += page.size(), resultSize.getTotal());
            }
        }
        finally {
            monitor.done();
            this.fResultSize = resultSize;
            this.fHasRun = true;
        }
    }

    public ResultSize getExpectedResultSize() {
        return this.fResultSize;
    }

    public boolean hasRun() {
        return this.fHasRun;
    }
}

