/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.viewer;

import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IRelation;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IRelationProvider;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IRelationshipDescriptor;
import com.ibm.team.workitem.rcp.ui.internal.viewer.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkRelationProvider
implements IRelationProvider {
    private List<LinkRelationshipDescriptor> fDescriptors;

    public List<IRelation> getRelations(Object parent, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            monitor.beginTask(Messages.LinkRelationProvider_FETCHING_RELATIONS, 10);
            LinkedList<IRelation> relations = new LinkedList<IRelation>();
            List<LinkRelationshipDescriptor> linkRelationships = this.getDescriptors();
            if (parent instanceof ResolvedWorkItem && !linkRelationships.isEmpty()) {
                IWorkItem parentWorkItem = ((ResolvedWorkItem)parent).getWorkItem();
                ITeamRepository repository = (ITeamRepository)parentWorkItem.getOrigin();
                IWorkItemClient workItemClient = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
                IWorkItemReferences references = workItemClient.resolveWorkItemReferences((IWorkItemHandle)parentWorkItem, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                for (LinkRelationshipDescriptor linkDescriptor : linkRelationships) {
                    List targetReferences = references.getReferences(linkDescriptor.getEndPointDescriptor());
                    if (targetReferences.isEmpty()) continue;
                    relations.add(new LinkRelation(parentWorkItem, linkDescriptor, targetReferences));
                }
            }
            LinkedList<IRelation> linkedList = relations;
            return linkedList;
        }
        finally {
            monitor.done();
        }
    }

    public synchronized List<LinkRelationshipDescriptor> getDescriptors() {
        if (this.fDescriptors == null) {
            LinkedList<LinkRelationshipDescriptor> descriptors = new LinkedList<LinkRelationshipDescriptor>();
            Collection linkTypes = ILinkTypeRegistry.INSTANCE.allEntries();
            for (ILinkType linkType : linkTypes) {
                if (!WorkItemLinkTypes.isSymmetric((ILinkType)linkType) && this.acceptLinkType(linkType.getSourceEndPointDescriptor(), false) && this.acceptLinkType(linkType.getTargetEndPointDescriptor(), true)) {
                    descriptors.add(new LinkRelationshipDescriptor(linkType.getSourceEndPointDescriptor()));
                }
                if (!this.acceptLinkType(linkType.getTargetEndPointDescriptor(), false) || !this.acceptLinkType(linkType.getSourceEndPointDescriptor(), true)) continue;
                descriptors.add(new LinkRelationshipDescriptor(linkType.getTargetEndPointDescriptor()));
            }
            this.fDescriptors = descriptors;
        }
        return this.fDescriptors;
    }

    private boolean acceptLinkType(IEndPointDescriptor descriptor, boolean acceptNull) {
        if (descriptor == null) {
            return acceptNull;
        }
        IItemType referencedType = descriptor.getReferencedItemType();
        if (referencedType == null) {
            return false;
        }
        return IWorkItem.ITEM_TYPE.getName().equals(referencedType.getName()) && IWorkItem.ITEM_TYPE.getNamespaceURI().equals(referencedType.getNamespaceURI());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LinkRelation
    implements IRelation {
        private LinkRelationshipDescriptor fDescriptor;
        private List fReferences;

        public LinkRelation(IWorkItem parent, LinkRelationshipDescriptor descriptor, List references) {
            this.fDescriptor = descriptor;
            this.fReferences = references;
        }

        @Override
        public IRelationshipDescriptor getDescriptor() {
            return this.fDescriptor;
        }

        @Override
        public List<IWorkItemHandle> getItems(IProgressMonitor monitor) throws TeamRepositoryException {
            try {
                monitor.beginTask(Messages.LinkRelationProvider_RETRIEVING_CHILDREN, 20);
                ArrayList<IWorkItemHandle> handles = new ArrayList<IWorkItemHandle>();
                for (Object reference : this.fReferences) {
                    Object resolved = ((IReference)reference).resolve();
                    if (!(resolved instanceof IWorkItemHandle)) continue;
                    handles.add((IWorkItemHandle)resolved);
                }
                ArrayList<IWorkItemHandle> arrayList = handles;
                return arrayList;
            }
            finally {
                monitor.done();
            }
        }
    }

    private static class LinkRelationshipDescriptor
    implements IRelationshipDescriptor {
        private IEndPointDescriptor fEndPointDescriptor;

        public LinkRelationshipDescriptor(IEndPointDescriptor endPointDescriptor) {
            this.fEndPointDescriptor = endPointDescriptor;
        }

        public IEndPointDescriptor getEndPointDescriptor() {
            return this.fEndPointDescriptor;
        }

        public ImageDescriptor getIcon() {
            return WorkItemUI.getImageDescriptor(this.fEndPointDescriptor.getIcon());
        }

        public String getName() {
            return this.fEndPointDescriptor.getDisplayName();
        }

        public String getTooltip() {
            return this.getName();
        }

        public String getId() {
            String id = this.fEndPointDescriptor.getLinkType().getLinkTypeId();
            return String.valueOf(id) + (this.fEndPointDescriptor.isSource() ? ".source" : ".target");
        }

        public boolean equals(Object obj) {
            if (obj instanceof LinkRelationshipDescriptor) {
                return this.getId().equals(((LinkRelationshipDescriptor)obj).getId());
            }
            return false;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }
    }
}

