/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.viewer;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.rcp.core.internal.queries.QueryView;
import com.ibm.team.workitem.rcp.ui.internal.queries.ExpressionDescriptionGenerator;
import com.ibm.team.workitem.rcp.ui.internal.viewer.AbstractWorkItemSource;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IWorkItemRetrievalStrategy;
import com.ibm.team.workitem.rcp.ui.internal.viewer.QueryWorkItemRetrievalStrategy;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class ExpressionWorkItemSource
extends AbstractWorkItemSource {
    private Expression fExpression;
    private ITeamRepository fTeamRepository;
    private IWorkItemRetrievalStrategy fRetrievalStrategy;
    private String fName;
    private ExpressionDescriptionGenerator fGenerator;
    private boolean fIsResolved;

    public ExpressionWorkItemSource(ITeamRepository teamRepository, Expression expression, String name) {
        Assert.isNotNull((Object)expression);
        Assert.isNotNull((Object)teamRepository);
        this.fName = name;
        this.fExpression = expression;
        this.fTeamRepository = teamRepository;
        this.fRetrievalStrategy = new QueryWorkItemRetrievalStrategy(teamRepository, expression, name);
        this.fIsResolved = false;
    }

    public String getName() {
        if (this.fGenerator != null) {
            return this.fGenerator.getDescription();
        }
        return this.fName;
    }

    public void resolve(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fName == null || this.fName.length() == 0) {
            ExpressionDescriptionGenerator generator = new ExpressionDescriptionGenerator(this.getProjectArea(), this.fExpression);
            generator.resolve(monitor);
            this.fGenerator = generator;
        }
        this.fIsResolved = true;
    }

    public boolean isResolved() {
        return this.fIsResolved;
    }

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    public IProjectAreaHandle getProjectArea() {
        return QueryUtils.getProjectArea((Expression)this.fExpression);
    }

    public IWorkItemRetrievalStrategy getRetrievalStrategy() {
        return this.fRetrievalStrategy;
    }

    public Object getDefinition() {
        return this.fExpression;
    }

    public boolean isScored() {
        return QueryUtils.isFullTextExpression((Expression)this.fExpression);
    }

    public QueryView getView(String defaultViewId) {
        return this.computeView(this.fExpression, defaultViewId, this.fName);
    }

    public boolean isEditable() {
        return this.getProjectArea() != null && !this.containsUnsupportedExpressions(this.fExpression);
    }

    public Expression getExpression() {
        return this.fExpression;
    }
}

