/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.viewer;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.SortCriteria;
import com.ibm.team.workitem.common.expression.Statement;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.rcp.core.ClientModel;
import com.ibm.team.workitem.rcp.core.internal.queries.QueriesManager;
import com.ibm.team.workitem.rcp.core.internal.queries.QueryView;
import com.ibm.team.workitem.rcp.core.internal.queries.QueryViewColumn;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IWorkItemSource;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWorkItemSource
implements IWorkItemSource {
    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    @Override
    public boolean isScored() {
        return false;
    }

    @Override
    public void resolve(IProgressMonitor monitor) throws TeamRepositoryException {
    }

    @Override
    public QueryView getView(String defaultId) {
        return this.getDefaultView(defaultId);
    }

    private QueryView getDefaultView(String defaultViewId) {
        QueryView view = ClientModel.getQueriesManager().getView(this.getTeamRepository(), defaultViewId);
        if (view == null) {
            view = this.createCopy(ClientModel.getQueriesManager().getView(this.getTeamRepository(), QueriesManager.DEFAULT_VIEW_ID));
            view.setIdentifier(defaultViewId);
            ClientModel.getQueriesManager().add(view);
        }
        return view;
    }

    protected QueryView computeView(Expression expression, String defaultViewId, String customViewId) {
        Statement statement;
        if (expression instanceof Statement && ((statement = (Statement)expression).hasSortCriteria() || statement.getSelectClause().hasColumns())) {
            boolean updateDefault = false;
            QueryView existingView = ClientModel.getQueriesManager().getView(this.getTeamRepository(), customViewId);
            QueryView defaultView = this.getDefaultView(defaultViewId);
            ArrayList<QueryViewColumn> columns = new ArrayList<QueryViewColumn>();
            List sortCriteria = statement.getSortCriteria();
            List<String> columnAttributes = statement.getSelectClause().getColumnIdentifiers();
            if (columnAttributes.isEmpty()) {
                columnAttributes = this.getDefaultColumnAttributes(defaultViewId);
                updateDefault = true;
            }
            for (String columnAttribute : columnAttributes) {
                int sortDirection = this.getSortDirection(columnAttribute, sortCriteria);
                int sortOrder = this.getSortOrder(columnAttribute, sortCriteria);
                int width = this.getWidth(columnAttribute, existingView);
                if (width == -1) {
                    width = this.getWidth(columnAttribute, defaultView);
                }
                columns.add(new QueryViewColumn(columnAttribute, true, sortDirection, sortOrder, width));
            }
            QueryViewColumn[] viewColumns = columns.toArray(new QueryViewColumn[columns.size()]);
            SortCriteria[] criteriaArray = sortCriteria.toArray(new SortCriteria[sortCriteria.size()]);
            if (existingView != null) {
                existingView.setColumns(viewColumns);
                existingView.setSortCriteria(criteriaArray);
            } else {
                existingView = new QueryView(this.getTeamRepository(), this.getName(), viewColumns, criteriaArray);
                if (customViewId != null && statement.getSelectClause().hasColumns()) {
                    existingView.setIdentifier(customViewId);
                    ClientModel.getQueriesManager().add(existingView);
                } else if (updateDefault) {
                    existingView.setUpdateDelegate(defaultView);
                }
            }
            return existingView;
        }
        return this.getDefaultView(defaultViewId);
    }

    private int getWidth(String columnAttribute, QueryView view) {
        if (view != null) {
            QueryViewColumn column = view.getColumn(columnAttribute);
            return column != null ? column.getWidth() : -1;
        }
        return -1;
    }

    private List<String> getDefaultColumnAttributes(String defaultViewId) {
        ArrayList<String> attributes = new ArrayList<String>();
        QueryView view = this.getDefaultView(defaultViewId);
        QueryViewColumn[] queryViewColumnArray = view.getColumns();
        int n = queryViewColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            QueryViewColumn column = queryViewColumnArray[n2];
            attributes.add(column.getAttributeIdentifier());
            ++n2;
        }
        return attributes;
    }

    private int getSortDirection(String columnAttribute, List<SortCriteria> sortCriteria) {
        for (SortCriteria sc : sortCriteria) {
            if (!columnAttribute.equals(sc.getAttributeIdentifier())) continue;
            return sc.isAscending() ? 1 : 2;
        }
        return 0;
    }

    private int getSortOrder(String columnAttribute, List<SortCriteria> sortCriteria) {
        int i = 0;
        while (i < sortCriteria.size()) {
            if (columnAttribute.equals(sortCriteria.get(i).getAttributeIdentifier())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private QueryView createCopy(QueryView view) {
        if (view == null) {
            return null;
        }
        return view.getCopy();
    }

    protected boolean containsUnsupportedExpressions(Expression expression) {
        boolean containsSimilarityExpression;
        boolean containsASTExpression = QueryUtils.getASTExpression((Expression)expression) != null;
        boolean bl = containsSimilarityExpression = QueryUtils.getSimilarityExpression((Expression)expression) != null;
        return containsASTExpression || containsSimilarityExpression;
    }

    public abstract Expression getExpression();
}

