/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.util;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;

public class Utils {
    public static int convertWidthInCharsToPixels(Control control, int chars) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)chars);
    }

    public static int convertHeightInCharsToPixels(Control control, int chars) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)chars);
    }

    public static int getDecorationIndent(Control control) {
        int decorationWidth;
        int indent;
        int horizontalSpacing = 5;
        Composite parent = control.getParent();
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            horizontalSpacing = ((GridLayout)layout).horizontalSpacing;
        }
        return (indent = (decorationWidth = FieldDecorationRegistry.getDefault().getFieldDecoration((String)"DEC_WARNING").getImage().getBounds().width) - horizontalSpacing) < 0 ? 0 : indent;
    }

    public static String getDecorationId(IStatus status) {
        switch (status.getSeverity()) {
            case 4: {
                return "DEC_ERROR";
            }
            case 2: {
                return "DEC_WARNING";
            }
            case 1: {
                return "DEC_INFORMATION";
            }
        }
        return "DEC_INFORMATION";
    }

    public static String escapeText(String actionLabel) {
        if (actionLabel.indexOf(64) > -1) {
            return String.valueOf(actionLabel) + '@';
        }
        return actionLabel;
    }

    public static String escapeToHTML(String text) {
        return XMLString.createFromPlainText((String)text).getXMLText();
    }

    public static void copyLabel(ViewerLabel label, ViewerCell cell) {
        cell.setText(label.getText());
        cell.setImage(label.getImage());
        cell.setFont(label.getFont());
        cell.setBackground(label.getBackground());
        cell.setForeground(label.getForeground());
    }

    public static FontDescriptor createRelativeHeightFontDescriptor(int relativeHeight) {
        return Utils.createRelativeHeightFontDescriptor(relativeHeight, 0);
    }

    public static FontDescriptor createRelativeHeightFontDescriptor(int relativeHeight, int style) {
        Font font = JFaceResources.getDefaultFont();
        FontData[] defFont = font.getFontData();
        int i = 0;
        while (i < defFont.length) {
            defFont[i].setHeight(defFont[i].getHeight() + relativeHeight);
            defFont[i].setStyle(defFont[i].getStyle() | style);
            ++i;
        }
        return FontDescriptor.createFrom((FontData[])defFont);
    }

    public static String getMessage(MultiStatus status) {
        int maxSeverity = status.getSeverity();
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus childStatus = iStatusArray[n2];
            if (childStatus.getSeverity() == maxSeverity) {
                return childStatus.getMessage();
            }
            ++n2;
        }
        return null;
    }

    public static int getMessageProviderType(IStatus status) {
        int type;
        switch (status.getSeverity()) {
            case 4: 
            case 8: {
                type = 3;
                break;
            }
            case 2: {
                type = 2;
                break;
            }
            case 1: {
                type = 1;
                break;
            }
            default: {
                type = 0;
            }
        }
        return type;
    }

    public static void updateColumnWidths(Tree tree, int ... relativeWidths) {
        Utils.updateColumnWidths((Composite)tree, relativeWidths);
    }

    public static void updateColumnWidths(Table table, int ... relativeWidths) {
        Utils.updateColumnWidths((Composite)table, relativeWidths);
    }

    private static void updateColumnWidths(final Composite columnComposite, int ... relativeWidths) {
        int columnCount = Utils.getColumnCount(columnComposite);
        if (relativeWidths.length == 0) {
            relativeWidths = new int[columnCount];
            Arrays.fill(relativeWidths, 1);
        }
        Assert.isTrue((relativeWidths.length == columnCount ? 1 : 0) != 0);
        final int[] widths = relativeWidths;
        columnComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (columnComposite.getBounds().width == 0) {
                    return;
                }
                columnComposite.removeControlListener((ControlListener)this);
                if ("gtk".equals(SWT.getPlatform())) {
                    Utils.setWidths(columnComposite, Utils.getAvailableWidth(columnComposite), widths);
                } else {
                    columnComposite.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (!columnComposite.isDisposed()) {
                                Utils.setWidths(columnComposite, Utils.getAvailableWidth(columnComposite), widths);
                            }
                        }
                    });
                }
            }
        });
    }

    private static void setWidths(Composite columnComposite, int available, int[] relativeWidths) {
        int relativeSum = 0;
        int i = 0;
        int n = relativeWidths.length;
        while (i < n) {
            if (relativeWidths[i] == -1) {
                available -= Utils.getColumnWidth(columnComposite, i);
            } else {
                relativeSum += relativeWidths[i];
            }
            ++i;
        }
        if (available <= 0 || relativeSum <= 0) {
            return;
        }
        i = 0;
        int j = 0;
        int n2 = relativeWidths.length;
        while (i < n2) {
            if (relativeWidths[i] != -1) {
                int jp1 = j + relativeWidths[i];
                int w = available * jp1 / relativeSum - available * j / relativeSum;
                Utils.setColumnWidth(columnComposite, i, w);
                j = jp1;
            }
            ++i;
        }
    }

    private static int getAvailableWidth(Composite columnComposite) {
        Rectangle computeTrim = columnComposite.computeTrim(0, 0, 0, 0);
        if ("carbon".equals(SWT.getPlatform())) {
            int trim = computeTrim.width - computeTrim.x;
            return columnComposite.getClientArea().width - trim;
        }
        int trim = computeTrim.width;
        return columnComposite.getBounds().width - trim;
    }

    private static int getColumnCount(Composite columnComposite) {
        if (columnComposite instanceof Tree) {
            return ((Tree)columnComposite).getColumnCount();
        }
        return ((Table)columnComposite).getColumnCount();
    }

    private static int getColumnWidth(Composite columnComposite, int columnIndex) {
        if (columnComposite instanceof Tree) {
            return ((Tree)columnComposite).getColumn(columnIndex).getWidth();
        }
        return ((Table)columnComposite).getColumn(columnIndex).getWidth();
    }

    private static void setColumnWidth(Composite columnComposite, int columnIndex, int width) {
        if (columnComposite instanceof Tree) {
            ((Tree)columnComposite).getColumn(columnIndex).setWidth(width);
        } else {
            ((Table)columnComposite).getColumn(columnIndex).setWidth(width);
        }
    }

    public static boolean saveNewWorkItem(IRunnableContext runnableContext, final IEditorPart editorPart, WorkItemWorkingCopy workingCopy) {
        block5: {
            if (workingCopy.getWorkItem().isNewItem()) break block5;
            return true;
        }
        try {
            if (!workingCopy.isDirty()) {
                ((WorkItemWorkingCopyImpl)workingCopy).setDirty(true);
            }
            runnableContext.run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    editorPart.doSave(monitor);
                }
            });
            return !workingCopy.getWorkItem().isNewItem();
        }
        catch (InvocationTargetException x) {
            Throwable cause = x.getCause() != null ? x.getCause() : x;
            FoundationLog log = FoundationLog.getLog((String)"com.ibm.team.workitem.rcp.ui");
            log.error(cause.getMessage(), cause);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }
}

