/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.util;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.jface.StandardControlLabelProvider;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.viewerutilities.SelectionProvider;
import com.ibm.team.workitem.rcp.ui.internal.util.Messages;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class HyperlinkUtils {
    public static DecoratedHyperlink createDecoratedHyperlink(Control control) {
        final StandardControlLabelProvider hyperlinkLabelProvider = new StandardControlLabelProvider(control);
        hyperlinkLabelProvider.setForegroundAware(true);
        hyperlinkLabelProvider.setTextAware(true);
        FoundationJob job = new FoundationJob(Messages.HyperlinkUtils_OPEN_LINK){

            protected IStatus runProtected(IProgressMonitor monitor) {
                Object element = hyperlinkLabelProvider.getElement();
                if (element == null) {
                    return Status.CANCEL_STATUS;
                }
                URIReference reference = Hyperlinks.create((Object)element, (IProgressMonitor)monitor);
                if (reference == null) {
                    return Status.CANCEL_STATUS;
                }
                Hyperlinks.open((URI)reference.getURI(), null, (IProgressMonitor)monitor);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        if (control instanceof Hyperlink) {
            Hyperlink hyperlink = (Hyperlink)control;
            hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter((Job)job){
                private final /* synthetic */ Job val$job;
                {
                    this.val$job = job;
                }

                public void linkActivated(HyperlinkEvent e) {
                    this.val$job.schedule();
                }
            });
        } else if (control instanceof Link) {
            Link link = (Link)control;
            link.addSelectionListener((SelectionListener)new SelectionAdapter((Job)job){
                private final /* synthetic */ Job val$job;
                {
                    this.val$job = job;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.val$job.schedule();
                }
            });
        }
        new TooltipSupport(control, true, false){

            protected Object mapElement(int x, int y) {
                return hyperlinkLabelProvider.getElement();
            }
        };
        SelectionProvider selectionProvider = new SelectionProvider(){

            public ISelection getSelection() {
                Object data = hyperlinkLabelProvider.getElement();
                return data == null ? StructuredSelection.EMPTY : new StructuredSelection(data);
            }
        };
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
        return new DecoratedHyperlink(hyperlinkLabelProvider, menuMgr, (ISelectionProvider)selectionProvider);
    }

    public static class DecoratedHyperlink {
        private final StandardControlLabelProvider fControlLabelProvider;
        private final MenuManager fMenuManager;
        private final ISelectionProvider fSelectionProvider;

        public DecoratedHyperlink(StandardControlLabelProvider controlLabelProvider, MenuManager menuManager, ISelectionProvider selectionProvider) {
            this.fControlLabelProvider = controlLabelProvider;
            this.fMenuManager = menuManager;
            this.fSelectionProvider = selectionProvider;
        }

        public StandardControlLabelProvider getControlLabelProvider() {
            return this.fControlLabelProvider;
        }

        public MenuManager getMenuManager() {
            return this.fMenuManager;
        }

        public ISelectionProvider getSelectionProvider() {
            return this.fSelectionProvider;
        }
    }
}

