/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.util;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DefaultCheckStateBehavior
extends SelectionAdapter
implements TreeListener {
    public static void install(Tree tree) {
        DefaultCheckStateBehavior behavior = new DefaultCheckStateBehavior();
        tree.addSelectionListener((SelectionListener)behavior);
        tree.addTreeListener((TreeListener)behavior);
    }

    public static void checkTree(Tree tree) {
        DefaultCheckStateBehavior.checkTree(tree.getItems());
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.detail == 32) {
            DefaultCheckStateBehavior.handleItem(event);
        }
    }

    public void treeExpanded(TreeEvent event) {
        TreeItem item = (TreeItem)event.item;
        if (item.getChecked() && !item.getGrayed()) {
            DefaultCheckStateBehavior.handleItem((SelectionEvent)event);
        }
    }

    public void treeCollapsed(TreeEvent e) {
    }

    private static void handleItem(SelectionEvent event) {
        TreeItem item = (TreeItem)event.item;
        boolean checked = item.getChecked();
        DefaultCheckStateBehavior.checkItems(item, checked);
        DefaultCheckStateBehavior.checkPath(item.getParentItem(), checked, false);
    }

    private static void checkPath(TreeItem item, boolean checked, boolean grayed) {
        if (item == null) {
            return;
        }
        if (grayed) {
            checked = true;
        } else {
            int index = 0;
            TreeItem[] items = item.getItems();
            while (index < items.length) {
                TreeItem child = items[index];
                if (child.getGrayed() || checked != child.getChecked()) {
                    grayed = true;
                    checked = true;
                    break;
                }
                ++index;
            }
        }
        item.setChecked(checked);
        item.setGrayed(grayed);
        DefaultCheckStateBehavior.checkPath(item.getParentItem(), checked, grayed);
    }

    private static void checkItems(TreeItem item, boolean checked) {
        item.setGrayed(false);
        item.setChecked(checked);
        TreeItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            DefaultCheckStateBehavior.checkItems(items[i], checked);
            ++i;
        }
    }

    private static void checkTree(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getChecked() && !item.getGrayed()) {
                DefaultCheckStateBehavior.checkItems(item, true);
                DefaultCheckStateBehavior.checkPath(item.getParentItem(), true, false);
            } else {
                DefaultCheckStateBehavior.checkTree(item.getItems());
            }
            ++n2;
        }
    }
}

