/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.quicksearch;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.client.IQueryListener;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.QueryEventAdapter;
import com.ibm.team.workitem.client.QueryExecutionStateChangeEvent;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.expression.SelectClause;
import com.ibm.team.workitem.common.expression.SortCriteria;
import com.ibm.team.workitem.common.expression.Statement;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.expression.VariableAttributeExpression;
import com.ibm.team.workitem.common.expression.variables.IAttributeVariable;
import com.ibm.team.workitem.common.expression.variables.StatusVariable;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.common.internal.util.ValidationUtils;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.QueriesUI;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.ProjectAreaPicker;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.actions.ProjectAreaSelectionAction;
import com.ibm.team.workitem.rcp.ui.internal.queries.Queries;
import com.ibm.team.workitem.rcp.ui.internal.quicksearch.DropDownToolItem;
import com.ibm.team.workitem.rcp.ui.internal.quicksearch.Messages;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.swt.IFocusService;

public class QuickSearch {
    private static final String QUICK_SEARCH_CONTEXT = "com.ibm.team.workitem.query.context.quicksearch";
    private static final String QUICK_SEARCH_COMMAND_EXECUTE = "com.ibm.team.workitem.query.command.quicksearch.execute";
    private static final String QUICKSEARCH_TEXT_CONTROL = "com.ibm.team.workitem.quicksearch";
    private static final int MIN_SEARCHBOX_SIZE = 220;
    private IHandler fExecuteHandler = new AbstractHandler(){

        public Object execute(ExecutionEvent arg0) throws ExecutionException {
            QuickSearch.this.executeQuery();
            return null;
        }
    };
    private Composite fQuickContainer;
    private Text fQuickSearchText;
    private IWorkbenchWindow fWorkBenchWindow;
    private final ResourceManager fResourceManager;
    private final Image fProjectAreaIcon;
    private final Image fRepositoryIcon;
    private IContextActivation fContextActivation;
    private IHandlerActivation fHandlerActivation;
    private QueryAction fCurrentAction;
    private int fFocusGainedTime;
    private ControlDecoration fControlDecoration;
    private ProjectAreaSelectionAction fProjectAreaSelectionAction;
    private CLabel fCurrentScopeLabel;
    private boolean fShowingCurrentScopeLabel;
    private NotFoundStatus fNotFound = NotFoundStatus.OK;
    private GridDataFactory fQuickSearchTextDefaults;
    private GridDataFactory fQuickSearchTextNotFound;

    public QuickSearch(Composite parent, IWorkbenchWindow workbenchWindow) {
        this.fWorkBenchWindow = workbenchWindow;
        this.fCurrentAction = new QueryAllOpenAction();
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.fProjectAreaIcon = JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.PROJECT_AREA);
        this.fRepositoryIcon = JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.TEAM_REPOSITORY);
        this.createQuickSearch(parent);
    }

    public void dispose() {
        this.activateContext(false);
        this.fQuickContainer.dispose();
        if (this.fProjectAreaSelectionAction != null) {
            this.fProjectAreaSelectionAction.dispose();
        }
        this.fResourceManager.dispose();
    }

    public Composite getControl() {
        return this.fQuickContainer;
    }

    public Text getTextBox() {
        return this.fQuickSearchText;
    }

    private void createQuickSearch(Composite parent) {
        this.fQuickContainer = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.fQuickContainer);
        this.fQuickContainer.setBackground(parent.getBackground());
        Composite quickTextBox = new Composite(this.fQuickContainer, 0);
        quickTextBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        quickTextBox.setLayout((Layout)new GridLayout(3, false));
        ((GridLayout)quickTextBox.getLayout()).marginHeight = 0;
        ((GridLayout)quickTextBox.getLayout()).marginTop = "win32".equals(SWT.getPlatform()) ? 2 : 0;
        ((GridLayout)quickTextBox.getLayout()).horizontalSpacing = 0;
        quickTextBox.setBackground(quickTextBox.getParent().getBackground());
        this.fProjectAreaSelectionAction = new ProjectAreaSelectionAction("query", true){

            protected void fillMenu(Menu menu) {
                super.fillMenu(menu);
                if (menu.getItemCount() > 0) {
                    new Separator("QueriesStart").fill(menu, -1);
                }
                QueryAllAction all = new QueryAllAction();
                new ActionContributionItem((IAction)all).fill(menu, -1);
                QueryAllOpenAction allOpen = new QueryAllOpenAction();
                new ActionContributionItem((IAction)allOpen).fill(menu, -1);
                new Separator().fill(menu, -1);
                new ActionContributionItem((IAction)new HideAction()).fill(menu, -1);
            }

            protected void updateConnectionStatus() {
                super.updateConnectionStatus();
                if (QuickSearch.this.fQuickSearchText != null && !QuickSearch.this.fQuickSearchText.isDisposed()) {
                    QuickSearch.this.fQuickSearchText.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (QuickSearch.this.fQuickSearchText == null || QuickSearch.this.fQuickSearchText.isDisposed()) {
                                return;
                            }
                            QuickSearch.this.updateConnectionLabel();
                            QuickSearch.this.updateTooltip();
                        }
                    });
                }
                UIJob job = new UIJob(Messages.QuickSearch_UPDATE_QUICKSEARCH_BAR){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        QuickSearch.this.updateCurrentScope();
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }

            protected void projectAreaSelected(IProjectAreaHandle projectAreaHandle) {
                QuickSearch.this.updateTooltip();
                QuickSearch.this.updateCurrentScopeLabel();
            }

            protected void repositorySelected(ITeamRepository currentTeamRepository) {
                QuickSearch.this.updateTooltip();
                QuickSearch.this.updateCurrentScopeLabel();
            }

            public void defaultProjectAreaChanged(IProjectAreaHandle before, IProjectAreaHandle after) {
                Object origin;
                this.updateConnectionStatus();
                if (after != null && (origin = after.getOrigin()) instanceof ITeamRepository && (before == null || !origin.equals(before.getOrigin()))) {
                    QuickSearch.this.hideNotFoundMessage();
                }
            }

            public void run() {
                QuickSearch.this.executeQuery();
            }
        };
        this.fProjectAreaSelectionAction.setImageDescriptor(ImagePool.QUERY_OBJECT);
        this.fProjectAreaSelectionAction.setToolTipText(Messages.QuickSearch_SEARCH_BY_ID_OR_TEXT_TOOLTIP);
        ToolBar toolBar = new ToolBar(quickTextBox, 0x800100);
        toolBar.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        toolBar.setBackground(toolBar.getParent().getBackground());
        new DropDownToolItem(toolBar, (IAction)this.fProjectAreaSelectionAction);
        toolBar.pack();
        this.fQuickSearchText = new Text(quickTextBox, 2436);
        this.fQuickSearchText.setMessage(Messages.QuickSearch_TEXTFIELD_MESSAGE);
        int indent = Utils.getDecorationIndent((Control)this.fQuickSearchText);
        this.fQuickSearchTextDefaults = GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).indent(indent, 0).minSize(220, 0);
        this.fQuickSearchTextNotFound = GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).indent(indent, 0);
        this.fQuickSearchTextDefaults.applyTo((Control)this.fQuickSearchText);
        this.fQuickSearchText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                QuickSearch.this.fFocusGainedTime = e.time;
                QuickSearch.this.fQuickSearchText.selectAll();
                QuickSearch.this.activateContext(true);
            }

            public void focusLost(FocusEvent e) {
                QuickSearch.this.activateContext(false);
            }
        });
        this.fQuickSearchText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (QuickSearch.this.fFocusGainedTime == e.time) {
                    QuickSearch.this.fQuickSearchText.selectAll();
                }
            }
        });
        this.fQuickSearchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 0 && e.keyCode == 13) {
                    QuickSearch.this.executeQuery();
                }
            }
        });
        this.fControlDecoration = new ControlDecoration((Control)this.fQuickSearchText, 0x1004000);
        this.fControlDecoration.hide();
        this.fControlDecoration.setShowHover(true);
        this.fQuickSearchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QuickSearch.this.hideNotFoundMessage();
                IStatus validationStatus = ValidationUtils.validatePhraseSearch((String)QuickSearch.this.fQuickSearchText.getText());
                QuickSearch.this.updateCurrentScopeLabel();
                QuickSearch.this.updateValidationStatus(validationStatus);
            }
        });
        IFocusService focusService = (IFocusService)this.fWorkBenchWindow.getService(IFocusService.class);
        focusService.addFocusTracker((Control)this.fQuickSearchText, QUICKSEARCH_TEXT_CONTROL);
        if (this.fProjectAreaSelectionAction.getTeamRepository() == null) {
            this.updateConnectionLabel();
        }
        this.fCurrentScopeLabel = new CLabel(quickTextBox, 0){

            protected String shortenText(GC gc, String text, int width) {
                if (gc.textExtent((String)text, (int)8).x <= width) {
                    return text;
                }
                int ellipseWidth = gc.textExtent((String)"...", (int)8).x;
                int length = text.length();
                int end = length - 1;
                while (end > 0) {
                    text = text.substring(0, end);
                    int l1 = gc.textExtent((String)text, (int)8).x;
                    if (l1 + ellipseWidth <= width) {
                        return String.valueOf(text) + "...";
                    }
                    --end;
                }
                return String.valueOf(text) + "...";
            }
        };
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)this.fCurrentScopeLabel);
        ((GridData)this.fCurrentScopeLabel.getLayoutData()).grabExcessHorizontalSpace = true;
        this.updateCurrentScope();
        this.updateTooltip();
    }

    private static boolean isID(String queryString) {
        if (queryString == null || queryString.length() == 0) {
            return false;
        }
        Integer id = Queries.getWorkItemId(queryString);
        return id != null;
    }

    private void updateCurrentScope() {
        int numberOfConnectedProjectAreas = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(null).size();
        if (numberOfConnectedProjectAreas > 1 && !this.fShowingCurrentScopeLabel) {
            this.fShowingCurrentScopeLabel = true;
            this.updateCurrentScopeLabel();
        } else if (numberOfConnectedProjectAreas <= 1 && this.fShowingCurrentScopeLabel) {
            this.fShowingCurrentScopeLabel = false;
            this.updateCurrentScopeLabel();
        }
    }

    private void updateCurrentScopeLabel() {
        if (this.fCurrentScopeLabel == null) {
            return;
        }
        String projectAreaDisplayName = this.getProjectAreaDisplayName();
        if (QuickSearch.isID(this.fQuickSearchText.getText()) || projectAreaDisplayName == null) {
            String repositoryDisplayName = this.getRepositoryDisplayName(this.fProjectAreaSelectionAction.getTeamRepository());
            if (repositoryDisplayName != null) {
                this.fCurrentScopeLabel.setImage(this.fRepositoryIcon);
                this.setCurrentScopeLabelText(repositoryDisplayName);
            }
        } else if (projectAreaDisplayName != null) {
            this.fCurrentScopeLabel.setImage(this.fProjectAreaIcon);
            this.setCurrentScopeLabelText(projectAreaDisplayName);
        }
        this.fCurrentScopeLabel.getParent().layout(true);
    }

    private void showNotFoundMessage(NotFoundStatus status) {
        if (this.fNotFound != NotFoundStatus.OK) {
            return;
        }
        this.fNotFound = status;
        this.fQuickSearchTextNotFound.applyTo((Control)this.fQuickSearchText);
        this.updateCurrentScopeLabel();
    }

    private void hideNotFoundMessage() {
        if (this.fNotFound == NotFoundStatus.OK) {
            return;
        }
        this.fNotFound = NotFoundStatus.OK;
        this.fQuickSearchTextDefaults.applyTo((Control)this.fQuickSearchText);
        this.updateCurrentScopeLabel();
    }

    private void setCurrentScopeLabelText(String text) {
        if (this.fNotFound != NotFoundStatus.OK) {
            if (this.fNotFound == NotFoundStatus.NOT_FOUND) {
                if (this.fShowingCurrentScopeLabel) {
                    this.fCurrentScopeLabel.setText(NLS.bind((String)Messages.QuickSearch_NOT_FOUND_IN, (Object)text, (Object[])new Object[0]));
                } else {
                    this.fCurrentScopeLabel.setText(Messages.QuickSearch_NOT_FOUND);
                }
            } else if (this.fShowingCurrentScopeLabel) {
                this.fCurrentScopeLabel.setText(NLS.bind((String)Messages.QuickSearch_NOT_PERMITTED_IN, (Object)text, (Object[])new Object[0]));
            } else {
                this.fCurrentScopeLabel.setText(Messages.QuickSearch_NOT_PERMITTED);
            }
            this.fCurrentScopeLabel.setForeground(this.fQuickSearchText.getDisplay().getSystemColor(3));
        } else {
            this.fCurrentScopeLabel.setText(text);
            this.fCurrentScopeLabel.setForeground(this.fQuickSearchText.getDisplay().getSystemColor(2));
        }
    }

    private void executeQuery() {
        if (this.fQuickSearchText.isDisposed()) {
            return;
        }
        final String queryString = this.fQuickSearchText.getText().trim();
        if (queryString.length() == 0) {
            return;
        }
        ITeamRepository repository = this.fProjectAreaSelectionAction.getTeamRepository();
        if (repository == null) {
            return;
        }
        final IWorkItemClient workItemClient = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
        final IQueryClient queryClient = (IQueryClient)repository.getClientLibrary(IQueryClient.class);
        final IProjectAreaHandle projectArea = this.fProjectAreaSelectionAction.getProjectArea();
        UIUpdaterJob job = new UIUpdaterJob(Messages.QuickSearch_EXECUTE_QUERY_JOB_NAME){
            private Expression fCombinedExpression;
            private IWorkItemHandle fWorkItemHandle;

            public IStatus runInBackground(IProgressMonitor monitor) {
                try {
                    Integer id = Queries.getWorkItemId(queryString);
                    if (id != null) {
                        return this.handleWorkItemId(id, monitor);
                    }
                    return this.handleFulltext(monitor);
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.workitem.rcp.ui", 4, Messages.QuickSearch_CREATE_EXPRESSION_ERROR, (Throwable)e);
                }
            }

            private IStatus handleFulltext(IProgressMonitor monitor) throws TeamRepositoryException {
                IProjectAreaHandle attributeProjectArea = projectArea;
                if (attributeProjectArea == null) {
                    attributeProjectArea = QueryUtils.findSomeProjectArea((IAuditableCommon)workItemClient.getAuditableCommon(), (IProgressMonitor)monitor);
                }
                Expression fulltextPart = QueryUtils.createFullTextExpression((IAuditableCommon)workItemClient.getAuditableCommon(), (IProjectAreaHandle)attributeProjectArea, (String)queryString, (IProgressMonitor)monitor);
                this.fCombinedExpression = QuickSearch.this.fCurrentAction.getExpression() != null ? new Term(0, new Expression[]{fulltextPart, QuickSearch.this.fCurrentAction.getExpression()}) : fulltextPart;
                queryClient.addQueryListener((Object)"com.ibm.team.workitem.query.event.ExecutionDone", (IQueryListener)new QueryEventAdapter(){

                    protected void executionStateChanged(QueryExecutionStateChangeEvent event) {
                        Expression embedded = (Expression)event.getExecutable();
                        if (event.getExecutable() instanceof Statement) {
                            embedded = ((Statement)event.getExecutable()).getConditions();
                        }
                        if (embedded == fCombinedExpression) {
                            QuickSearch.this.updateNotFoundStatus(event.getResultCount() > 0 ? NotFoundStatus.OK : NotFoundStatus.NOT_FOUND);
                            queryClient.removeQueryListener((Object)"com.ibm.team.workitem.query.event.ExecutionDone", (IQueryListener)this);
                        }
                    }
                });
                return Status.OK_STATUS;
            }

            private IStatus handleWorkItemId(int id, IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    this.fWorkItemHandle = workItemClient.findWorkItemById(id, IWorkItem.SMALL_PROFILE, monitor);
                    QuickSearch.this.updateNotFoundStatus(this.fWorkItemHandle != null ? NotFoundStatus.OK : NotFoundStatus.NOT_FOUND);
                }
                catch (PermissionDeniedException permissionDeniedException) {
                    QuickSearch.this.updateNotFoundStatus(NotFoundStatus.NO_PERMISSIONS);
                }
                return Status.OK_STATUS;
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                if (this.fCombinedExpression != null) {
                    SortCriteria sortOrder = new SortCriteria("score", false);
                    Statement statement = new Statement(new SelectClause(), this.fCombinedExpression, new SortCriteria[]{sortOrder});
                    String name = NLS.bind((String)Messages.QuickSearch_QUERY_NAME_FORMAT, (Object)QuickSearch.this.fCurrentAction.getText(), (Object[])new Object[]{queryString});
                    QueriesUI.showQueryResults(QuickSearch.this.fWorkBenchWindow, workItemClient.getTeamRepository(), name, (Expression)statement);
                }
                if (this.fWorkItemHandle != null) {
                    WorkItemUI.openEditor(QuickSearch.this.fWorkBenchWindow.getActivePage(), this.fWorkItemHandle);
                }
                return super.runInUI(monitor);
            }
        };
        job.setSystem(false);
        job.schedule();
    }

    private void updateConnectionLabel() {
        if (this.fQuickSearchText.isDisposed()) {
            return;
        }
        if (this.fQuickSearchText.isEnabled() && this.fProjectAreaSelectionAction.getTeamRepository() == null) {
            this.fQuickSearchText.setText(Messages.QuickSearch_NOT_CONNECTED_MESSAGE);
            this.fQuickSearchText.setEnabled(false);
        } else if (!this.fQuickSearchText.isEnabled() && this.fProjectAreaSelectionAction.getTeamRepository() != null) {
            this.fQuickSearchText.setText("");
            this.fQuickSearchText.setEnabled(true);
        }
    }

    private void updateTooltip() {
        ITeamRepository repository = this.fProjectAreaSelectionAction.getTeamRepository();
        if (this.fCurrentAction != null && repository != null) {
            String repo = this.getRepositoryDisplayName(repository);
            String scope = this.getProjectAreaDisplayName();
            if (scope == null) {
                scope = repo;
            }
            scope = scope.trim();
            String tooltipText = NLS.bind((String)Messages.QuickSearch_TOOLTIP_FORMAT, (Object)this.fCurrentAction.getText(), (Object[])new Object[]{scope, repo});
            this.fProjectAreaSelectionAction.setToolTipText(tooltipText);
            this.fCurrentScopeLabel.setToolTipText(tooltipText);
        } else {
            this.fProjectAreaSelectionAction.setToolTipText(Messages.QuickSearch_NOT_CONNECTED_MESSAGE);
        }
    }

    private String getProjectAreaDisplayName() {
        IProjectAreaHandle projectArea = this.fProjectAreaSelectionAction.getProjectArea();
        if (projectArea != null) {
            List areas = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(null);
            return ProjectAreaPicker.getUnambiguousProjectName(areas, projectArea);
        }
        return null;
    }

    private String getRepositoryDisplayName(ITeamRepository repository) {
        if (repository == null) {
            return null;
        }
        String repo = repository.getName();
        if (repo == null || repo.equals("")) {
            repo = repository.getRepositoryURI();
        }
        repo = repo.trim();
        return repo;
    }

    private void updateNotFoundStatus(final NotFoundStatus status) {
        if (!this.fQuickSearchText.isDisposed()) {
            this.fQuickSearchText.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!QuickSearch.this.fQuickSearchText.isDisposed() && status == NotFoundStatus.OK) {
                        QuickSearch.this.hideNotFoundMessage();
                    } else if (!QuickSearch.this.fQuickSearchText.isDisposed()) {
                        QuickSearch.this.fQuickSearchText.getDisplay().beep();
                        QuickSearch.this.showNotFoundMessage(status);
                    }
                }
            });
        }
    }

    private void activateContext(boolean activate) {
        IHandlerService handlerService = (IHandlerService)this.fWorkBenchWindow.getWorkbench().getService(IHandlerService.class);
        IContextService contextService = (IContextService)this.fWorkBenchWindow.getWorkbench().getService(IContextService.class);
        if (activate) {
            if (this.fContextActivation == null) {
                this.fContextActivation = contextService.activateContext(QUICK_SEARCH_CONTEXT, null, true);
            }
            if (this.fHandlerActivation == null) {
                this.fHandlerActivation = handlerService.activateHandler(QUICK_SEARCH_COMMAND_EXECUTE, this.fExecuteHandler);
            }
        } else {
            if (this.fContextActivation != null) {
                contextService.deactivateContext(this.fContextActivation);
                this.fContextActivation = null;
            }
            if (this.fHandlerActivation != null) {
                handlerService.deactivateHandler(this.fHandlerActivation);
                this.fHandlerActivation = null;
            }
        }
    }

    private void updateValidationStatus(IStatus status) {
        if (status.isOK()) {
            this.fControlDecoration.hide();
        } else {
            String fieldDecorationId = Utils.getDecorationId(status);
            FieldDecoration decoration = FieldDecorationRegistry.getDefault().getFieldDecoration(fieldDecorationId);
            this.fControlDecoration.setDescriptionText(status.getMessage());
            this.fControlDecoration.setImage(decoration.getImage());
            this.fControlDecoration.show();
        }
    }

    private class HideAction
    extends Action {
        public HideAction() {
            super(Messages.QuickSearch_HIDE);
        }

        public void run() {
            if (MessageDialog.openConfirm((Shell)QuickSearch.this.fWorkBenchWindow.getShell(), (String)Messages.QuickSearch_HIDE, (String)Messages.QuickSearch_CONFIRM)) {
                WorkItemRCPUIPlugin.getDefault().setQuickSearchTrimVisibilityPreference(false);
                WorkItemRCPUIPlugin.getDefault().setQuickSearchTrimVisibility(QuickSearch.this.fWorkBenchWindow, false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NotFoundStatus {
        NOT_FOUND,
        NO_PERMISSIONS,
        OK;

    }

    private abstract class QueryAction
    extends Action {
        private QueryAction() {
        }

        public abstract Expression getExpression() throws TeamRepositoryException;

        public void run() {
            QuickSearch.this.fCurrentAction = this;
            QuickSearch.this.updateTooltip();
        }

        protected IQueryableAttribute getWorkItemAttribute(String identifier) throws TeamRepositoryException {
            IProjectAreaHandle projectArea = QuickSearch.this.fProjectAreaSelectionAction.getProjectArea();
            if (projectArea != null) {
                IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IAuditableClient.class);
                return QueryableAttributes.getFactory((IItemType)IWorkItem.ITEM_TYPE).findAttribute(projectArea, identifier, (IAuditableCommon)auditableClient, null);
            }
            return null;
        }

        protected AttributeExpression getProjectAreaFilter() throws TeamRepositoryException {
            if (QuickSearch.this.fProjectAreaSelectionAction.getProjectArea() != null) {
                return new AttributeExpression(this.getWorkItemAttribute(IWorkItem.PROJECT_AREA_PROPERTY), AttributeOperation.EQUALS, (Object)QuickSearch.this.fProjectAreaSelectionAction.getProjectArea());
            }
            return null;
        }

        public int getStyle() {
            return 8;
        }

        public boolean isChecked() {
            return QuickSearch.this.fCurrentAction.equals((Object)this);
        }

        public boolean equals(Object obj) {
            return ((Object)((Object)this)).getClass().equals(obj.getClass());
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode();
        }
    }

    private class QueryAllAction
    extends QueryAction {
        private QueryAllAction() {
        }

        public Expression getExpression() throws TeamRepositoryException {
            return this.getProjectAreaFilter();
        }

        public ImageDescriptor getImageDescriptor() {
            return ImagePool.QUERY_ICON;
        }

        public String getText() {
            return Messages.QuickSearch_FILTER_ALL;
        }
    }

    private class QueryAllOpenAction
    extends QueryAction {
        private QueryAllOpenAction() {
        }

        public Expression getExpression() throws TeamRepositoryException {
            Expression stateFilter = this.getStateFilter();
            AttributeExpression projectAreaFilter = this.getProjectAreaFilter();
            if (projectAreaFilter != null && stateFilter != null) {
                return new Term(0, new Expression[]{projectAreaFilter, stateFilter});
            }
            return stateFilter;
        }

        private Expression getStateFilter() throws TeamRepositoryException {
            IQueryableAttribute stateAttribute = this.getWorkItemAttribute(IWorkItem.STATE_PROPERTY);
            if (stateAttribute != null) {
                return new VariableAttributeExpression(stateAttribute, AttributeOperation.EQUALS, (IAttributeVariable)new StatusVariable(5));
            }
            return null;
        }

        public ImageDescriptor getImageDescriptor() {
            return ImagePool.QUERY_ICON;
        }

        public String getText() {
            return Messages.QuickSearch_FILTER_ALL_OPEN;
        }
    }
}

