/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.queries;

import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.QueryableLinkAttribute;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerLabel;

public class QueryableAttributeLabelProvider
extends TypeLabelProvider {
    public static CellLabelProvider createCellLabelProvider() {
        return new QueryableAttributeCellLabelProvider();
    }

    public void updateLabel(ViewerLabel label, Object element) {
        IQueryableAttribute attribute = this.getQueryableAttribute(element);
        if (attribute != null) {
            label.setText(attribute.getDisplayName());
            label.setImage(this.getImage(this.getAttributeImageDescriptor(attribute)));
        }
    }

    public void updateCell(ViewerCell cell) {
        IQueryableAttribute attribute = this.getQueryableAttribute(cell.getElement());
        if (attribute != null) {
            cell.setText(attribute.getDisplayName());
            cell.setImage(this.getImage(this.getAttributeImageDescriptor(attribute)));
        }
    }

    protected IQueryableAttribute getQueryableAttribute(Object element) {
        if (element instanceof IQueryableAttribute) {
            return (IQueryableAttribute)element;
        }
        if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            return (IQueryableAttribute)adaptable.getAdapter(IQueryableAttribute.class);
        }
        return null;
    }

    protected ImageDescriptor getAttributeImageDescriptor(IQueryableAttribute attribute) {
        if ("all".equals(attribute.getIdentifier())) {
            return ImagePool.FULLTEXT_ATTRIBUTE_ICON;
        }
        if (attribute instanceof QueryableLinkAttribute) {
            return ImagePool.LINK_ATTRIBUTE_ICON;
        }
        if (attribute.isStateExtension()) {
            return ImagePool.CUSTOM_ATTRIBUTE_ICON;
        }
        return ImagePool.BUILT_IN_ATTRIBUTE_ICON;
    }

    private static class QueryableAttributeCellLabelProvider
    extends CellLabelProvider {
        private QueryableAttributeLabelProvider fLabelProvider = new QueryableAttributeLabelProvider();

        private QueryableAttributeCellLabelProvider() {
        }

        public void update(ViewerCell cell) {
            this.fLabelProvider.updateCell(cell);
        }

        public void dispose() {
            this.fLabelProvider.dispose();
            super.dispose();
        }
    }
}

