/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.queries;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.rcp.ui.LoginAction;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.rcp.ui.internal.navigator.QueriesContentProvider;
import com.ibm.team.workitem.rcp.ui.internal.navigator.QueryDomainLabelProvider;
import com.ibm.team.workitem.rcp.ui.internal.navigator.QueryDomainViewerSorter;
import com.ibm.team.workitem.rcp.ui.internal.queries.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerySelectionDialog
extends ElementTreeSelectionDialog {
    private static final IStatus INVALID_SELECTION_STATUS = new Status(4, "com.ibm.team.workitem.rcp.ui", null, null);
    private static final IStatus VALID_SELECTION_STATUS = new Status(0, "com.ibm.team.workitem.rcp.ui", null, null);
    private ViewerFilter fFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (QuerySelectionDialog.this.fFiltered != null && element instanceof IQueryDescriptorHandle) {
                return !QuerySelectionDialog.this.fFiltered.contains(element);
            }
            return true;
        }
    };
    private ItemHandleAwareHashSet<IQueryDescriptorHandle> fFiltered;

    private QuerySelectionDialog(Shell parent, ILabelProvider labelProvider, QueriesContentProvider contentProvider) {
        super(parent, labelProvider, (ITreeContentProvider)contentProvider);
    }

    public QuerySelectionDialog(Shell parent) {
        this(parent, (ILabelProvider)new QueryDomainLabelProvider(), new QueriesContentProvider((IConnectedProjectAreaRegistry)ConnectedProjectAreaRegistry.getDefault(), false, true));
        this.setMessage(Messages.QuerySelectionDialog_AVAILABLE_QUERIES_MESSAGE);
        this.setStatusLineAboveButtons(false);
        this.configureProjectAreas(ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(null));
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (QuerySelectionDialog.this.getSelectedQueries().isEmpty()) {
                    return INVALID_SELECTION_STATUS;
                }
                return VALID_SELECTION_STATUS;
            }
        });
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer viewer = super.createTreeViewer(parent);
        viewer.setSorter((ViewerSorter)new QueryDomainViewerSorter());
        viewer.addFilter(this.fFilter);
        viewer.expandToLevel(3);
        this.installContextMenu(viewer);
        return viewer;
    }

    private void installContextMenu(TreeViewer viewer) {
        final LoginAction loginAction = new LoginAction((IStructuredSelection)StructuredSelection.EMPTY);
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.add((IAction)loginAction);
        Menu menu = menuManager.createContextMenu((Control)viewer.getTree());
        viewer.getTree().setMenu(menu);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IProjectAreaHandle projectArea = QuerySelectionDialog.this.getProjectArea(event.getSelection());
                if (projectArea != null) {
                    loginAction.selectionChanged((IAction)loginAction, (ISelection)new StructuredSelection(projectArea.getOrigin()));
                } else {
                    loginAction.selectionChanged((IAction)loginAction, (ISelection)StructuredSelection.EMPTY);
                }
            }
        });
    }

    private IProjectAreaHandle getProjectArea(ISelection selection) {
        IStructuredSelection structuredSelection;
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && structuredSelection.getFirstElement() instanceof IProjectAreaHandle) {
            return (IProjectAreaHandle)structuredSelection.getFirstElement();
        }
        return null;
    }

    public void configureProjectAreas(Collection<IProjectAreaHandle> projectAreas) {
        IProjectAreaHandle[] projectAreaArray = projectAreas.toArray(new IProjectAreaHandle[projectAreas.size()]);
        HashSet<ITeamRepository> repos = new HashSet<ITeamRepository>();
        IProjectAreaHandle[] iProjectAreaHandleArray = projectAreaArray;
        int n = projectAreaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectAreaHandle projectAreaHandle = iProjectAreaHandleArray[n2];
            repos.add((ITeamRepository)projectAreaHandle.getOrigin());
            ++n2;
        }
        this.setInput(projectAreaArray);
    }

    public Object[] getResult() {
        return this.getSelectedQueries().toArray();
    }

    public List<IQueryDescriptorHandle> getSelectedQueries() {
        Object[] rawResult = super.getResult();
        ArrayList<IQueryDescriptorHandle> finalResults = new ArrayList<IQueryDescriptorHandle>(rawResult.length);
        int i = 0;
        while (i < rawResult.length) {
            if (rawResult[i] instanceof IQueryDescriptorHandle) {
                finalResults.add((IQueryDescriptorHandle)rawResult[i]);
            }
            ++i;
        }
        return finalResults;
    }

    protected IStatus handleTeamException(String message, TeamRepositoryException e) {
        Status status = new Status(4, "com.ibm.team.workitem.rcp.ui", 4, message, (Throwable)e);
        this.updateStatus((IStatus)status);
        return status;
    }

    public void setFilteredQueries(List<? extends IQueryDescriptorHandle> queries) {
        this.fFiltered = new ItemHandleAwareHashSet();
        this.fFiltered.addAll(queries);
    }
}

