/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.queries;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.ClientEvaluationContext;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.ExpressionVisitor;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.ProgressExpressionVisitor;
import com.ibm.team.workitem.common.expression.SimilarityExpression;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.expression.VariableAttributeExpression;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.internal.query.util.ExpressionResolver;
import com.ibm.team.workitem.common.internal.util.QueryableAttributePath;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeLabelProviderFactory;
import com.ibm.team.workitem.rcp.ui.internal.attribute.IAttributeLabelProvider;
import com.ibm.team.workitem.rcp.ui.internal.queries.Messages;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class ExpressionDescriptionGenerator {
    private final IProjectAreaHandle fProjectArea;
    private final Expression fExpression;
    private ExpressionResolver fResolver;
    private String fDescription;

    public ExpressionDescriptionGenerator(IProjectAreaHandle projectArea, Expression expression) {
        Assert.isNotNull((Object)projectArea);
        Assert.isNotNull((Object)expression);
        this.fProjectArea = projectArea;
        this.fExpression = expression;
    }

    public void resolve(IProgressMonitor monitor) throws TeamRepositoryException {
        ExpressionResolver resolver = new ExpressionResolver((IEvaluationContext)new ClientEvaluationContext(this.fProjectArea));
        this.fExpression.accept((ProgressExpressionVisitor)resolver, monitor);
        this.fResolver = resolver;
    }

    public boolean isResolved() {
        return this.fResolver != null;
    }

    public String getDescription() {
        if (this.fDescription == null) {
            Assert.isNotNull((Object)this.fResolver);
            ExpressionDescriptionVisitor visitor = new ExpressionDescriptionVisitor(this.fResolver);
            this.fExpression.accept((ExpressionVisitor)visitor);
            this.fDescription = visitor.getDescription();
        }
        return this.fDescription;
    }

    public static class ExpressionDescriptionVisitor
    extends ExpressionVisitor {
        private static final String PATTERN_UNARY_EXPRESSION = Messages.ExpressionDescriptionGenerator_PATTERN_UNARY_EXPRESSION;
        private static final String PATTERN_BINARY_EXPRESSION = Messages.ExpressionDescriptionGenerator_PATTERN_BINARY_EXPRESSION;
        private static final String PATTERN_AND = Messages.ExpressionDescriptionGenerator_PATTERN_AND;
        private static final String PATTERN_OR = Messages.ExpressionDescriptionGenerator_PATTERN_OR;
        private static final String PATTERN_BRACKETS = Messages.ExpressionDescriptionGenerator_PATTERN_BRACKETS;
        private final ExpressionResolver fResolver;
        private String fExpressionString;

        public ExpressionDescriptionVisitor(ExpressionResolver resolver) {
            this.fResolver = resolver;
        }

        public boolean visit(AttributeExpression expression) {
            this.handleAttributeExpression(expression);
            return super.visit(expression);
        }

        public boolean visit(VariableAttributeExpression expression) {
            this.handleAttributeExpression((AttributeExpression)expression);
            return super.visit(expression);
        }

        private void handleAttributeExpression(AttributeExpression expression) {
            IQueryableAttribute attribute = this.fResolver.getAttribute(expression.getAttributeIdentifier());
            this.fExpressionString = expression.getOperation().isUnary() ? NLS.bind((String)PATTERN_UNARY_EXPRESSION, (Object)this.getDisplayName(attribute), (Object[])new Object[]{expression.getOperation().getDisplayName()}) : NLS.bind((String)PATTERN_BINARY_EXPRESSION, (Object)this.getDisplayName(attribute), (Object[])new Object[]{expression.getOperation().getDisplayName(), this.getLabel(expression)});
        }

        public boolean visit(Term term) {
            if (!term.isInternal()) {
                String termPattern = term.getOperator() == Term.Operator.AND ? PATTERN_AND : PATTERN_OR;
                String termString = null;
                if (this.isMultiValueTerm(term)) {
                    String valueString = null;
                    for (AttributeExpression aex : term.getExpressions()) {
                        valueString = valueString == null ? this.getLabel(aex) : NLS.bind((String)termPattern, (Object)valueString, (Object[])new Object[]{this.getLabel(aex)});
                    }
                    AttributeExpression aex = (AttributeExpression)term.getExpressions().get(0);
                    IQueryableAttribute attribute = this.fResolver.getAttribute(aex.getAttributeIdentifier());
                    termString = NLS.bind((String)PATTERN_BINARY_EXPRESSION, (Object)this.getDisplayName(attribute), (Object[])new Object[]{aex.getOperation().getDisplayName(), valueString});
                } else {
                    Iterator iterator = term.getExpressions().iterator();
                    while (iterator.hasNext()) {
                        ((Expression)iterator.next()).accept((ExpressionVisitor)this);
                        termString = termString == null ? this.fExpressionString : NLS.bind((String)termPattern, (Object)termString, (Object[])new Object[]{this.fExpressionString});
                    }
                }
                this.fExpressionString = this.getCount(term) > 1 ? NLS.bind((String)PATTERN_BRACKETS, (Object)termString, (Object[])new Object[0]) : termString;
            }
            return false;
        }

        private boolean isMultiValueTerm(Term term) {
            if (this.getCount(term) <= 1) {
                return false;
            }
            AttributeExpression master = null;
            for (Expression expression : term.getExpressions()) {
                if (expression instanceof AttributeExpression) {
                    AttributeExpression aex = (AttributeExpression)expression;
                    if (master == null) {
                        master = aex;
                    }
                    if (aex.getOperation() != master.getOperation()) {
                        return false;
                    }
                    if (aex.getAttributeIdentifier().equals(master.getAttributeIdentifier())) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        protected void clearDescription() {
            this.fExpressionString = null;
        }

        public boolean visit(SimilarityExpression similarityExpression) {
            String summary = similarityExpression.getSummary();
            this.fExpressionString = NLS.bind((String)Messages.ExpressionDescriptionGenerator_PATTERN_SIMILAR, (Object)summary, (Object[])new Object[0]);
            return super.visit(similarityExpression);
        }

        public String getDescription() {
            String description;
            String string = description = this.fExpressionString == null ? "" : this.fExpressionString.trim();
            if ("".equals(description)) {
                description = Messages.ExpressionDescriptionGenerator_ALL_WORKITEMS;
            }
            return description;
        }

        private String getDisplayName(IQueryableAttribute attribute) {
            return QueryableAttributePath.createPathLabel((IQueryableAttribute)attribute, (String)Messages.ExpressionDescriptionGenerator_ATTRIBUTE_PATH_SEPARATOR);
        }

        private int getCount(Term term) {
            int count = term.getExpressions().size();
            for (Expression expression : term.getExpressions()) {
                if (!(expression instanceof Term) || !((Term)expression).isInternal()) continue;
                --count;
            }
            return count;
        }

        private String getLabel(AttributeExpression aex) {
            if (aex instanceof VariableAttributeExpression) {
                VariableAttributeExpression vaex = (VariableAttributeExpression)aex;
                return vaex.getVariable().getDisplayName();
            }
            IAttributeLabelProvider labelProvider = null;
            IQueryableAttribute attribute = this.fResolver.getAttribute(aex.getAttributeIdentifier());
            try {
                labelProvider = AttributeLabelProviderFactory.createLabelProvider(attribute, false);
                String string = labelProvider.getText(aex.getValue());
                return string;
            }
            finally {
                if (labelProvider != null) {
                    labelProvider.dispose();
                }
            }
        }
    }
}

