/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.preview;

import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.preview.HTMLGenerator;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.ClientEvaluationContext;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.ExpressionVisitor;
import com.ibm.team.workitem.common.expression.ProgressExpressionVisitor;
import com.ibm.team.workitem.common.expression.SortCriteria;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.expression.VariableAttributeExpression;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.internal.query.util.ExpressionResolver;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.common.query.IQueryResult;
import com.ibm.team.workitem.common.query.IResolvedResult;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.rcp.core.queries.Query;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.preview.Messages;
import com.ibm.team.workitem.rcp.ui.internal.queries.ExpressionDescriptionGenerator;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.FontData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryHTMLGenerator
extends HTMLGenerator {
    private static final String GENERAL_CSS = "GENERAL_QUERY_CSS";
    private static final int MAX_RESULT_COUNT = 10;
    private Query fQuery;
    private IQueryDescriptorHandle fQueryDescriptorHandle;
    private IQueryDescriptor fQueryDescriptor;
    private IQueryResult<IResolvedResult<IWorkItem>> fQueryResult;

    public QueryHTMLGenerator(Query query) {
        this.fQuery = query;
    }

    public QueryHTMLGenerator(IQueryDescriptorHandle queryDescriptorHandle) {
        this.fQueryDescriptorHandle = queryDescriptorHandle;
    }

    protected void createControl(HTMLGenerator.Composite composite) {
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (!this.getTeamRepository().loggedIn()) {
                this.createLabel(composite, Messages.QueryHTMLGenerator_LOGGED_OUT_MESSAGE);
            } else if (this.getInfo().isHoverTooltip) {
                this.createTeaserHTML(composite, (IProgressMonitor)monitor);
                if (this.fQuery != null) {
                    this.createResultsHTMLInNewSection(composite, (IProgressMonitor)monitor);
                } else {
                    this.createQueryHTML(composite, (IProgressMonitor)monitor);
                }
            } else if (this.getInfo().isEmbeddeble) {
                this.createEmbeddableHTML(composite);
            } else {
                this.createTeaserHTML(composite, (IProgressMonitor)monitor);
                this.createResultsHTMLInNewSection(composite, (IProgressMonitor)monitor);
                if (this.fQuery == null) {
                    this.createQueryHTML(composite, (IProgressMonitor)monitor);
                }
            }
        }
        catch (PermissionDeniedException permissionDeniedException) {
            this.createLabel(composite, Messages.QueryHTMLGenerator_PERMISSION_DENIED);
        }
        catch (TeamRepositoryException e) {
            this.log(e);
            this.createLabel(composite, Messages.QueryHTMLGenerator_COULD_NOT_CREATE_HOVER);
        }
    }

    protected void createQueryHTML(HTMLGenerator.Composite composite, IProgressMonitor monitor) throws TeamRepositoryException {
        HTMLGenerator.Section conditions = new HTMLGenerator.Section((HTMLGenerator)this, composite, (HTMLGenerator.Control)this.createLabel(null, Messages.QueryHTMLGenerator_CONDITIONS));
        this.createExpressionHTML((HTMLGenerator.Composite)conditions, monitor);
        HTMLGenerator.Section order = new HTMLGenerator.Section((HTMLGenerator)this, composite, (HTMLGenerator.Control)this.createLabel(null, Messages.QueryHTMLGenerator_ORDER));
        this.createOrderHTML(order, monitor);
    }

    protected void createResultsHTMLInNewSection(HTMLGenerator.Composite composite, IProgressMonitor monitor) throws TeamRepositoryException {
        HTMLGenerator.Section results = new HTMLGenerator.Section((HTMLGenerator)this, composite, (HTMLGenerator.Control)this.createLabel(null, this.getResultSectionName(monitor)));
        this.createResultsHTML((HTMLGenerator.Composite)results, monitor);
    }

    protected void createResultsHTML(HTMLGenerator.Composite composite, IProgressMonitor monitor) throws TeamRepositoryException {
        int columns = this.getProjectArea(monitor) != null ? 2 : 1;
        CustomTable table = this.createResultsTable(composite, columns);
        IQueryResult<IResolvedResult<IWorkItem>> resultSet = this.getQueryResult(monitor);
        List page = resultSet.nextPage(null);
        for (IResolvedResult result : page) {
            IWorkItem workItem = (IWorkItem)result.getItem();
            URI itemUri = Location.itemLocation((IItemHandle)workItem, (String)this.getTeamRepository().getRepositoryURI()).toAbsoluteUri();
            if (columns > 1) {
                URL imageUrl = WorkItemUI.createImageURL(this.resolveWorkItemType(workItem, monitor));
                this.createLabel(table, "").setImage(JazzResources.getConformingURL((URL)imageUrl));
            }
            HTMLGenerator.Link link = new HTMLGenerator.Link((HTMLGenerator)this, (HTMLGenerator.Composite)table, itemUri.toString());
            this.createLabel((HTMLGenerator.Composite)link, WorkItemTextUtilities.getWorkItemText((IWorkItem)workItem));
        }
    }

    protected void createExpressionHTML(HTMLGenerator.Composite composite, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectAreaHandle projectArea = this.getProjectArea(monitor);
        if (projectArea == null) {
            return;
        }
        final Expression expression = QueryUtils.removeRestrictions((Expression)this.getExpression(monitor));
        if (expression == null) {
            this.createLabel(composite, Messages.QueryHTMLGenerator_ALL_WORK_ITEMS);
            return;
        }
        ExpressionResolver resolver = new ExpressionResolver((IEvaluationContext)new ClientEvaluationContext(projectArea));
        expression.accept((ProgressExpressionVisitor)resolver, monitor);
        final ExpressionHTMLGenerator htmlGenerator = new ExpressionHTMLGenerator(composite, resolver);
        FoundationUIJob job = new FoundationUIJob(Messages.QueryHTMLGenerator_JOB_NAME_CREATE_HTML){

            public IStatus runProtectedInUI(IProgressMonitor monitor) {
                expression.accept((ExpressionVisitor)htmlGenerator);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        try {
            job.schedule();
            job.join();
        }
        catch (InterruptedException interruptedException) {
            this.createLabel(composite, Messages.QueryHTMLGenerator_HOVER_CREATION_INTERRUPTED);
        }
    }

    protected void createTeaserHTML(HTMLGenerator.Composite composite, IProgressMonitor monitor) throws TeamRepositoryException {
        this.createLabel(composite, this.getName(monitor)).setCSSClass("name");
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        String description = this.getDescription(monitor);
        if (description.length() > 0) {
            this.createLabel(composite, this.getDescription(monitor));
            new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        }
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
    }

    protected void createOrderHTML(HTMLGenerator.Section composite, IProgressMonitor monitor) throws TeamRepositoryException {
        List sortCriteria = QueryUtils.getSortCriteria((Expression)this.getExpression(monitor));
        if (sortCriteria.isEmpty()) {
            this.createLabel((HTMLGenerator.Composite)composite, Messages.QueryHTMLGenerator_DEFAULT);
            return;
        }
        ClientEvaluationContext context = new ClientEvaluationContext(this.getProjectArea(monitor));
        String label = "";
        int i = 0;
        while (i < sortCriteria.size()) {
            SortCriteria criteria = (SortCriteria)sortCriteria.get(i);
            String displayName = criteria.getAttribute((IEvaluationContext)context, null).getDisplayName();
            String order = NLS.bind((String)(criteria.isAscending() ? Messages.QueryHTMLGenerator_PATTERN_ASCENDING : Messages.QueryHTMLGenerator_PATTERN_DESCENDING), (Object)displayName, (Object[])new Object[0]);
            label = label.length() == 0 ? order : NLS.bind((String)Messages.QueryHTMLGenerator_SORT_ORDER_LIST, (Object)label, (Object[])new Object[]{order});
            ++i;
        }
        this.createLabel((HTMLGenerator.Composite)composite, label);
    }

    protected void createEmbeddableHTML(HTMLGenerator.Composite composite) {
    }

    private CustomTable createDetailsTable(HTMLGenerator.Composite parent, int columns) {
        CustomTable table = new CustomTable(parent, columns);
        table.setCSSClass("details");
        table.setFirstRowCSSClass("first");
        return table;
    }

    private CustomTable createResultsTable(HTMLGenerator.Composite parent, int columns) {
        CustomTable table = new CustomTable(parent, columns);
        table.setCSSClass("results");
        table.setFirstRowCSSClass("first");
        return table;
    }

    private IQueryResult<IResolvedResult<IWorkItem>> getQueryResult(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fQueryResult == null) {
            SortCriteria modifiedDesc = new SortCriteria(IWorkItem.MODIFIED_PROPERTY, false);
            Expression recentlyModified = QueryUtils.createSortedStatement((Expression)this.getExpression(monitor), (SortCriteria[])new SortCriteria[]{modifiedDesc});
            IQueryClient queryClient = this.getClient(IQueryClient.class);
            this.fQueryResult = queryClient.getResolvedExpressionResults(this.getProjectArea(monitor), recentlyModified, IWorkItem.SMALL_PROFILE);
            this.fQueryResult.setPageSize(10);
        }
        return this.fQueryResult;
    }

    private String getResultSectionName(IProgressMonitor monitor) throws TeamRepositoryException {
        IQueryResult<IResolvedResult<IWorkItem>> result = this.getQueryResult(monitor);
        int total = result.getResultSize(null).getTotal();
        int count = Math.min(10, total);
        return NLS.bind((String)Messages.QueryHTMLGenerator_PATTERN_RESULTS, (Object)count, (Object[])new Object[]{total});
    }

    private String getName(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fQuery != null) {
            return this.fQuery.getName();
        }
        return this.getQueryDescriptor(monitor).getName();
    }

    private String getDescription(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fQuery != null) {
            return "";
        }
        return this.getQueryDescriptor(monitor).getDescription();
    }

    private Expression getExpression(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fQuery != null) {
            return this.fQuery.getExpression();
        }
        return this.getQueryDescriptor(monitor).getExpression();
    }

    private IProjectAreaHandle getProjectArea(IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectAreaHandle projectArea;
        if (this.fQuery != null && (projectArea = QueryUtils.getProjectArea((Expression)this.fQuery.getExpression())) != null) {
            return projectArea;
        }
        IQueryDescriptor descriptor = this.getQueryDescriptor(monitor);
        return descriptor != null ? descriptor.getProjectArea() : null;
    }

    private IQueryDescriptor getQueryDescriptor(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fQueryDescriptor == null && this.fQueryDescriptorHandle != null) {
            IAuditableClient auditableClient = this.getClient(IAuditableClient.class);
            this.fQueryDescriptor = (IQueryDescriptor)auditableClient.resolveAuditable((IAuditableHandle)this.fQueryDescriptorHandle, IQueryDescriptor.FULL_PROFILE, monitor);
        }
        return this.fQueryDescriptor;
    }

    private IWorkItemType resolveWorkItemType(IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemClient workItemClient = this.getClient(IWorkItemClient.class);
        return workItemClient.findWorkItemType(this.getProjectArea(monitor), workItem.getWorkItemType(), monitor);
    }

    private <T> T getClient(Class<T> clazz) {
        return (T)this.getTeamRepository().getClientLibrary(clazz);
    }

    private ITeamRepository getTeamRepository() {
        return this.fQuery != null ? this.fQuery.getTeamRepository() : this.fQueryDescriptorHandle.getOrigin();
    }

    protected void generateHead(HashMap map) {
        if (map.containsKey(GENERAL_CSS)) {
            return;
        }
        StringBuffer css = new StringBuffer();
        FontData font = JFaceResources.getDefaultFont().getFontData()[0];
        css.append("<style type=\"text/css\">");
        css.append("body { overflow: auto; padding:3px;}\n");
        css.append(".{ ").append(MarkupUtil.getGlobalFont()).append(" }\n");
        css.append(".bold { font-weight: bold; color: #666666}\n");
        css.append("table.details { empty-cells:hide; border: 1px solid #E5E5E5; ").append(MarkupUtil.getDefaultFont()).append(" }\n");
        css.append("table.results { empty-cells:hide; width:95%;").append(MarkupUtil.getDefaultFont()).append(" }\n");
        css.append("td { border-top: 1px solid #CCCCCC; vertical-align: top; }\n");
        css.append("tr.first td { border-top: 0px; }\n");
        css.append("span.name { ").append(MarkupUtil.getFont((String)font.getName(), (int)(font.getHeight() + 2), (int)1)).append("}\n");
        if (this.getInfo().isHoverTooltip) {
            css.append("a:link { text-decoration: none; color: black; }\n");
        } else {
            css.append("a:link { color: #0000FF; text-decoration: none; }");
        }
        if (this.getInfo().isHoverTooltip) {
            css.append("a:visited { color: black; text-decoration: none; }\n");
        } else {
            css.append("a:visited { color: #0000FF; text-decoration: none; }\n");
        }
        css.append("a:hover { color: #000080; text-decoration: underline; }");
        css.append("</style>");
        map.put(GENERAL_CSS, css.toString());
    }

    private void log(TeamRepositoryException e) {
        WorkItemRCPUIPlugin.getDefault().log("Exception while creating hover", e);
    }

    private HTMLGenerator.Label createLabel(HTMLGenerator.Composite composite, String text) {
        if (text.length() > 0) {
            return new HTMLGenerator.Label((HTMLGenerator)this, composite, Utils.escapeToHTML(text));
        }
        return new HTMLGenerator.Label((HTMLGenerator)this, composite, text);
    }

    protected class CustomTable
    extends HTMLGenerator.Composite {
        private int fColumns;
        private String fFirstRowCss;

        public CustomTable(HTMLGenerator.Composite parent, int columns) {
            super((HTMLGenerator)QueryHTMLGenerator.this, parent);
            this.fColumns = columns;
        }

        public void setFirstRowCSSClass(String clazz) {
            this.fFirstRowCss = clazz;
        }

        public void appendTo(StringBuffer buffer) {
            int row = 0;
            int column = 0;
            buffer.append("<table");
            if (this.getCSSClass() != null) {
                buffer.append(" class=\"");
                buffer.append(this.getCSSClass());
                buffer.append("\"");
            }
            buffer.append(">");
            HTMLGenerator.Control[] components = this.getComponents();
            int i = 0;
            while (i < components.length) {
                HTMLGenerator.Control control = components[i];
                if (column == 0) {
                    buffer.append("\n  <tr");
                    if (row == 0 && this.fFirstRowCss != null) {
                        buffer.append(" class=\"");
                        buffer.append(this.fFirstRowCss);
                        buffer.append("\"");
                    }
                    buffer.append(">");
                }
                buffer.append("\n    <td>");
                control.appendTo(buffer);
                buffer.append("</td>");
                if (++column >= this.fColumns) {
                    buffer.append("\n  </tr>");
                    column = 0;
                    ++row;
                }
                ++i;
            }
            buffer.append("\n</table>");
        }
    }

    private class ExpressionHTMLGenerator
    extends ExpressionDescriptionGenerator.ExpressionDescriptionVisitor {
        private HTMLGenerator.Composite fComposite;

        public ExpressionHTMLGenerator(HTMLGenerator.Composite composite, ExpressionResolver resolver) {
            super(resolver);
            this.fComposite = composite;
        }

        public boolean visit(AttributeExpression expression) {
            this.clearDescription();
            super.visit(expression);
            this.createDescription();
            return true;
        }

        public boolean visit(Term term) {
            List expressions = term.getExpressions();
            if (expressions.size() == 1) {
                ((Expression)expressions.get(0)).accept((ExpressionVisitor)this);
                return false;
            }
            HTMLGenerator.Composite previous = this.fComposite;
            this.fComposite = QueryHTMLGenerator.this.createDetailsTable(this.fComposite, 2);
            QueryHTMLGenerator.this.createLabel(this.fComposite, term.getOperator().getLabel()).setCSSClass("bold");
            int i = 0;
            while (i < expressions.size()) {
                if (i > 0) {
                    this.createEmptyCell(this.fComposite);
                }
                ((Expression)expressions.get(i)).accept((ExpressionVisitor)this);
                ++i;
            }
            this.fComposite = previous;
            return false;
        }

        public boolean visit(VariableAttributeExpression expression) {
            this.clearDescription();
            super.visit(expression);
            this.createDescription();
            return true;
        }

        private void createDescription() {
            QueryHTMLGenerator.this.createLabel(this.fComposite, this.getDescription());
        }

        private void createEmptyCell(HTMLGenerator.Composite parent) {
            if (parent == null) {
                return;
            }
            QueryHTMLGenerator.this.createLabel(parent, "");
        }
    }
}

