/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.preview;

import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.model.IDeliverable;
import com.ibm.team.workitem.common.model.IDeliverableHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.preview.DeliverableHTMLGenerator;
import com.ibm.team.workitem.rcp.ui.internal.preview.Messages;
import com.ibm.team.workitem.rcp.ui.internal.preview.ResolveDomainAdapter;
import java.util.HashMap;

public class DeliverableDomainAdapter
extends ResolveDomainAdapter {
    public String generateContentAsText(Object input) {
        try {
            input = this.resolve(input, IDeliverable.SMALL_PROFILE);
        }
        catch (PermissionDeniedException permissionDeniedException) {
            return this.permissionDenied();
        }
        if (input instanceof IDeliverable) {
            return this.resolveName((IDeliverable)input);
        }
        return "";
    }

    public String generateTitle(Object input) {
        try {
            input = this.resolve(input, IDeliverable.SMALL_PROFILE);
        }
        catch (PermissionDeniedException permissionDeniedException) {
            return this.permissionDenied();
        }
        if (input instanceof IDeliverable) {
            return this.resolveName((IDeliverable)input);
        }
        return "";
    }

    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info) {
        if (input instanceof IDeliverableHandle) {
            new DeliverableHTMLGenerator((IDeliverableHandle)input).generate(head, body, info);
        }
    }

    public String generateJobInfo(Object input, IDomainAdapter.Info info) {
        return Messages.DeliverableDomainAdapter_RESOLVING_RELEASE;
    }

    private Object resolve(Object input, ItemProfile itemProfile) throws PermissionDeniedException {
        if (input instanceof IDeliverableHandle) {
            IDeliverableHandle ah = (IDeliverableHandle)input;
            try {
                ITeamRepository teamRepository = (ITeamRepository)ah.getOrigin();
                if (teamRepository != null) {
                    IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                    input = auditableClient.resolveAuditable((IAuditableHandle)ah, itemProfile, null);
                }
            }
            catch (PermissionDeniedException x) {
                throw x;
            }
            catch (TeamRepositoryException x) {
                WorkItemRCPUIPlugin.getDefault().log(Messages.DeliverableHTMLGenerator_EXCEPTION_RESOLVING_RELEASE, x);
            }
        }
        return input;
    }

    private String resolveName(IDeliverable deliverable) {
        if (!deliverable.isPropertySet(IDeliverable.NAME_PROPERTY)) {
            try {
                ITeamRepository teamRepository = (ITeamRepository)deliverable.getOrigin();
                IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                deliverable = (IDeliverable)auditableClient.resolveAuditable((IAuditableHandle)deliverable, IDeliverable.SMALL_PROFILE, null);
            }
            catch (TeamRepositoryException x) {
                WorkItemRCPUIPlugin.getDefault().log(Messages.DeliverableHTMLGenerator_EXCEPTION_RESOLVING_RELEASE, x);
                return "";
            }
        }
        return deliverable.getName();
    }
}

