/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.preview;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.preview.HTMLGenerator;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.preview.Messages;
import java.util.HashMap;

public class CategoryHTMLGenerator
extends HTMLGenerator {
    private static final String CSS_KEY = "GENERAL_CATEGORY_CSS";
    private ICategoryHandle fCategoryHandle;

    public CategoryHTMLGenerator(ICategoryHandle category) {
        this.fCategoryHandle = category;
    }

    protected void createControl(HTMLGenerator.Composite composite) {
        try {
            ITeamRepository teamRepository = (ITeamRepository)this.fCategoryHandle.getOrigin();
            IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
            IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
            ICategory category = (ICategory)auditableClient.resolveAuditable((IAuditableHandle)this.fCategoryHandle, ICategory.FULL_PROFILE, null);
            String hierarchicalName = workItemClient.resolveHierarchicalName((ICategoryHandle)category, null);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, XMLString.createFromPlainText((String)hierarchicalName)).setFont(null, -1, false, true);
            new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
            String description = category.getHTMLDescription().getPlainText();
            String text = description == null || description.length() == 0 ? Messages.CategoryHTMLGenerator_NO_DESCRIPTION : NLS.bind((String)Messages.CategoryHTMLGenerator_DESCRIPTION, (Object)description, (Object[])new Object[0]);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, XMLString.createFromPlainText((String)text).getXMLText());
        }
        catch (PermissionDeniedException permissionDeniedException) {
            new HTMLGenerator.Label((HTMLGenerator)this, composite, XMLString.createFromPlainText((String)Messages.CategoryHTMLGenerator_PERMISSION_DENIED));
        }
        catch (TeamRepositoryException e) {
            WorkItemRCPUIPlugin.getDefault().log(Messages.CategoryHTMLGenerator_EXCEPTION_RESOLVING_CATEGORY, e);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, XMLString.createFromPlainText((String)Messages.CategoryHTMLGenerator_EXCEPTION_RESOLVING_CATEGORY));
        }
    }

    protected void generateHead(HashMap map) {
        if (!map.containsKey(CSS_KEY)) {
            StringBuffer css = new StringBuffer();
            css.append("<style type=\"text/css\">");
            css.append("body { overflow: auto; ").append(MarkupUtil.getFont()).append(" }");
            css.append("</style>");
            map.put(CSS_KEY, css.toString());
        }
    }
}

