/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.navigator;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistry;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.query.IAssociation;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.rcp.ui.internal.navigator.AbstractQueryFolder;
import com.ibm.team.workitem.rcp.ui.internal.navigator.IndividuallySharedQueryFolder;
import com.ibm.team.workitem.rcp.ui.internal.navigator.ProjectAreaQueryFolder;
import com.ibm.team.workitem.rcp.ui.internal.navigator.TeamAreaQueryFolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedQueryFolder
extends AbstractQueryFolder {
    private IConnectedProjectAreaRegistry fConnectedProjectAreaRegistry;
    private boolean fLimitScopeToTeamAreas;

    public SharedQueryFolder(IProjectAreaHandle projectAreaHandle, IConnectedProjectAreaRegistry connectedProjectAreaRegistry, boolean limitScopeToTeamAreas) {
        super(projectAreaHandle);
        this.fConnectedProjectAreaRegistry = connectedProjectAreaRegistry;
        this.fLimitScopeToTeamAreas = limitScopeToTeamAreas;
    }

    public List<Object> fetchFolderContents(IProgressMonitor monitor) throws TeamRepositoryException {
        IQueryClient queryClient = this.getClientLibrary(IQueryClient.class);
        List teamAreas = this.fConnectedProjectAreaRegistry.getSelectedTeamAreas(this.getProjectAreaHandle());
        List result = queryClient.findSharedQueries(this.getProjectAreaHandle(), teamAreas, "com.ibm.team.workitem.workItemType", IQueryDescriptor.FULL_PROFILE, monitor);
        return this.createSubtree(result, monitor, teamAreas);
    }

    private List<Object> createSubtree(List<IQueryDescriptor> result, IProgressMonitor monitor, List teamAreas) throws TeamRepositoryException {
        ArrayList<Object> list = new ArrayList<Object>(result.size());
        if (this.fLimitScopeToTeamAreas) {
            list.addAll(result);
        } else {
            this.addContainers(result, list, monitor, teamAreas);
        }
        return list;
    }

    private void addContainers(List<IQueryDescriptor> result, List<Object> collector, IProgressMonitor monitor, List limitingTeamAreas) throws TeamRepositoryException {
        IProjectArea projectArea = this.resolveProjectArea(monitor);
        collector.add(new ProjectAreaQueryFolder(projectArea));
        collector.add(new IndividuallySharedQueryFolder(this.getProjectAreaHandle()));
        ItemHandleAwareHashSet set = new ItemHandleAwareHashSet();
        for (IQueryDescriptor descriptor : result) {
            List associations = descriptor.getAssociations().filterTargets(ITeamAreaHandle.class);
            for (IAssociation association : associations) {
                set.add((Object)association.getTarget());
            }
        }
        IAuditableClient auditableClient = this.getClientLibrary(IAuditableClient.class);
        List teamAreas = auditableClient.resolveAuditablesPermissionAware(new ArrayList(set), ItemProfile.TEAM_AREA_DEFAULT, monitor);
        ItemHandleAwareHashSet limitingTeamAreasCasted = new ItemHandleAwareHashSet((Collection)limitingTeamAreas);
        ITeamAreaHierarchy teamAreaHierarchy = projectArea.getTeamAreaHierarchy();
        for (ITeamArea teamArea : teamAreas) {
            if (!limitingTeamAreasCasted.contains((Object)teamArea)) continue;
            IDevelopmentLineHandle devLineHandle = teamAreaHierarchy.getDevelopmentLine((ITeamAreaHandle)teamArea);
            IDevelopmentLine devLine = null;
            if (devLineHandle != null) {
                devLine = (IDevelopmentLine)auditableClient.resolveAuditable((IAuditableHandle)devLineHandle, ItemProfile.DEVELOPMENT_LINE_DEFAULT, monitor);
            }
            collector.add(new TeamAreaQueryFolder(projectArea, teamArea, devLine));
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SharedQueryFolder) {
            SharedQueryFolder other = (SharedQueryFolder)obj;
            return this.getProjectAreaHandle().sameItemId((IItemHandle)other.getProjectAreaHandle()) && this.fLimitScopeToTeamAreas == other.fLimitScopeToTeamAreas && this.fConnectedProjectAreaRegistry == other.fConnectedProjectAreaRegistry;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.getProjectAreaHandle().getItemId().hashCode();
    }

    private IProjectArea resolveProjectArea(IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)this.getProjectAreaHandle(), IAuditableClient.class);
        return (IProjectArea)auditableClient.resolveAuditable((IAuditableHandle)this.getProjectAreaHandle(), ItemProfile.PROJECT_AREA_DEFAULT, monitor);
    }
}

