/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.navigator;

import com.ibm.icu.text.Collator;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.rcp.ui.internal.navigator.IndividuallySharedQueryFolder;
import com.ibm.team.workitem.rcp.ui.internal.navigator.PersonalQueryFolder;
import com.ibm.team.workitem.rcp.ui.internal.navigator.ProjectAreaQueryFolder;
import com.ibm.team.workitem.rcp.ui.internal.navigator.SharedQueryFolder;
import com.ibm.team.workitem.rcp.ui.internal.navigator.TeamAreaQueryFolder;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class QueryDomainViewerSorter
extends ViewerSorter {
    private Collator fCollator = Collator.getInstance();
    private static Map<Class<?>, Integer> fgOrderMap = new HashMap();

    static {
        fgOrderMap.put(PendingUpdateAdapter.class, 0);
        fgOrderMap.put(IQueryDescriptor.class, 10);
        fgOrderMap.put(PersonalQueryFolder.class, 20);
        fgOrderMap.put(SharedQueryFolder.class, 30);
        fgOrderMap.put(ProjectAreaQueryFolder.class, 40);
        fgOrderMap.put(TeamAreaQueryFolder.class, 50);
        fgOrderMap.put(IndividuallySharedQueryFolder.class, 60);
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (e1.getClass().equals(e2.getClass())) {
            if (e1 instanceof IQueryDescriptor) {
                IQueryDescriptor qd1 = (IQueryDescriptor)e1;
                IQueryDescriptor qd2 = (IQueryDescriptor)e2;
                return this.fCollator.compare(qd1.getName(), qd2.getName());
            }
            if (e1 instanceof TeamAreaQueryFolder) {
                ITeamArea ta1 = ((TeamAreaQueryFolder)e1).getTeamArea();
                ITeamArea ta2 = ((TeamAreaQueryFolder)e2).getTeamArea();
                return this.fCollator.compare(ta1.getName(), ta2.getName());
            }
        }
        Integer order1 = fgOrderMap.get(e1.getClass());
        Integer order2 = fgOrderMap.get(e2.getClass());
        if (order1 == null) {
            return 1;
        }
        if (order2 == null) {
            return -1;
        }
        return order1.compareTo(order2);
    }
}

