/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.navigator;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.navigator.IndividuallySharedQueryFolder;
import com.ibm.team.workitem.rcp.ui.internal.navigator.Messages;
import com.ibm.team.workitem.rcp.ui.internal.navigator.PersonalQueryFolder;
import com.ibm.team.workitem.rcp.ui.internal.navigator.ProjectAreaQueryFolder;
import com.ibm.team.workitem.rcp.ui.internal.navigator.SharedQueryFolder;
import com.ibm.team.workitem.rcp.ui.internal.navigator.TeamAreaQueryFolder;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;

public class QueryDomainLabelProvider
extends LabelProvider
implements ITreePathLabelProvider {
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private StandardLabelProvider fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()){

        public void invokeDecorators(ViewerLabel label, Object element) {
            if (element instanceof ITeamAreaHandle) {
                String text = label.getText();
                super.invokeDecorators(label, element);
                label.setText(text);
                return;
            }
            super.invokeDecorators(label, element);
        }
    };

    public QueryDomainLabelProvider() {
        this.fStandardLabelProvider.addListener(new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                QueryDomainLabelProvider.this.fireLabelProviderChanged(event);
            }
        });
    }

    public Image getImage(Object element) {
        ViewerLabel label = new ViewerLabel("", null);
        this.updateLabel(label, new TreePath(new Object[]{element}));
        return label.getImage();
    }

    public String getText(Object element) {
        ViewerLabel label = new ViewerLabel("", null);
        this.updateLabel(label, new TreePath(new Object[]{element}));
        return label.getText();
    }

    public void updateLabel(ViewerLabel label, TreePath elementPath) {
        Object segment = elementPath.getLastSegment();
        if (segment instanceof SharedQueryFolder) {
            label.setText(Messages.QueryDomainLabelProvider_SHARED_QUERIES_LABEL);
            label.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.COLLECTION_ICON));
        } else if (segment instanceof PersonalQueryFolder) {
            label.setText(Messages.QueryDomainLabelProvider_MY_QUERIES_LABEL);
            label.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.COLLECTION_ICON));
        } else if (segment instanceof ProjectAreaQueryFolder) {
            label.setText(Messages.QueryDomainLabelProvider_PREDEFINED_QUERIES_LABEL);
            label.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.COLLECTION_ICON));
        } else if (segment instanceof TeamAreaQueryFolder) {
            TeamAreaQueryFolder folder = (TeamAreaQueryFolder)segment;
            this.fStandardLabelProvider.updateLabel(label, (Object)folder);
            IDevelopmentLine developmentLine = folder.getDevelopmentLine();
            if (developmentLine != null && folder.getProjectArea().getTeamAreaHierarchy().getParent((ITeamAreaHandle)folder.getTeamArea()) != null) {
                label.setText(NLS.bind((String)Messages.QueryDomainLabelProvider_DEV_LINE_DECORATION, (Object)label.getText(), (Object[])new Object[]{developmentLine.getLabel()}));
            }
        } else if (segment instanceof IndividuallySharedQueryFolder) {
            label.setText(Messages.QueryDomainLabelProvider_INDIVIDUALLY_SHARED_QUERIES_LABEL);
            label.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.COLLECTION_ICON));
        } else {
            this.fStandardLabelProvider.updateLabel(label, elementPath.getLastSegment());
        }
    }

    public void dispose() {
        this.fResourceManager.dispose();
        this.fStandardLabelProvider.dispose();
        super.dispose();
    }
}

