/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.feed.section;

import com.ibm.team.feed.core.ClientFeedUtils;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.feed.ui.internal.itemview.Mappings;
import com.ibm.team.jface.GenericAggregationBin;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.util.ItemQueryIterator;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.feed.section.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamFilter
extends ViewerFilter {
    private Viewer fViewer;
    private int fType;
    private Set<String> fCategories;
    private boolean fIsUpdating;
    private IListener fStateListener = new IListener(){

        public void handleEvents(List events) {
            for (IEvent event : events) {
                ITeamRepository repository = (ITeamRepository)event.getEventSource();
                if (!repository.loggedIn() || repository.getErrorState() != 0) continue;
                repository.removeGenericListener((Object)"state", TeamFilter.this.fStateListener);
                repository.removeGenericListener((Object)"error_state", TeamFilter.this.fStateListener);
                TeamFilter.this.fComputeCategoriesJob.schedule();
            }
        }
    };
    private UIUpdaterJob fComputeCategoriesJob = new UIUpdaterJob(Messages.TeamFilter_COMPUTING_CATEGORIES){
        Set<String> fNewCategories;
        boolean fIsNew;

        public IStatus runInBackground(IProgressMonitor monitor) {
            ITeamRepository[] teamRepositories;
            this.fNewCategories = new HashSet<String>();
            ITeamRepository[] iTeamRepositoryArray = teamRepositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            int n = teamRepositories.length;
            int n2 = 0;
            while (n2 < n) {
                ITeamRepository repository = iTeamRepositoryArray[n2];
                if (repository.loggedIn() && repository.getErrorState() == 0) {
                    List teamareasOfUser = TeamFilter.this.getTeamAreasBelongingToUser(repository, monitor);
                    for (ITeamArea area : teamareasOfUser) {
                        this.fNewCategories.addAll(TeamFilter.this.getCategoriesOfTeamArea(area, repository, monitor));
                    }
                } else {
                    repository.addGenericListener((Object)"state", TeamFilter.this.fStateListener);
                    repository.addGenericListener((Object)"error_state", TeamFilter.this.fStateListener);
                }
                ++n2;
            }
            boolean bl = this.fIsNew = TeamFilter.this.fCategories == null || !TeamFilter.this.fCategories.containsAll(this.fNewCategories);
            if (this.fIsNew) {
                if (TeamFilter.this.fCategories == null) {
                    TeamFilter.this.fCategories = this.fNewCategories;
                } else {
                    TeamFilter.this.fCategories.addAll(this.fNewCategories);
                }
            }
            return super.runInBackground(monitor);
        }

        public IStatus runInUI(IProgressMonitor monitor) {
            if (this.fIsNew && TeamFilter.this.fViewer != null && !TeamFilter.this.fViewer.getControl().isDisposed()) {
                TeamFilter.this.fViewer.refresh();
            }
            return super.runInUI(monitor);
        }
    };

    public TeamFilter(int type) {
        this.fType = type;
        this.fIsUpdating = false;
        TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener(new ITeamRepositoryService.IRepositoryServiceListener(){

            public void addedRepository(ITeamRepository repositiory) {
                repositiory.addGenericListener((Object)"state", TeamFilter.this.fStateListener);
                repositiory.addGenericListener((Object)"error_state", TeamFilter.this.fStateListener);
            }

            public void removedRepository(ITeamRepository repository) {
                repository.removeGenericListener((Object)"state", TeamFilter.this.fStateListener);
                repository.removeGenericListener((Object)"error_state", TeamFilter.this.fStateListener);
            }
        });
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        this.fViewer = viewer;
        if (this.fCategories == null) {
            if (!this.fIsUpdating) {
                this.fIsUpdating = true;
                this.fComputeCategoriesJob.schedule();
            }
            return true;
        }
        if (element instanceof GenericAggregationBin) {
            element = ((GenericAggregationBin)element).getMostRecent();
        }
        if (element instanceof NewsItem) {
            String categoriesString;
            NewsItem item = (NewsItem)element;
            String relationLiteral = ClientFeedUtils.getInstance().getRelation(item);
            if (this.fType == 0 && (categoriesString = item.getCustomAttribute("http://www.ibm.com/team/Feed", "workitemCategory")) != null && !this.fCategories.isEmpty()) {
                return this.fCategories.contains(categoriesString);
            }
            if (this.fType == 3) {
                return "subscriber".equals(relationLiteral);
            }
            if (this.fType == 2) {
                return ClientFeedUtils.getInstance().isCreator(item);
            }
            return Mappings.isOwner((String)relationLiteral);
        }
        return true;
    }

    private List<ITeamArea> getTeamAreasBelongingToUser(ITeamRepository repository, IProgressMonitor monitor) {
        try {
            IAuditableClient auditableClient = (IAuditableClient)repository.getClientLibrary(IAuditableClient.class);
            ItemQueryIterator teamsIter = WorkItemQueries.teamAreasByContributor((IAuditableCommon)auditableClient, (IContributorHandle)repository.loggedInContributor());
            ArrayList<ITeamAreaHandle> teamAreasOfUser = new ArrayList<ITeamAreaHandle>();
            while (teamsIter.hasNext(monitor)) {
                teamAreasOfUser.add((ITeamAreaHandle)teamsIter.next(monitor));
            }
            List resolved = repository.itemManager().fetchCompleteItems(teamAreasOfUser, 0, monitor);
            return resolved;
        }
        catch (TeamRepositoryException e) {
            WorkItemRCPUIPlugin.getDefault().log(Messages.TeamFilter_ERROR_RESOLVING_TEAM_AREAS, e);
            return new ArrayList<ITeamArea>();
        }
    }

    private Collection<String> getCategoriesOfTeamArea(ITeamArea area, ITeamRepository repository, IProgressMonitor monitor) {
        IWorkItemClient workItemClient = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
        ArrayList<String> names = new ArrayList<String>();
        List categories = null;
        try {
            categories = workItemClient.findCategoriesOfTeamArea((ITeamAreaHandle)area, ICategory.DEFAULT_PROFILE, monitor);
            for (ICategory category : categories) {
                names.add(workItemClient.resolveHierarchicalName((ICategoryHandle)category, monitor));
            }
        }
        catch (TeamRepositoryException e) {
            WorkItemRCPUIPlugin.getDefault().log(Messages.TeamFilter_ERROR_RESOLVING_CATEGORIES, e);
            return names;
        }
        return names;
    }
}

