/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.feed.section;

import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.IFeedManagerConfigurer;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.FeedFactory;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.IFeedService;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IWorkItemFeedConstants;
import com.ibm.team.workitem.common.internal.util.Utils;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.feed.section.Messages;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.PlatformUI;

public class EventFeedProvider
implements IFeedManagerConfigurer {
    private static final String DFL_ENC = "UTF-8";
    private static final String FEED_SERVICE = IFeedService.SERVICE_NAME;
    private ITeamRepositoryService.IRepositoryServiceListener fRepositoryListener = new ITeamRepositoryService.IRepositoryServiceListener(){

        public void addedRepository(ITeamRepository repository) {
            repository.addGenericListener((Object)"state", EventFeedProvider.this.fStateListener);
            EventFeedProvider.this.addChannel(repository);
        }

        public void removedRepository(ITeamRepository repository) {
            repository.removeGenericListener((Object)"state", EventFeedProvider.this.fStateListener);
            EventFeedProvider.this.removeChannel(repository);
        }
    };
    private IListener fStateListener = new IListener(){

        public void handleEvents(List events) {
            for (Object ev : events) {
                if (!(ev instanceof IPropertyChangeEvent)) continue;
                IPropertyChangeEvent delta = (IPropertyChangeEvent)ev;
                ITeamRepository repository = (ITeamRepository)delta.getObject();
                Object newValue = delta.getNewValue();
                if (!newValue.equals(new Integer(1)) && !newValue.equals(new Integer(3))) continue;
                EventFeedProvider.this.updateChannel(repository);
            }
        }
    };
    private IConnectedProjectAreaRegistryListener fConnectedProjectAreaListener = new IConnectedProjectAreaRegistryListener(){

        public void connectedProjectAreaRegistryChanged(IConnectedProjectAreaRegistryChangeEvent changeEvent) {
            if (changeEvent.getType() == 2) {
                EventFeedProvider.this.removeChannel(changeEvent.getTeamRepository(), changeEvent.getRemovedProjectArea());
            } else if (changeEvent.getType() == 3) {
                this.handleArchivedProjectArea(changeEvent);
            } else {
                ITeamRepository teamRepository = changeEvent.getTeamRepository();
                EventFeedProvider.this.addChannel(teamRepository);
            }
        }

        private void handleArchivedProjectArea(final IConnectedProjectAreaRegistryChangeEvent changeEvent) {
            FoundationJob job = new FoundationJob(Messages.EventFeedProvider_CONNECTED_PA_CHANGED_CHECK_ARCHIVED){

                protected IStatus runProtected(IProgressMonitor monitor) {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                    IProjectAreaHandle projectAreaHandle = changeEvent.getProjectAreaHandle();
                    try {
                        IProjectArea projectArea = (IProjectArea)changeEvent.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)projectAreaHandle, 0, (IProgressMonitor)subMonitor.newChild(1));
                        if (projectArea.isArchived()) {
                            EventFeedProvider.this.removeChannel(changeEvent.getTeamRepository(), (IProjectAreaHandle)projectArea);
                        }
                    }
                    catch (TeamRepositoryException e) {
                        WorkItemRCPUIPlugin.getDefault().log(Messages.EventFeedProvider_ERROR_CHECKING_PROJECT_ARCHIVED, e);
                    }
                    subMonitor.newChild(1);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    };

    public void configure(FeedManager manager) {
        this.init();
    }

    public void init() {
        TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener(this.fRepositoryListener);
        ITeamRepository[] teamRepositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < teamRepositories.length) {
            ITeamRepository repository = teamRepositories[i];
            repository.addGenericListener((Object)"state", this.fStateListener);
            this.addChannel(repository);
            ++i;
        }
        ConnectedProjectAreaRegistry projectAreaRegistry = ConnectedProjectAreaRegistry.getDefault();
        if (projectAreaRegistry != null) {
            projectAreaRegistry.addListener(this.fConnectedProjectAreaListener);
        }
    }

    public void dispose() {
        TeamPlatform.getTeamRepositoryService().removeRepositoryServiceListener(this.fRepositoryListener);
        ITeamRepository[] teamRepositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < teamRepositories.length) {
            teamRepositories[i].removeGenericListener((Object)"state", this.fStateListener);
            ++i;
        }
    }

    private void updateChannel(ITeamRepository repository) {
        this.addChannel(repository);
    }

    private void removeChannel(ITeamRepository repository) {
        Channel[] channels = FeedManager.getDefault().getChannels();
        ArrayList<Channel> foundChannel = new ArrayList<Channel>();
        try {
            URI serverURI = new URI(repository.getRepositoryURI());
            int i = 0;
            while (i < channels.length) {
                if (this.matchesChannelURI(serverURI, channels[i].getUrl())) {
                    foundChannel.add(channels[i]);
                }
                ++i;
            }
        }
        catch (URISyntaxException e) {
            WorkItemRCPUIPlugin.getDefault().log(Messages.EventFeedProvider_REMOVING_FEED, e);
        }
        for (Channel channel : foundChannel) {
            FeedManager.getDefault().removeChannel(channel);
        }
    }

    private void removeChannel(final ITeamRepository repository, final IProjectAreaHandle projectAreaHandle) {
        FoundationJob job = new FoundationJob(Messages.EventFeedProvider_REMOVING_SUBSCRIPTION){

            protected IStatus runProtected(IProgressMonitor monitor) {
                try {
                    ArrayList<String> props = new ArrayList<String>();
                    props.add("name");
                    IProjectArea projectArea = (IProjectArea)repository.itemManager().fetchPartialItem((IItemHandle)projectAreaHandle, 0, props, null);
                    String feedURI = EventFeedProvider.this.getFeedURI(projectArea);
                    Channel channel = FeedManager.getDefault().getChannel(feedURI);
                    if (channel != null) {
                        FeedManager.getDefault().removeChannel(channel);
                    }
                    String classicFeedURI = EventFeedProvider.this.getFeedURI(projectArea, true);
                    channel = FeedManager.getDefault().getChannel(classicFeedURI);
                    if (channel != null) {
                        FeedManager.getDefault().removeChannel(channel);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    WorkItemRCPUIPlugin.getDefault().log(Messages.EventFeedProvider_ERROR_CREATING_URI, e);
                }
                catch (URISyntaxException e) {
                    WorkItemRCPUIPlugin.getDefault().log(Messages.EventFeedProvider_ERROR_CREATING_URI, e);
                }
                catch (NotLoggedInException notLoggedInException) {
                }
                catch (TeamRepositoryException e) {
                    WorkItemRCPUIPlugin.getDefault().log(Messages.EventFeedProvider_ERROR_RESOLVING_PROJECT_AREA, e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private Channel createChannel(String urlStr, String title, String description, boolean forceDownload) {
        Channel channel = FeedManager.getDefault().getChannel(urlStr);
        if (channel == null) {
            channel = FeedFactory.eINSTANCE.createChannel();
            channel.setUrl(urlStr);
            channel.setTitle(title);
            channel.setDescription(description);
            channel.setForceDownload(forceDownload);
            channel.setCategory("com.ibm.team.feed.core.SystemFeed");
            channel.setUpdateInterval(10);
            channel.setItemLimit(1000);
            FeedManager.getDefault().addChannel(channel);
            if (channel.isForceDownload()) {
                FeedManager.getDefault().loadNews(channel);
            }
        }
        return channel;
    }

    private String getFeedServiceURI(URI uri) {
        String baseURI;
        URI correctURI = uri;
        if (this.isLocal(uri)) {
            String url = Utils.getHttpRepositoryUrl((String)uri.toString());
            try {
                correctURI = new URI(url);
            }
            catch (URISyntaxException e) {
                WorkItemRCPUIPlugin.getDefault().log(Messages.EventFeedProvider_INVALID_LOCAL_URI, e);
            }
        }
        if ((baseURI = Utils.getBaseURI((URI)correctURI)) == null) {
            return null;
        }
        StringBuffer url = new StringBuffer(baseURI);
        url.append("service/");
        url.append(FEED_SERVICE);
        url.append("?itemType=WorkItem");
        url.append("&user=").append("{$user}");
        return url.toString();
    }

    private String getFeedTitle(ITeamRepository repository, boolean isFeedService) {
        String repo = repository.getName();
        if (repo == null || repo.length() == 0) {
            String urlStr = repository.getRepositoryURI();
            int startidx = urlStr.indexOf("//") + 2;
            repo = urlStr.substring(startidx, urlStr.indexOf("/", startidx));
        }
        if (isFeedService) {
            if (repo != null && repo.length() > 0) {
                return NLS.bind((String)Messages.EventFeedProvider_MY_WORKITEM_CHANGES_ON, (Object)repo, (Object[])new Object[0]);
            }
            return Messages.EventFeedProvider_MY_WORKITEM_CHANGES;
        }
        return Messages.EventFeedProvider_NOTIFICATIONS;
    }

    private boolean isLocal(URI uri) {
        return "local".equals(uri.getScheme());
    }

    private boolean matchesChannelURI(URI serverURI, String channelURI) {
        if (serverURI == null) {
            return false;
        }
        String tocheck = serverURI.getScheme();
        if (tocheck != null && channelURI.indexOf(tocheck) == -1) {
            return false;
        }
        tocheck = serverURI.getAuthority();
        return tocheck == null || channelURI.indexOf(tocheck) != -1;
    }

    private Channel addChannel(ITeamRepository repository) {
        if (PlatformUI.isWorkbenchRunning() && PlatformUI.getWorkbench().isClosing()) {
            return null;
        }
        ConnectedProjectAreaRegistry projectAreaRegistry = ConnectedProjectAreaRegistry.getDefault();
        if (projectAreaRegistry == null) {
            return null;
        }
        List projectAreas = projectAreaRegistry.getConnectedProjectAreas(repository);
        for (IProjectAreaHandle projectArea : projectAreas) {
            if (!projectArea.hasFullState()) continue;
            this.addChannel((IProjectArea)projectArea.getFullState());
        }
        return this.initFeedForTeamServices(repository);
    }

    private Channel initFeedForTeamServices(ITeamRepository repository) {
        URI uri;
        if (!repository.loggedIn() || this.isRepositoryDeleted(repository)) {
            return null;
        }
        try {
            uri = new URI(repository.getRepositoryURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        String feedServiceURI = this.getFeedServiceURI(uri);
        if (feedServiceURI != null) {
            boolean force;
            String title;
            if (feedServiceURI.indexOf(FEED_SERVICE) != -1) {
                title = this.getFeedTitle(repository, true);
                force = true;
            } else {
                title = this.getFeedTitle(repository, false);
                force = true;
            }
            String description = Messages.EventFeedProvider_WORKITEM_CHANGES_DESCRIPTION;
            Channel channel = this.createChannel(feedServiceURI, title, description, force);
            FeedManager.getDefault().registerPredefinedChannel(channel, IWorkItemFeedConstants.UTILITY.getMyChangesFeedKey(repository.getRepositoryURI()));
            return channel;
        }
        return null;
    }

    private boolean isRepositoryDeleted(ITeamRepository repository) {
        ITeamRepository[] teamRepositories;
        ITeamRepository[] iTeamRepositoryArray = teamRepositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = teamRepositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository teamRepository = iTeamRepositoryArray[n2];
            if (teamRepository.getRepositoryURI().equals(repository.getRepositoryURI())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private String getFeedURI(IProjectArea projectArea) throws URISyntaxException, UnsupportedEncodingException {
        return this.getFeedURI(projectArea, false);
    }

    private String getFeedURI(IProjectArea projectArea, boolean classic) throws URISyntaxException, UnsupportedEncodingException {
        URI uri;
        ITeamRepository repo = (ITeamRepository)projectArea.getOrigin();
        URI correctURI = uri = new URI(repo.getRepositoryURI());
        if (this.isLocal(uri)) {
            String url = Utils.getHttpRepositoryUrl((String)uri.toString());
            try {
                correctURI = new URI(url);
            }
            catch (URISyntaxException e) {
                WorkItemRCPUIPlugin.getDefault().log(Messages.EventFeedProvider_INVALID_LOCAL_URI, e);
            }
        }
        String baseURI = Utils.getBaseURI((URI)correctURI);
        StringBuffer url = new StringBuffer(baseURI);
        url.append("service/");
        url.append(FEED_SERVICE);
        url.append("?provider=team&project_area=");
        url.append(URLEncoder.encode(projectArea.getName(), DFL_ENC));
        if (!classic) {
            url.append("&project_area_id=");
            url.append(projectArea.getItemId().getUuidValue());
        }
        url.append("&user=").append("{$user}");
        return url.toString();
    }

    private Channel addChannel(IProjectArea projectArea) {
        try {
            String description = Messages.EventFeedProvider_NOTIFICATIONS_DESCRIPTION;
            String classicFeedURI = this.getFeedURI(projectArea, true);
            Channel classicChannel = FeedManager.getDefault().getChannel(classicFeedURI);
            if (classicChannel != null) {
                FeedManager.getDefault().registerPredefinedChannel(classicChannel, IWorkItemFeedConstants.UTILITY.getMyTeamsChangesFeedKey(projectArea.getItemId()));
                return classicChannel;
            }
            String feedURI = this.getFeedURI(projectArea);
            if (feedURI != null) {
                Channel channel = this.createChannel(feedURI, NLS.bind((String)Messages.EventFeedProvider_MY_TEAMS_IN_PA, (Object)projectArea.getName(), (Object[])new Object[0]), description, true);
                FeedManager.getDefault().registerPredefinedChannel(channel, IWorkItemFeedConstants.UTILITY.getMyTeamsChangesFeedKey(projectArea.getItemId()));
                return channel;
            }
        }
        catch (UnsupportedEncodingException e) {
            WorkItemRCPUIPlugin.getDefault().log(String.valueOf(Messages.EventFeedProvider_ERROR_CREATING_MY_TEAMS_FEED) + projectArea.getName(), e);
        }
        catch (URISyntaxException e) {
            WorkItemRCPUIPlugin.getDefault().log(String.valueOf(Messages.EventFeedProvider_ERROR_CREATING_MY_TEAMS_FEED) + projectArea.getName(), e);
        }
        return null;
    }
}

