/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.feed;

import com.ibm.team.feed.core.ChannelEvent;
import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.INewsManagerListener;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.feed.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;

public class UserFeedbackNewsManagerListener
implements INewsManagerListener {
    private static final String TAN_ID = "com.ibm.team.process.rcp.ui.teamArtifactsNavigator";
    private Channel fChannel;
    private IWorkbenchPart fWorkbenchPart;

    public UserFeedbackNewsManagerListener(IWorkbenchPart workbenchpart, Channel channel) {
        this.fWorkbenchPart = workbenchpart;
        this.fChannel = channel;
        FeedManager.getDefault().addNewsManagerListener((INewsManagerListener)this);
    }

    public void channelAdded(ChannelEvent event) {
        if (this.fChannel == null) {
            return;
        }
        final Channel channel = event.getChannel();
        if (channel.getUrl().equals(this.fChannel.getUrl())) {
            FoundationUIJob job = new FoundationUIJob(""){

                public IStatus runProtectedInUI(IProgressMonitor monitor) {
                    block4: {
                        try {
                            IViewPart tan = UserFeedbackNewsManagerListener.this.showTAN();
                            if (tan != null) {
                                IShowInTarget showinTarget = (IShowInTarget)Adapters.getAdapter((Object)tan, IShowInTarget.class);
                                showinTarget.show(new ShowInContext(null, (ISelection)new TreeSelection(new TreePath(new Object[]{FeedManager.getDefault(), channel}))));
                            } else {
                                FeedbackDialog.show(UserFeedbackNewsManagerListener.this.fWorkbenchPart, channel);
                            }
                        }
                        catch (PartInitException e) {
                            WorkItemRCPUIPlugin.getDefault().log(Messages.UserFeedbackNewsManagerListener_ERROR_OPENING_TEAM_ARTIFACTS, e);
                            Object shellProvider = null;
                            shellProvider = UserFeedbackNewsManagerListener.this.fWorkbenchPart != null ? UserFeedbackNewsManagerListener.this.fWorkbenchPart.getSite() : FoundationUIUtils.getShellProvider();
                            if (shellProvider == null) break block4;
                            MessageDialog.openError((Shell)shellProvider.getShell(), (String)Messages.UserFeedbackNewsManagerListener_ERROR_OPENING_TEAM_ARTIFACTS_TITLE, (String)Messages.UserFeedbackNewsManagerListener_ERROR_OPENING_TEAM_ARTIFACTS_MESSAGE);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
        FeedManager.getDefault().removeNewsManagerListener((INewsManagerListener)this);
        this.fChannel = null;
    }

    public void channelRemoved(ChannelEvent event) {
    }

    private IViewPart showTAN() throws PartInitException {
        IWorkbenchPage page = null;
        page = this.fWorkbenchPart != null ? this.fWorkbenchPart.getSite().getPage() : FoundationUIUtils.getActivePage();
        if (page != null) {
            IViewPart view = page.findView(TAN_ID);
            if (view != null) {
                page.showView(TAN_ID);
            }
            return view;
        }
        return null;
    }

    private static class FeedbackDialog
    extends MessageDialog {
        IWorkbenchPart fWorkbenchPart;
        Channel fAddedChannel;

        public static void show(IWorkbenchPart workbenchPart, Channel channel) {
            Object parentShellProvider = null;
            parentShellProvider = workbenchPart != null ? workbenchPart.getSite() : FoundationUIUtils.getShellProvider();
            if (parentShellProvider != null) {
                String title = Messages.UserFeedbackNewsManagerListener_SUBSCTIPTION_ADDED_TITLE;
                String message = Messages.UserFeedbackNewsManagerListener_SUBSCRIPTION_ADDED_MESSAGE;
                FeedbackDialog dialog = new FeedbackDialog(workbenchPart, channel, parentShellProvider.getShell(), title, null, message, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                dialog.open();
            }
        }

        public FeedbackDialog(IWorkbenchPart workbenchPart, Channel channel, Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
            super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
            this.fWorkbenchPart = workbenchPart;
            this.fAddedChannel = channel;
        }

        protected Control createMessageArea(Composite composite) {
            Composite area = new Composite(composite, 0);
            area.setLayout((Layout)new GridLayout(2, false));
            super.createMessageArea(area);
            Label empty = new Label(area, 0);
            empty.setText("");
            Link link = new Link(area, 0);
            link.setText(NLS.bind((String)"<a>{0}</a>", (Object)Messages.UserFeedbackNewsManagerListener_SHOW_IN_TAN, (Object[])new Object[0]));
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FeedbackDialog.this.close();
                    IWorkbenchPage page = null;
                    page = FeedbackDialog.this.fWorkbenchPart != null ? FeedbackDialog.this.fWorkbenchPart.getSite().getPage() : FoundationUIUtils.getActivePage();
                    if (page != null) {
                        try {
                            IViewPart tan = page.showView(UserFeedbackNewsManagerListener.TAN_ID);
                            if (tan != null) {
                                IShowInTarget showinTarget = (IShowInTarget)Adapters.getAdapter((Object)tan, IShowInTarget.class);
                                showinTarget.show(new ShowInContext(null, (ISelection)new TreeSelection(new TreePath(new Object[]{FeedManager.getDefault(), FeedbackDialog.this.fAddedChannel}))));
                            }
                        }
                        catch (PartInitException ex) {
                            WorkItemRCPUIPlugin.getDefault().log(Messages.UserFeedbackNewsManagerListener_ERROR_OPENING_TEAM_ARTIFACTS, ex);
                            MessageDialog.openError((Shell)page.getWorkbenchWindow().getShell(), (String)Messages.UserFeedbackNewsManagerListener_ERROR_OPENING_TEAM_ARTIFACTS_TITLE, (String)Messages.UserFeedbackNewsManagerListener_ERROR_OPENING_TEAM_ARTIFACTS_MESSAGE);
                        }
                    }
                }
            });
            return area;
        }

        protected Control createButtonBar(Composite parent) {
            Control buttonBar2 = super.createButtonBar(parent);
            Button okButton = this.getButton(0);
            okButton.setFocus();
            return buttonBar2;
        }
    }
}

