/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.explorer.view;

import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.part.Page;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemViewPageRegistry {
    public static final String WORKITEM_VIEW_PAGES_EXTENSION_POINT = "workItemViewPages";
    public static final String SETUP_PAGE = "com.ibm.team.workitem.explorer.page.setup";
    public static final String INITIAL_PAGE = "com.ibm.team.workitem.explorer.page.initial";
    private static WorkItemViewPageRegistry fgInstance;
    private List<PageProxy> fProxies;

    public static WorkItemViewPageRegistry getInstance() {
        if (fgInstance == null) {
            fgInstance = new WorkItemViewPageRegistry();
        }
        return fgInstance;
    }

    private WorkItemViewPageRegistry() {
    }

    public Page createPage(String targetId, String pageId) {
        List<PageProxy> proxies = this.getPageProxies();
        for (PageProxy pageProxy : proxies) {
            if (!pageProxy.isEnabledFor(targetId, pageId)) continue;
            return pageProxy.createPage();
        }
        return null;
    }

    private List<PageProxy> getPageProxies() {
        if (this.fProxies == null) {
            IConfigurationElement[] elements;
            ArrayList<PageProxy> proxies = new ArrayList<PageProxy>();
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.ibm.team.workitem.rcp.ui", WORKITEM_VIEW_PAGES_EXTENSION_POINT);
            IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                proxies.add(new PageProxy(configurationElement));
                ++n2;
            }
            this.fProxies = proxies;
        }
        return this.fProxies;
    }

    private static class PageProxy {
        private static final String PROPERTY_CLASS = "class";
        private static final String PROPERTY_PAGE_ID = "pageId";
        private static final String PROPERTY_TARGET_ID = "targetId";
        private final IConfigurationElement fConfigurationElement;

        public PageProxy(IConfigurationElement element) {
            this.fConfigurationElement = element;
        }

        public boolean isEnabledFor(String targetId, String pageId) {
            String pid = this.fConfigurationElement.getAttribute(PROPERTY_PAGE_ID);
            String tid = this.fConfigurationElement.getAttribute(PROPERTY_TARGET_ID);
            return tid.equals(targetId) && pid.equals(pageId);
        }

        public Page createPage() {
            try {
                return (Page)this.fConfigurationElement.createExecutableExtension(PROPERTY_CLASS);
            }
            catch (CoreException e) {
                WorkItemRCPUIPlugin.getDefault().log(e.getStatus());
                return null;
            }
        }
    }
}

