/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.explorer.view;

import com.ibm.team.foundation.rcp.core.internal.favorites.Favorite;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesManager;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.internal.util.ItemQueryIterator;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.rcp.ui.QueriesUI;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.explorer.view.Messages;
import com.ibm.team.workitem.rcp.ui.internal.util.HyperlinkUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.part.Page;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitialWorkItemViewPage
extends Page {
    private static final String KEY_NAME = "_namedQuery";
    private static final int MAX_FAVORITES = 10;
    private Composite fViewerArea;
    private List<Link> fNamedQueryLinks = new ArrayList<Link>();
    private IConnectedProjectAreaRegistryListener fProjectAreaChangeListener = new IConnectedProjectAreaRegistryListener(){

        public void connectedProjectAreaRegistryChanged(IConnectedProjectAreaRegistryChangeEvent changeEvent) {
            WorkItemRCPUIPlugin.runInUI(Messages.InitialWorkItemViewPage_UPDATE_LINKS_JOB_NAME, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (InitialWorkItemViewPage.this.fViewerArea.isDisposed()) {
                        return;
                    }
                    ItemHandleAwareHashSet knownProjectAreas = InitialWorkItemViewPage.this.getKnownProjectAreas();
                    ItemHandleAwareHashSet currentProjectAreas = new ItemHandleAwareHashSet((Collection)ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(null, false));
                    for (IProjectAreaHandle projectArea : currentProjectAreas) {
                        if (knownProjectAreas.contains((Object)projectArea)) continue;
                        InitialWorkItemViewPage.this.addLinks(projectArea);
                    }
                    for (IProjectAreaHandle projectArea : knownProjectAreas) {
                        if (currentProjectAreas.contains((Object)projectArea)) continue;
                        InitialWorkItemViewPage.this.removeLinks(InitialWorkItemViewPage.this.getAffectedLinks(projectArea));
                    }
                    InitialWorkItemViewPage.this.fViewerArea.layout();
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
    };
    private SelectionAdapter fExecuteHandler = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Link link = (Link)e.widget;
            InitialWorkItemViewPage.this.showQueryResults(InitialWorkItemViewPage.this.getNamedQuery(link));
        }
    };
    private SelectionAdapter fOpenTANHandler = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            WorkItemRCPUIPlugin.openArtifactNavigator(InitialWorkItemViewPage.this.getSite().getWorkbenchWindow(), (ISelection)StructuredSelection.EMPTY);
        }
    };

    public void createControl(Composite parent) {
        this.fViewerArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.fViewerArea.setLayout((Layout)layout);
        this.fViewerArea.setBackground(this.fViewerArea.getDisplay().getSystemColor(25));
        Link label = new Link(this.fViewerArea, 0);
        label.setText(Messages.InitialWorkItemViewPage_EMPTY_WORKITEMVIEW_MESSAGE);
        label.setBackground(this.fViewerArea.getBackground());
        label.addSelectionListener((SelectionListener)this.fOpenTANHandler);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
        List<Favorite> queryFavorites = this.getQueryFavorites();
        if (queryFavorites.isEmpty()) {
            List projectAreas = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(null, false);
            for (IProjectAreaHandle projectArea : projectAreas) {
                this.addLinks(projectArea);
            }
            ConnectedProjectAreaRegistry.getDefault().addListener(this.fProjectAreaChangeListener);
        } else {
            for (Favorite favorite : queryFavorites) {
                Link link = this.createLink(this.fViewerArea);
                link.setText(this.createLinkLabel(favorite.getText()));
                HyperlinkUtils.DecoratedHyperlink hyperlink = HyperlinkUtils.createDecoratedHyperlink((Control)link);
                hyperlink.getControlLabelProvider().setElement((Object)favorite.getItem());
            }
        }
    }

    private void addLinks(IProjectAreaHandle projectArea) {
        PredefinedQuery openAssignedToMe = new PredefinedQuery(projectArea, Messages.InitialWorkItemViewPage_OPEN_ASSIGNED_TO_ME, "com.ibm.team.workitem.queries.predefined.myOpen");
        Link openAssignedToMeLink = this.createLink(this.fViewerArea);
        openAssignedToMeLink.setText(this.createLinkLabel(openAssignedToMe.getName()));
        openAssignedToMeLink.setData(KEY_NAME, (Object)openAssignedToMe);
        openAssignedToMeLink.addSelectionListener((SelectionListener)this.fExecuteHandler);
        this.fNamedQueryLinks.add(openAssignedToMeLink);
        PredefinedQuery recentlyCreated = new PredefinedQuery(projectArea, Messages.InitialWorkItemViewPage_RECENTLY_CREATED, "com.ibm.team.workitem.queries.predefined.recentlyCreated");
        Link recentlyCreatedLink = this.createLink(this.fViewerArea);
        recentlyCreatedLink.setText(this.createLinkLabel(recentlyCreated.getName()));
        recentlyCreatedLink.setData(KEY_NAME, (Object)recentlyCreated);
        recentlyCreatedLink.addSelectionListener((SelectionListener)this.fExecuteHandler);
        this.fNamedQueryLinks.add(recentlyCreatedLink);
    }

    private void removeLinks(List<Link> toRemove) {
        for (Link link : toRemove) {
            this.fNamedQueryLinks.remove(link);
            link.dispose();
        }
    }

    private Link createLink(Composite parent) {
        Link link = new Link(parent, 0);
        link.setBackground(parent.getBackground());
        return link;
    }

    private PredefinedQuery getNamedQuery(Link link) {
        return (PredefinedQuery)link.getData(KEY_NAME);
    }

    private List<Link> getAffectedLinks(IProjectAreaHandle handle) {
        ArrayList<Link> affectedLinks = new ArrayList<Link>(2);
        for (Link link : this.fNamedQueryLinks) {
            PredefinedQuery query = this.getNamedQuery(link);
            if (!handle.sameItemId((IItemHandle)query.getProjectArea())) continue;
            affectedLinks.add(link);
        }
        return affectedLinks;
    }

    private ItemHandleAwareHashSet getKnownProjectAreas() {
        ItemHandleAwareHashSet set = new ItemHandleAwareHashSet();
        for (Link link : this.fNamedQueryLinks) {
            PredefinedQuery query = this.getNamedQuery(link);
            set.add((Object)query.getProjectArea());
        }
        return set;
    }

    private String createLinkLabel(String linkText) {
        return String.format("<a>%s</a>", linkText);
    }

    List<Favorite> getQueryFavorites() {
        int count = 0;
        ArrayList<Favorite> queryFavorites = new ArrayList<Favorite>();
        Iterator iterator = FavoritesManager.getInstance().getFavoritesIterator();
        while (iterator.hasNext() && count < 10) {
            Favorite favorite;
            IItemHandle itemHandle;
            FavoritesNode node = (FavoritesNode)iterator.next();
            if (!(node instanceof Favorite) || !((itemHandle = (favorite = (Favorite)node).getItem()) instanceof IQueryDescriptorHandle)) continue;
            queryFavorites.add(favorite);
            ++count;
        }
        return queryFavorites;
    }

    private void showQueryResults(final PredefinedQuery query) {
        ITeamRepository repository = (ITeamRepository)query.getProjectArea().getOrigin();
        IStatus status = FoundationUIUtils.validateRepository((ITeamRepository)repository, (boolean)false, null);
        if (!status.isOK()) {
            return;
        }
        UIUpdaterJob job = new UIUpdaterJob(query.getName()){
            IQueryDescriptorHandle fHandle;

            public IStatus runInBackground(IProgressMonitor monitor) {
                try {
                    this.fHandle = query.fetchQueryDescriptor(monitor);
                    return super.runInBackground(monitor);
                }
                catch (TeamRepositoryException e) {
                    String error = NLS.bind((String)Messages.InitialWorkItemViewPage_COULD_NOT_RESOLVE_QUERY, (Object)query.getName(), (Object[])new Object[0]);
                    Status status = new Status(4, "com.ibm.team.workitem.rcp.ui", error, (Throwable)e);
                    WorkItemRCPUIPlugin.getDefault().log((IStatus)status);
                    return status;
                }
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                if (this.fHandle != null) {
                    QueriesUI.showQueryResults(InitialWorkItemViewPage.this.getSite().getWorkbenchWindow(), this.fHandle);
                }
                return super.runInUI(monitor);
            }
        };
        job.schedule();
    }

    public Control getControl() {
        return this.fViewerArea;
    }

    public void setFocus() {
        this.fViewerArea.setFocus();
    }

    public void dispose() {
        ConnectedProjectAreaRegistry.getDefault().removeListener(this.fProjectAreaChangeListener);
        this.fNamedQueryLinks.clear();
        super.dispose();
    }

    private static class PredefinedQuery {
        private final IProjectAreaHandle fProjectAreaHandle;
        private final String fQueryIdentifier;
        private final String fLabel;
        private IQueryDescriptorHandle fQueryDescriptor;

        public PredefinedQuery(IProjectAreaHandle projectArea, String label, String identifier) {
            this.fProjectAreaHandle = projectArea;
            this.fLabel = label;
            this.fQueryIdentifier = identifier;
        }

        public String getName() {
            String projectAreaName = ConnectedProjectAreaRegistry.getDefault().getProjectAreaName(this.fProjectAreaHandle);
            if (projectAreaName != null) {
                return NLS.bind((String)Messages.InitialWorkItemViewPage_QUERY_LINK_FORMAT, (Object)this.fLabel, (Object[])new Object[]{projectAreaName});
            }
            return this.fLabel;
        }

        public IProjectAreaHandle getProjectArea() {
            return this.fProjectAreaHandle;
        }

        public IQueryDescriptorHandle fetchQueryDescriptor(IProgressMonitor monitor) throws TeamRepositoryException {
            ITeamRepository repository;
            IAuditableClient auditableClient;
            ItemQueryIterator iterator;
            if (this.fQueryDescriptor == null && (iterator = WorkItemQueries.queryDescriptorById((IAuditableCommon)(auditableClient = (IAuditableClient)(repository = (ITeamRepository)this.fProjectAreaHandle.getOrigin()).getClientLibrary(IAuditableClient.class)), (IProjectAreaHandle)this.fProjectAreaHandle, (String)this.fQueryIdentifier)).hasNext(monitor)) {
                this.fQueryDescriptor = (IQueryDescriptorHandle)iterator.next(monitor);
            }
            return this.fQueryDescriptor;
        }
    }
}

