/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.explorer.view;

import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.explorer.view.IHistoryItem;
import com.ibm.team.workitem.rcp.ui.internal.explorer.view.Messages;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.ListDialog;

public class HistoryManager {
    public static final int RESULTS_IN_HISTORY_DROP_DOWN = 10;
    public static final int MAX_NUMBER_OF_CACHED_QUERIES = 5;
    private LinkedList<IHistoryItem> fHistory = new LinkedList();
    private Stack<IHistoryItem> fBackwardStack = new Stack();
    private Stack<IHistoryItem> fForwardStack = new Stack();
    private IHistoryItem fCurrentItem;
    private IShellProvider fShellProvider;
    private HistoryDropDownAction fHistoryDropDownAction;
    private Action fHistoryBackAction;
    private Action fHistoryForwardAction;

    public HistoryManager(IShellProvider shellProvider) {
        this.fShellProvider = shellProvider;
    }

    protected void init(IMemento memento) {
    }

    protected void refresh() {
        this.fHistoryDropDownAction.setEnabled(this.fHistory.size() > 0);
        this.fHistoryForwardAction.setEnabled(this.fForwardStack.size() > 0);
        this.fHistoryBackAction.setEnabled(this.fBackwardStack.size() > 0);
        if (this.fForwardStack.size() > 0) {
            this.fHistoryForwardAction.setToolTipText(String.valueOf(Messages.HistoryManager_FORWARD_TOOLTIP) + ((IHistoryItem)this.fForwardStack.get(0)).getLabel());
        } else {
            this.fHistoryForwardAction.setToolTipText(null);
        }
        if (this.fBackwardStack.size() > 0) {
            this.fHistoryBackAction.setToolTipText(String.valueOf(Messages.HistoryManager_BACK_TOOLTIP) + ((IHistoryItem)this.fBackwardStack.get(this.fBackwardStack.size() - 1)).getLabel());
        } else {
            this.fHistoryBackAction.setToolTipText(null);
        }
    }

    public void installActions(IToolBarManager toolBarManager) {
        this.fHistoryDropDownAction = new HistoryDropDownAction();
        this.fHistoryDropDownAction.setEnabled(false);
        this.fHistoryDropDownAction.setText(Messages.HistoryManager_HISTORY_DROPDOWN_NAME);
        this.fHistoryDropDownAction.setToolTipText(Messages.HistoryManager_HISTORY_DROPDOWN_TOOLTIP);
        this.fHistoryBackAction = new Action(null){

            public void run() {
                HistoryManager.this.moveBackward();
            }
        };
        this.fHistoryBackAction.setImageDescriptor(ImagePool.HISTORY_BACK_ENABLED_ICON);
        this.fHistoryBackAction.setDisabledImageDescriptor(ImagePool.HISTORY_BACK_DISABLED_ICON);
        this.fHistoryBackAction.setEnabled(false);
        this.fHistoryForwardAction = new Action(null){

            public void run() {
                HistoryManager.this.moveForward();
            }
        };
        this.fHistoryForwardAction.setImageDescriptor(ImagePool.HISTORY_FORWARD_ENABLED_ICON);
        this.fHistoryForwardAction.setDisabledImageDescriptor(ImagePool.HISTORY_FORWARD_DISABLED_ICON);
        this.fHistoryForwardAction.setEnabled(false);
        toolBarManager.add((IAction)this.fHistoryDropDownAction);
    }

    protected void handleSelected(Object object) {
    }

    protected void saveState(IMemento memento) {
    }

    protected void pruneCache() {
        ArrayList<IHistoryItem> historyItems = new ArrayList<IHistoryItem>(this.fHistory.size());
        for (Object e : this.fHistory) {
            if (!(e instanceof IHistoryItem)) continue;
            historyItems.add((IHistoryItem)e);
        }
        Collections.sort(historyItems, new Comparator<IHistoryItem>(){

            @Override
            public int compare(IHistoryItem s1, IHistoryItem s2) {
                return s1.getLastCacheAccess() < s2.getLastCacheAccess() ? 1 : (s1.getLastCacheAccess() == s2.getLastCacheAccess() ? 0 : -1);
            }
        });
        int i = 5;
        while (i < historyItems.size()) {
            ((IHistoryItem)historyItems.get(i)).cleanUp();
            ++i;
        }
    }

    protected void setInput(IHistoryItem oldInput, IHistoryItem newInput) {
        this.fForwardStack.clear();
        if (oldInput != null) {
            this.fBackwardStack.remove(oldInput);
            this.fBackwardStack.add(oldInput);
        }
        if (newInput != null) {
            this.fHistory.remove(newInput);
            this.fBackwardStack.remove(newInput);
            this.fHistory.add(0, newInput);
            this.fCurrentItem = newInput;
        }
        this.refresh();
    }

    protected IHistoryItem getCurrentItem() {
        return this.fCurrentItem;
    }

    private void moveForward() {
        if (this.fForwardStack.isEmpty()) {
            return;
        }
        if (this.getCurrentItem() != null) {
            this.fBackwardStack.add(this.getCurrentItem());
        }
        this.fCurrentItem = (IHistoryItem)this.fForwardStack.remove(0);
        this.refresh();
        this.handleSelected(this.fCurrentItem);
    }

    private void moveBackward() {
        if (this.fBackwardStack.isEmpty()) {
            return;
        }
        if (this.getCurrentItem() != null) {
            this.fForwardStack.add(this.getCurrentItem());
        }
        this.fCurrentItem = this.fBackwardStack.pop();
        this.refresh();
        this.handleSelected(this.fCurrentItem);
    }

    class HistoryDropDownAction
    extends Action
    implements IMenuCreator {
        private Menu fMenu;

        public HistoryDropDownAction() {
            this.setImageDescriptor(ImagePool.HISTORY_ENABLED_ICON);
            this.setDisabledImageDescriptor(ImagePool.HISTORY_DISABLED_ICON);
            this.setMenuCreator(this);
        }

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
                this.fMenu = null;
            }
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public Menu getMenu(Control parent) {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
            this.fMenu = new Menu(parent);
            Iterator iterator = HistoryManager.this.fHistory.iterator();
            boolean checkedOne = false;
            int i = 0;
            while (iterator.hasNext() && i < 10) {
                IHistoryItem input = (IHistoryItem)iterator.next();
                ShowHistoryItemAction action = new ShowHistoryItemAction(input);
                action.setText(Utils.escapeText(input.getLabel()));
                boolean selected = HistoryManager.this.getCurrentItem() != null && HistoryManager.this.getCurrentItem().equals(input);
                action.setChecked(selected);
                if (selected) {
                    checkedOne = true;
                }
                this.addActionToMenu(this.fMenu, action);
                ++i;
            }
            new MenuItem(this.fMenu, 2);
            if (iterator.hasNext()) {
                ShowHistoryAction others = new ShowHistoryAction();
                others.setChecked(!checkedOne && HistoryManager.this.getCurrentItem() != null);
                this.addActionToMenu(this.fMenu, others);
            }
            Action clearHistoryAction = new Action(){

                public void run() {
                    HistoryManager.this.fHistory.clear();
                    HistoryManager.this.fBackwardStack.clear();
                    HistoryManager.this.fForwardStack.clear();
                    HistoryDropDownAction.this.setEnabled(false);
                }
            };
            clearHistoryAction.setText(Messages.HistoryManager_CLEAR_HISTORY_ACTION);
            this.addActionToMenu(this.fMenu, clearHistoryAction);
            return this.fMenu;
        }

        protected void addActionToMenu(Menu parent, Action action) {
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(parent, -1);
        }

        public void run() {
            new ShowHistoryAction().run(true);
        }

        void clear() {
            this.dispose();
        }
    }

    class ShowHistoryAction
    extends Action {
        public ShowHistoryAction() {
            super(Messages.HistoryManager_SHOW_OTHER_ACTION);
        }

        public void run() {
            this.run(false);
        }

        public void run(boolean showAll) {
            Object[] result;
            ShowHistoryItemAction selectedAction = null;
            final ArrayList<ShowHistoryItemAction> actions = new ArrayList<ShowHistoryItemAction>(HistoryManager.this.fHistory.size());
            int i = showAll ? 0 : 10;
            while (i < HistoryManager.this.fHistory.size()) {
                IHistoryItem input = (IHistoryItem)HistoryManager.this.fHistory.get(i);
                ShowHistoryItemAction action = new ShowHistoryItemAction(input);
                actions.add(action);
                if (input.equals(HistoryManager.this.getCurrentItem())) {
                    selectedAction = action;
                }
                ++i;
            }
            String title = Messages.HistoryManager_QUERY_HISTORY_DIALOG_TITLE;
            String message = Messages.HistoryManager_QUERY_HISTORY_DIALOG_MESSAGE;
            IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public Object[] getElements(Object element) {
                    return actions.toArray();
                }
            };
            ListDialog dlg = new ListDialog(HistoryManager.this.fShellProvider.getShell());
            dlg.setMessage(message);
            dlg.setTitle(title);
            dlg.setInput(actions);
            dlg.setContentProvider(contentProvider);
            dlg.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return ((ShowHistoryItemAction)((Object)element)).fInput.getLabel();
                }
            });
            if (selectedAction != null) {
                dlg.setInitialSelections(new Object[]{selectedAction});
            }
            if (dlg.open() == 0 && (result = dlg.getResult()) != null && result.length == 1) {
                ((ShowHistoryItemAction)((Object)result[0])).run();
            }
        }
    }

    class ShowHistoryItemAction
    extends Action {
        private IHistoryItem fInput;

        public ShowHistoryItemAction(IHistoryItem input) {
            this.fInput = input;
        }

        public void run() {
            HistoryManager.this.fForwardStack.clear();
            HistoryManager.this.fBackwardStack.remove(this.fInput);
            IHistoryItem input = HistoryManager.this.getCurrentItem();
            if (input != null && input != this.fInput) {
                HistoryManager.this.fBackwardStack.remove(input);
                HistoryManager.this.fBackwardStack.add(input);
            }
            HistoryManager.this.fCurrentItem = this.fInput;
            HistoryManager.this.refresh();
            HistoryManager.this.handleSelected(this.fInput);
        }
    }
}

