/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.dashboard;

import com.ibm.icu.text.Collator;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.IGroupingProvider;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.IQuerySummary;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.Messages;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkItemGroupingProvider
implements IGroupingProvider {
    protected static String EMPTY_LABEL = Messages.WorkItemGroupingProvider_NOT_SET_LITERAL;
    private Comparator<IQuerySummary> fDefaultSummaryComparator = new Comparator<IQuerySummary>(){
        private Collator collator = Collator.getInstance();

        @Override
        public int compare(IQuerySummary o1, IQuerySummary o2) {
            return this.collator.compare(o1.getLabel(), o2.getLabel());
        }
    };
    private final Identifier<IAttribute> fIdentifier;
    private final String fLabel;

    public WorkItemGroupingProvider(String label, Identifier<IAttribute> identifier) {
        this.fLabel = label;
        this.fIdentifier = identifier;
    }

    @Override
    public String getId() {
        return this.fIdentifier.getStringIdentifier();
    }

    @Override
    public String getDisplayName() {
        return this.fLabel;
    }

    @Override
    public boolean supportsShowAllGroups() {
        return false;
    }

    @Override
    public IQueryableAttribute getAttribute(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IAuditableClient.class);
        IQueryableAttributeFactory factory = QueryableAttributes.getFactory((IItemType)IWorkItem.ITEM_TYPE);
        return factory.findAttribute(projectArea, this.getAttributeIdentifier(), (IAuditableCommon)auditableClient, monitor);
    }

    protected String getAttributeIdentifier() {
        return WorkItemAttributes.getAttributeId(this.fIdentifier);
    }

    @Override
    public void sort(List<IQuerySummary> summaries) {
        Collections.sort(summaries, this.fDefaultSummaryComparator);
    }
}

