/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.dashboard;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.internal.util.SeparatedStringList;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.AbstractGroupingCollector;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.IGroupingCollector;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.QuerySummary;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.WorkItemGroupingProvider;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagGroupingProvider
extends WorkItemGroupingProvider {
    public TagGroupingProvider(String label, Identifier<IAttribute> identifier) {
        super(label, identifier);
    }

    @Override
    public IGroupingCollector createCollector(IGroupingCollector.Mode mode) {
        return new DefaultCollector();
    }

    private static class DefaultCollector
    extends AbstractGroupingCollector {
        private DefaultCollector() {
        }

        public void add(IProjectAreaHandle projectArea, String key, int count, IProgressMonitor monitor) throws TeamRepositoryException {
            SeparatedStringList tags = new SeparatedStringList(key);
            if (tags.isEmpty()) {
                QuerySummary summary = this.findSummary(key);
                summary.addCount(count);
            } else {
                for (String tag : tags) {
                    QuerySummary summary = this.findSummary(tag);
                    summary.addCount(count);
                }
            }
        }

        private QuerySummary findSummary(String key) {
            QuerySummary summary = this.findExisting(key);
            if (summary == null) {
                summary = new QuerySummary(this.isEmptyKey(key) ? EMPTY_LABEL : key, 0);
                summary.addValue(key);
                this.addSummary(summary);
            }
            return summary;
        }
    }
}

