/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.dashboard;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IResolution;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.ICombinedWorkflowInfos;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.AbstractGroupingCollector;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.IGroupingCollector;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.QuerySummary;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.WorkItemGroupingProvider;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolutionGroupingProvider
extends WorkItemGroupingProvider {
    public ResolutionGroupingProvider(String label, Identifier<IAttribute> identifier) {
        super(label, identifier);
    }

    @Override
    public boolean supportsShowAllGroups() {
        return true;
    }

    @Override
    public IGroupingCollector createCollector(IGroupingCollector.Mode mode) {
        return new ResolutionCollector(mode);
    }

    private static class ResolutionCollector
    extends AbstractGroupingCollector {
        private final IGroupingCollector.Mode fMode;

        public ResolutionCollector(IGroupingCollector.Mode mode) {
            this.fMode = mode;
        }

        public void add(IProjectAreaHandle projectArea, String key, int count, IProgressMonitor monitor) throws TeamRepositoryException {
            QuerySummary summary = this.findSummary(projectArea, key, monitor);
            summary.addCount(count);
        }

        private QuerySummary findSummary(IProjectAreaHandle projectArea, String key, IProgressMonitor monitor) throws TeamRepositoryException {
            QuerySummary summary;
            if (IGroupingCollector.Mode.ALL_VALUES == this.fMode && this.isEmpty()) {
                IWorkItemClient workItemClient = (IWorkItemClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IWorkItemClient.class);
                ICombinedWorkflowInfos workflowInfos = workItemClient.findCombinedWorkflowInfos(projectArea, monitor);
                Identifier[] identifierArray = workflowInfos.getAllResolutionIds();
                int n = identifierArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Identifier resolutionId = identifierArray[n2];
                    QuerySummary summary2 = new QuerySummary(workflowInfos.getResolutionName(resolutionId), 0);
                    summary2.addValue(resolutionId.getStringIdentifier());
                    this.addSummary(summary2);
                    ++n2;
                }
            }
            if ((summary = this.findExisting(key)) == null) {
                IWorkItemClient workItemClient = (IWorkItemClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IWorkItemClient.class);
                ICombinedWorkflowInfos workflowInfos = workItemClient.findCombinedWorkflowInfos(projectArea, monitor);
                String resolutionName = null;
                if (this.isEmptyKey(key)) {
                    resolutionName = EMPTY_LABEL;
                } else {
                    Identifier resolutionId = Identifier.create(IResolution.class, (String)key);
                    resolutionName = workflowInfos.getResolutionName(resolutionId);
                }
                summary = new QuerySummary(resolutionName != null ? resolutionName : key, 0);
                summary.addValue(key);
                this.addSummary(summary);
            }
            return summary;
        }
    }
}

